/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.vec;

import java.util.Arrays;
import java.util.HashMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.kink_lang.kink.StrVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.contract.Preconds;
import org.kink_lang.kink.internal.vec.MaybeTrait;
import org.kink_lang.kink.internal.vec.TraitError;
import org.kink_lang.kink.internal.vec.TraitVecInternal;
import org.kink_lang.kink.internal.vec.VecInternal;

class MutableVecInternal
extends VecInternal {
    MutableVecInternal(Vm vm, Val[] vals, int size) {
        super(vm, vals, size);
    }

    private void slideLeft(int src, int dest, int len) {
        for (int i = 0; i < len; ++i) {
            Val v = VALS_VH.getAcquire(this.vals, src + i);
            VALS_VH.setRelease(this.vals, dest + i, v);
        }
    }

    private void slideRight(int src, int dest, int len) {
        for (int i = len - 1; i >= 0; --i) {
            Val v = VALS_VH.getAcquire(this.vals, src + i);
            VALS_VH.setRelease(this.vals, dest + i, v);
        }
    }

    private void fillNada(int from, int to) {
        for (int i = from; i < to; ++i) {
            VALS_VH.setRelease(this.vals, i, this.vm.nada);
        }
    }

    private void copyIn(Val[] src, int from, int len, int destInd) {
        for (int i = 0; i < len; ++i) {
            Val v = src[from + i];
            VALS_VH.setRelease(this.vals, destInd + i, v);
        }
    }

    @Override
    @Nullable
    public MaybeTrait getTrait() {
        int size = this.size;
        if (size % 2 != 0) {
            return new TraitError.ArityNotEven(size);
        }
        Val[] newVals = new Val[size];
        HashMap<Integer, Val> mapping = new HashMap<Integer, Val>();
        for (int i = 0; i < size; i += 2) {
            Val symVal = VALS_VH.getAcquire(this.vals, i);
            if (!(symVal instanceof StrVal)) {
                return new TraitError.SymNotStr(i, symVal);
            }
            StrVal sym = (StrVal)symVal;
            Val content = VALS_VH.getAcquire(this.vals, i + 1);
            newVals[i] = sym;
            newVals[i + 1] = content;
            int symHandle = this.vm.sym.handleFor(sym.string());
            mapping.put(symHandle, content);
        }
        return new TraitVecInternal(this.vm, newVals, this.vm.sharedVars.of(mapping));
    }

    @Override
    @CheckReturnValue
    public VecInternal set(int index, Val val) {
        Preconds.checkElemIndex(index, this.capa());
        VALS_VH.setRelease(this.vals, index, val);
        return this;
    }

    @Override
    @CheckReturnValue
    public VecInternal remove(int index) {
        Preconds.checkElemIndex(index, this.capa());
        int orgSize = this.size;
        int newSize = orgSize - 1;
        int moved = newSize - index;
        if (moved < 0) {
            return this;
        }
        this.slideLeft(index + 1, index, moved);
        VALS_VH.setRelease(this.vals, newSize, this.vm.nada);
        this.size = newSize;
        return this;
    }

    @Override
    @CheckReturnValue
    public VecInternal removeRange(int from, int to) {
        Preconds.checkRange(from, to, this.capa());
        int orgSize = this.size;
        int newSize = orgSize - (to - from);
        int moved = orgSize - to;
        if (moved < 0) {
            return this;
        }
        this.slideLeft(to, from, moved);
        this.fillNada(newSize, orgSize);
        this.size = newSize;
        return this;
    }

    @Override
    @CheckReturnValue
    public VecInternal insert(int index, Val val) {
        Preconds.checkPosIndex(index, this.capa());
        int orgSize = this.size;
        if (index > orgSize) {
            return this;
        }
        int newSize = orgSize + 1;
        if (newSize <= this.capa()) {
            int moved = orgSize - index;
            this.slideRight(index, index + 1, moved);
            VALS_VH.setRelease(this.vals, index, val);
            this.size = newSize;
            return this;
        }
        int newCapa = MutableVecInternal.calcCapa(newSize);
        Object[] newVals = new Val[newCapa];
        this.copyOut(0, index, (Val[])newVals, 0);
        newVals[index] = val;
        this.copyOut(index, orgSize - index, (Val[])newVals, index + 1);
        Arrays.fill(newVals, newSize, newVals.length, this.vm.nada);
        return new MutableVecInternal(this.vm, (Val[])newVals, newSize);
    }

    @Override
    @CheckReturnValue
    public VecInternal insertAll(int index, VecInternal added) {
        Preconds.checkPosIndex(index, this.capa());
        int orgSize = this.size;
        if (index > orgSize) {
            return this;
        }
        int addedSize = added.size();
        int newSize = orgSize + addedSize;
        int moved = orgSize - index;
        if (newSize <= this.capa()) {
            this.slideRight(index, index + addedSize, moved);
            added.copyOutRelease(0, addedSize, this.vals, index);
            this.size = newSize;
            return this;
        }
        int newCapa = MutableVecInternal.calcCapa(newSize);
        Object[] newVals = new Val[newCapa];
        this.copyOut(0, index, (Val[])newVals, 0);
        added.copyOut(0, addedSize, (Val[])newVals, index);
        this.copyOut(index, moved, (Val[])newVals, index + addedSize);
        Arrays.fill(newVals, newSize, newVals.length, this.vm.nada);
        return new MutableVecInternal(this.vm, (Val[])newVals, newSize);
    }

    @Override
    @CheckReturnValue
    public VecInternal insertRange(int index, Val[] src, int from, int to) {
        Preconds.checkPosIndex(index, this.capa());
        Preconds.checkRange(from, to, src.length);
        int orgSize = this.size;
        if (index > orgSize) {
            return this;
        }
        int addedSize = to - from;
        int newSize = orgSize + addedSize;
        int moved = orgSize - index;
        if (newSize <= this.capa()) {
            this.slideRight(index, index + addedSize, moved);
            this.copyIn(src, from, addedSize, index);
            this.size = newSize;
            return this;
        }
        int newCapa = MutableVecInternal.calcCapa(newSize);
        Object[] newVals = new Val[newCapa];
        this.copyOut(0, index, (Val[])newVals, 0);
        System.arraycopy(src, from, newVals, index, addedSize);
        this.copyOut(index, moved, (Val[])newVals, index + addedSize);
        Arrays.fill(newVals, newSize, newVals.length, this.vm.nada);
        return new MutableVecInternal(this.vm, (Val[])newVals, newSize);
    }

    private static int calcCapa(int size) {
        return Math.max(size, (int)((double)size * 1.25));
    }
}

