/*
 * Decompiled with CFR 0.152.
 */
package org.kinotic.continuum.grind.api;

import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import org.kinotic.continuum.grind.api.Task;
import org.kinotic.continuum.grind.internal.api.InstanceTask;
import org.kinotic.continuum.grind.internal.api.NoopTask;
import org.kinotic.continuum.grind.internal.api.ValueTask;
import org.springframework.context.support.GenericApplicationContext;

public class Tasks {
    public static <R> Task<R> fromCallable(Callable<R> instance) {
        return Tasks.fromCallable(null, instance);
    }

    public static <R> Task<R> fromCallable(String description, Callable<R> instance) {
        return new InstanceTask<Callable, Object>(description, instance, callable -> {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static <R> Task<R> fromSupplier(Supplier<R> instance) {
        return Tasks.fromSupplier(null, instance);
    }

    public static <R> Task<R> fromSupplier(String description, Supplier<R> instance) {
        return new InstanceTask<Supplier, Object>(description, instance, Supplier::get);
    }

    public static <T> Task<T> fromValue(T value) {
        return Tasks.fromValue(null, value);
    }

    public static <T> Task<T> fromValue(String description, T value) {
        return new ValueTask<T>(description, value);
    }

    public static Task<Void> fromRunnable(Runnable instance) {
        return Tasks.fromRunnable(null, instance);
    }

    public static Task<Void> fromRunnable(String description, Runnable instance) {
        return new InstanceTask<Runnable, Void>(description, instance, runnable -> {
            runnable.run();
            return null;
        });
    }

    public static <T> Task<T> noop(String description) {
        return new NoopTask(description);
    }

    public static <T> Task<T> noop() {
        return new NoopTask();
    }

    public static <T, R> Task<R> transformResult(final Task<T> from, final Function<T, R> transformer) {
        return new Task<R>(){

            @Override
            public String getDescription() {
                return from.getDescription();
            }

            @Override
            public R execute(GenericApplicationContext applicationContext) throws Exception {
                return transformer.apply(from.execute(applicationContext));
            }
        };
    }
}

