/*
 * Decompiled with CFR 0.152.
 */
package org.kinotic.continuum.grind.internal.api;

import java.lang.invoke.CallSite;
import java.util.function.Supplier;
import org.kinotic.continuum.grind.api.Diagnostic;
import org.kinotic.continuum.grind.api.DiagnosticLevel;
import org.kinotic.continuum.grind.api.Progress;
import org.kinotic.continuum.grind.api.Result;
import org.kinotic.continuum.grind.api.ResultOptions;
import org.kinotic.continuum.grind.api.ResultType;
import org.kinotic.continuum.grind.api.Step;
import org.kinotic.continuum.grind.api.StepInfo;
import org.kinotic.continuum.grind.internal.api.DefaultResult;
import org.slf4j.Logger;
import reactor.core.publisher.FluxSink;

public abstract class AbstractStep
implements Step {
    protected final int sequence;

    public AbstractStep(int sequence) {
        this.sequence = sequence;
    }

    @Override
    public int getSequence() {
        return this.sequence;
    }

    protected void notifyProgress(Supplier<Progress> progressSupplier, FluxSink<Result<?>> sink, ResultOptions options, Logger log) {
        Progress progress;
        Progress progress2 = progress = options.isEnableProgressResults() || log.isDebugEnabled() ? progressSupplier.get() : new Progress();
        if (log.isDebugEnabled()) {
            log.debug(progress.getMessage() + " (" + progress.getPercentageComplete() + "%)");
        }
        if (options.isEnableProgressResults()) {
            sink.next(new DefaultResult<Progress>(new StepInfo(this.sequence), ResultType.PROGRESS, progress));
        }
    }

    protected void notifyDiagnostic(DiagnosticLevel diagnosticLevel, Supplier<String> messageSupplier, FluxSink<Result<?>> sink, ResultOptions options, Logger log) {
        String message;
        String string = message = diagnosticLevel.ordinal() >= options.getDiagnosticsLevel().ordinal() || log.isTraceEnabled() ? messageSupplier.get() : "";
        if (log.isTraceEnabled()) {
            log.trace(message);
        }
        if (options.getDiagnosticsLevel().ordinal() >= diagnosticLevel.ordinal()) {
            sink.next(new DefaultResult<Diagnostic>(new StepInfo(this.sequence), ResultType.DIAGNOSTIC, new Diagnostic(diagnosticLevel, message)));
        }
    }

    protected void notifyException(Supplier<String> messageSupplier, Throwable throwable, FluxSink<Result<?>> sink, ResultOptions options, Logger log) {
        String message;
        String string = message = options.isEnableProgressResults() || log.isDebugEnabled() ? messageSupplier.get() : "";
        if (log.isDebugEnabled()) {
            log.debug(message, throwable);
        }
        if (options.isEnableProgressResults()) {
            sink.next(new DefaultResult<CallSite>(new StepInfo(this.sequence), ResultType.EXCEPTION, (CallSite)((Object)(message + " Exception: " + throwable.getMessage()))));
        }
    }
}

