/*
 * Decompiled with CFR 0.152.
 */
package org.kinotic.continuum.grind.internal.api;

import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.kinotic.continuum.grind.api.JobDefinition;
import org.kinotic.continuum.grind.api.JobScope;
import org.kinotic.continuum.grind.api.Step;
import org.kinotic.continuum.grind.api.Task;
import org.kinotic.continuum.grind.internal.api.JobDefinitionStep;
import org.kinotic.continuum.grind.internal.api.TaskStep;

public class DefaultJobDefinition
implements JobDefinition {
    private final String description;
    private final JobScope jobScope;
    private final boolean parallel;
    private final LinkedList<Step> steps = new LinkedList();

    public DefaultJobDefinition(String description, JobScope jobScope, boolean parallel) {
        this.description = description != null ? description : UUID.randomUUID().toString();
        this.jobScope = jobScope;
        this.parallel = parallel;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isParallel() {
        return this.parallel;
    }

    @Override
    public JobScope getScope() {
        return this.jobScope;
    }

    @Override
    public JobDefinition task(Task<?> task) {
        this.steps.add(new TaskStep(this.steps.size() + 1, task));
        return this;
    }

    @Override
    public JobDefinition taskStoreResult(Task<?> task) {
        this.steps.add(new TaskStep(this.steps.size() + 1, task, true));
        return this;
    }

    @Override
    public JobDefinition taskStoreResult(Task<?> task, String variableName) {
        this.steps.add(new TaskStep(this.steps.size() + 1, task, true, variableName));
        return this;
    }

    @Override
    public JobDefinition jobDefinition(JobDefinition jobDefinition) {
        this.steps.add(new JobDefinitionStep(this.steps.size() + 1, jobDefinition));
        return this;
    }

    @Override
    public List<Step> getSteps() {
        return this.steps;
    }
}

