/*
 * Decompiled with CFR 0.152.
 */
package org.kinotic.continuum.grind.internal.api;

import org.apache.commons.lang3.Validate;
import org.kinotic.continuum.grind.api.DiagnosticLevel;
import org.kinotic.continuum.grind.api.JobDefinition;
import org.kinotic.continuum.grind.api.JobService;
import org.kinotic.continuum.grind.api.Result;
import org.kinotic.continuum.grind.api.ResultOptions;
import org.kinotic.continuum.grind.internal.api.JobDefinitionStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;

@Component
public class DefaultJobService
implements JobService,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultJobService.class);
    private GenericApplicationContext applicationContext;

    @Override
    public Flux<Result<?>> assemble(JobDefinition jobDefinition) {
        return this.assemble(jobDefinition, new ResultOptions(DiagnosticLevel.NONE, false));
    }

    @Override
    public Flux<Result<?>> assemble(JobDefinition jobDefinition, ResultOptions options) {
        Validate.notNull((Object)jobDefinition, (String)"JobDefinition Must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)options, (String)"Options Must not be null", (Object[])new Object[0]);
        return Flux.defer(() -> {
            JobDefinitionStep jobDefinitionStep = new JobDefinitionStep(0, jobDefinition);
            return jobDefinitionStep.assemble(this.applicationContext, options);
        });
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (GenericApplicationContext)applicationContext;
    }
}

