/*
 *
 * Copyright 2008-2021 Kinotic and the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kinotic.continuum.grind.api;

/**
 *
 * Created by Navid Mitchell on 11/12/20
 */
public class Diagnostic {

    private DiagnosticLevel diagnosticLevel;
    private String message;

    public Diagnostic() {
    }

    public Diagnostic(DiagnosticLevel diagnosticLevel, String message) {
        this.diagnosticLevel = diagnosticLevel;
        this.message = message;
    }

    public DiagnosticLevel getDiagnosticType() {
        return diagnosticLevel;
    }

    public Diagnostic setDiagnosticType(DiagnosticLevel diagnosticLevel) {
        this.diagnosticLevel = diagnosticLevel;
        return this;
    }

    public String getMessage() {
        return message;
    }

    public Diagnostic setMessage(String message) {
        this.message = message;
        return this;
    }

}
