/*
 * Decompiled with CFR 0.152.
 */
package org.kinotic.continuum.grind.internal.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kinotic.continuum.grind.api.DiagnosticLevel;
import org.kinotic.continuum.grind.api.HasSteps;
import org.kinotic.continuum.grind.api.JobDefinition;
import org.kinotic.continuum.grind.api.JobScope;
import org.kinotic.continuum.grind.api.Progress;
import org.kinotic.continuum.grind.api.Result;
import org.kinotic.continuum.grind.api.ResultOptions;
import org.kinotic.continuum.grind.api.ResultType;
import org.kinotic.continuum.grind.api.Step;
import org.kinotic.continuum.grind.api.StepInfo;
import org.kinotic.continuum.grind.internal.api.AbstractStep;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.scheduler.Schedulers;

public class JobDefinitionStep
extends AbstractStep
implements HasSteps {
    private static final Logger log = LoggerFactory.getLogger(JobDefinitionStep.class);
    private final JobDefinition jobDefinition;
    private final String taskDisplayString;

    public JobDefinitionStep(int sequence, JobDefinition jobDefinition) {
        super(sequence);
        this.jobDefinition = jobDefinition;
        this.taskDisplayString = "\"" + jobDefinition.getDescription() + "\"";
    }

    @Override
    public String getDescription() {
        return this.jobDefinition.getDescription();
    }

    @Override
    public Publisher<Result<?>> assemble(GenericApplicationContext applicationContext, ResultOptions options) {
        return Flux.create(sink -> {
            try {
                GenericApplicationContext temp;
                this.notifyProgress(() -> new Progress(0, "JobDefinition: " + this.taskDisplayString + " Scope: " + String.valueOf((Object)this.jobDefinition.getScope()) + " Executing"), (FluxSink<Result<?>>)sink, options, log);
                boolean cleanupContextOnFinallyDecision = false;
                if (this.jobDefinition.getScope() == JobScope.CHILD) {
                    temp = this.createContext(applicationContext);
                } else if (this.jobDefinition.getScope() == JobScope.ISOLATED) {
                    temp = this.createContext(null);
                    cleanupContextOnFinallyDecision = true;
                } else if (this.jobDefinition.getScope() == JobScope.PARENT) {
                    temp = applicationContext;
                } else {
                    throw new IllegalStateException("Unknown JobDefinition Scope " + String.valueOf((Object)this.jobDefinition.getScope()));
                }
                GenericApplicationContext contextToUse = temp;
                this.notifyDiagnostic(DiagnosticLevel.TRACE, () -> "JobDefinition: " + this.taskDisplayString + " Assembling Steps", (FluxSink<Result<?>>)sink, options, log);
                ArrayList assembledTaskDefinitions = new ArrayList();
                for (Step step : this.jobDefinition.getSteps()) {
                    assembledTaskDefinitions.add(step.assemble(contextToUse, options));
                }
                Flux jobFlux = this.jobDefinition.isParallel() ? Flux.merge(assembledTaskDefinitions).parallel().runOn(Schedulers.parallel()).sequential() : Flux.concat(assembledTaskDefinitions);
                int percentPerStep = assembledTaskDefinitions.size() > 0 ? (int)Math.floor(100.0f / (float)assembledTaskDefinitions.size()) : 100;
                ProgressHolder progressHolder = new ProgressHolder();
                boolean cleanupContextOnFinally = cleanupContextOnFinallyDecision;
                Disposable disposable = jobFlux.doOnNext(result -> {
                    if (result.getResultType() == ResultType.PROGRESS) {
                        Progress resultProgress = (Progress)result.getValue();
                        if (resultProgress.getPercentageComplete() < 100) {
                            this.notifyProgress(() -> new Progress(progressHolder.getPercentageComplete(), resultProgress.getMessage()), (FluxSink<Result<?>>)sink, options, log);
                        } else if (resultProgress.getPercentageComplete() == 100) {
                            progressHolder.incrementPercentageComplete(percentPerStep);
                            this.notifyProgress(() -> new Progress(progressHolder.getPercentageComplete(), resultProgress.getMessage()), (FluxSink<Result<?>>)sink, options, log);
                        }
                    }
                    result.getStepInfo().addAncestor(new StepInfo(this.sequence));
                    sink.next(result);
                }).doOnError(throwable -> {
                    this.notifyException(() -> "JobDefinition: " + this.taskDisplayString + " Exception during execution ", (Throwable)throwable, (FluxSink<Result<?>>)sink, options, log);
                    sink.error(throwable);
                }).doOnComplete(() -> {
                    this.notifyProgress(() -> new Progress(100, "JobDefinition: " + this.taskDisplayString + " Finished Executing"), (FluxSink<Result<?>>)sink, options, log);
                    sink.complete();
                }).doFinally(signalType -> {
                    if (cleanupContextOnFinally) {
                        this.notifyDiagnostic(DiagnosticLevel.TRACE, () -> "JobDefinition: " + this.taskDisplayString + " Closing Job Execution Context", (FluxSink<Result<?>>)sink, options, log);
                        contextToUse.close();
                    }
                }).subscribe();
                sink.onCancel(disposable);
            }
            catch (Exception throwable2) {
                this.notifyException(() -> "JobDefinition: " + this.taskDisplayString + " Exception during execution ", throwable2, (FluxSink<Result<?>>)sink, options, log);
                sink.error((Throwable)throwable2);
            }
        });
    }

    @Override
    public List<Step> getSteps() {
        return this.jobDefinition.getSteps();
    }

    private GenericApplicationContext createContext(GenericApplicationContext applicationContext) {
        AnnotationConfigApplicationContext ret = new AnnotationConfigApplicationContext();
        ret.getEnvironment().getPropertySources().addLast((PropertySource)new MapPropertySource("__grindJobContext", new HashMap()));
        if (applicationContext != null) {
            ret.setParent((ApplicationContext)applicationContext);
        }
        ret.refresh();
        return ret;
    }

    private static class ProgressHolder {
        private int percentageComplete = 0;

        public int getPercentageComplete() {
            return this.percentageComplete;
        }

        public void incrementPercentageComplete(int progress) {
            this.percentageComplete += progress;
            if (this.percentageComplete > 100) {
                this.percentageComplete = 100;
            }
        }
    }
}

