/*
 * Decompiled with CFR 0.152.
 */
package org.kinotic.continuum.grind.internal.api;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.ClassUtils;
import org.kinotic.continuum.grind.api.DiagnosticLevel;
import org.kinotic.continuum.grind.api.JobDefinition;
import org.kinotic.continuum.grind.api.Progress;
import org.kinotic.continuum.grind.api.Result;
import org.kinotic.continuum.grind.api.ResultOptions;
import org.kinotic.continuum.grind.api.ResultType;
import org.kinotic.continuum.grind.api.StepInfo;
import org.kinotic.continuum.grind.api.Task;
import org.kinotic.continuum.grind.internal.api.AbstractStep;
import org.kinotic.continuum.grind.internal.api.DefaultResult;
import org.kinotic.continuum.grind.internal.api.JobDefinitionStep;
import org.kinotic.continuum.grind.internal.api.NoopTask;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.env.MapPropertySource;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class TaskStep
extends AbstractStep {
    private static final Logger log = LoggerFactory.getLogger(TaskStep.class);
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;
    private final Task<?> task;
    private final boolean storeResult;
    private final String resultName;
    private final String taskDisplayString;

    public TaskStep(int sequence, Task<?> task) {
        this(sequence, task, false, null);
    }

    public TaskStep(int sequence, Task<?> task, boolean storeResult) {
        this(sequence, task, storeResult, null);
    }

    public TaskStep(int sequence, Task<?> task, boolean storeResult, String resultName) {
        super(sequence);
        this.task = task;
        this.storeResult = storeResult;
        this.resultName = resultName;
        this.taskDisplayString = "\"" + task.getDescription() + "\"";
        this.reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();
    }

    @Override
    public String getDescription() {
        return this.task.getDescription();
    }

    @Override
    public Publisher<Result<?>> assemble(GenericApplicationContext applicationContext, ResultOptions options) {
        return Flux.create(sink -> {
            try {
                this.notifyProgress(() -> new Progress(0, "Task: " + this.taskDisplayString + " Executing"), (FluxSink<Result<?>>)sink, options, log);
                if (!(this.task instanceof NoopTask)) {
                    Object result = this.task.execute(applicationContext);
                    if (result instanceof JobDefinition) {
                        this.completeWithJobDefinition(applicationContext, options, (FluxSink<Result<?>>)sink, (JobDefinition)result);
                    } else if (result instanceof Task) {
                        this.completeWithTask(applicationContext, options, (FluxSink<Result<?>>)sink, (Task)result);
                    } else {
                        this.completeWithResult(applicationContext, options, (FluxSink<Result<?>>)sink, result);
                    }
                } else {
                    log.debug("Task was noop {}", (Object)this.taskDisplayString);
                    sink.next(new DefaultResult<Object>(new StepInfo(this.sequence), ResultType.NOOP, null));
                    this.notifyProgress(() -> new Progress(100, "Task: " + this.taskDisplayString + " Finished Executing"), (FluxSink<Result<?>>)sink, options, log);
                    sink.complete();
                }
            }
            catch (Exception throwable) {
                this.notifyException(() -> "Task: " + this.taskDisplayString + " Exception during execution ", throwable, (FluxSink<Result<?>>)sink, options, log);
                sink.error((Throwable)throwable);
            }
        });
    }

    private void completeWithJobDefinition(GenericApplicationContext applicationContext, ResultOptions options, FluxSink<Result<?>> sink, JobDefinition jobDefinition) {
        this.notifyDiagnostic(DiagnosticLevel.TRACE, () -> "Task: " + this.taskDisplayString + " returned a JobDefinition: \"" + jobDefinition.getDescription() + "\"", sink, options, log);
        JobDefinitionStep jobDefinitionStep = new JobDefinitionStep(1, jobDefinition);
        sink.next(new DefaultResult<JobDefinitionStep>(new StepInfo(this.sequence), ResultType.DYNAMIC_STEPS, jobDefinitionStep));
        this.completeWithStep(options, sink, jobDefinitionStep.assemble(applicationContext, options));
    }

    private void completeWithTask(GenericApplicationContext applicationContext, ResultOptions options, FluxSink<Result<?>> sink, Task<?> task) {
        this.notifyDiagnostic(DiagnosticLevel.TRACE, () -> "Task: " + this.taskDisplayString + " returned a Task: \"" + task.getDescription() + "\"", sink, options, log);
        TaskStep taskStep = new TaskStep(1, task, this.storeResult, this.resultName);
        sink.next(new DefaultResult<TaskStep>(new StepInfo(this.sequence), ResultType.DYNAMIC_STEPS, taskStep));
        this.completeWithStep(options, sink, taskStep.assemble(applicationContext, options));
    }

    private void completeWithStep(ResultOptions options, FluxSink<Result<?>> sink, Publisher<Result<?>> assemble) {
        Disposable disposable = Flux.from(assemble).doOnNext(result -> {
            result.getStepInfo().addAncestor(new StepInfo(this.sequence));
            sink.next(result);
        }).doOnError(throwable -> {
            this.notifyException(() -> "Task: " + this.taskDisplayString + " Exception during execution ", (Throwable)throwable, sink, options, log);
            sink.error(throwable);
        }).doOnComplete(() -> {
            this.notifyProgress(() -> new Progress(100, "Task: " + this.taskDisplayString + " Finished Executing"), sink, options, log);
            sink.complete();
        }).subscribe();
        sink.onCancel(disposable);
    }

    private void completeWithResult(GenericApplicationContext applicationContext, ResultOptions options, FluxSink<Result<?>> sink, Object result) {
        if (result != null) {
            ReactiveAdapter reactiveAdapter = this.reactiveAdapterRegistry.getAdapter(null, result);
            if (reactiveAdapter != null) {
                this.notifyDiagnostic(DiagnosticLevel.TRACE, () -> "Task: " + this.taskDisplayString + " returned value of type:\"" + result.getClass().getName(), sink, options, log);
                Disposable disposable = Flux.from((Publisher)reactiveAdapter.toPublisher(result)).doOnNext(value -> {
                    if (value instanceof Result) {
                        Result resultInternal = (Result)value;
                        if (resultInternal.getResultType() == ResultType.VALUE) {
                            this.addIfDesiredToApplicationContext(applicationContext, options, sink, resultInternal.getValue());
                        }
                        resultInternal.getStepInfo().addAncestor(new StepInfo(this.sequence));
                        sink.next((Object)resultInternal);
                    } else {
                        this.addIfDesiredToApplicationContext(applicationContext, options, sink, value);
                        sink.next(new DefaultResult<Object>(new StepInfo(this.sequence), ResultType.VALUE, value));
                    }
                }).doOnError(throwable -> {
                    this.notifyException(() -> "Task: " + this.taskDisplayString + " Exception during execution ", (Throwable)throwable, sink, options, log);
                    sink.error(throwable);
                }).doOnComplete(() -> {
                    this.notifyProgress(() -> new Progress(100, "Task: " + this.taskDisplayString + " Finished Executing"), sink, options, log);
                    sink.complete();
                }).subscribe();
                sink.onCancel(disposable);
            } else {
                this.addIfDesiredToApplicationContext(applicationContext, options, sink, result);
                sink.next(new DefaultResult<Object>(new StepInfo(this.sequence), ResultType.VALUE, result));
                this.notifyProgress(() -> new Progress(100, "Task: " + this.taskDisplayString + " Finished Executing"), sink, options, log);
                sink.complete();
            }
        } else {
            if (this.storeResult) {
                this.notifyDiagnostic(DiagnosticLevel.WARN, () -> "Task: " + this.taskDisplayString + " Result was requested to be stored, but result is NULL", sink, options, log);
            }
            sink.next(new DefaultResult<Object>(new StepInfo(this.sequence), ResultType.VALUE, null));
            this.notifyProgress(() -> new Progress(100, "Task: " + this.taskDisplayString + " Finished Executing"), sink, options, log);
            sink.complete();
        }
    }

    private void addIfDesiredToApplicationContext(GenericApplicationContext applicationContext, ResultOptions options, FluxSink<Result<?>> sink, Object result) {
        if (this.storeResult) {
            if (result != null) {
                Class<?> clazz = result.getClass();
                ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
                MapPropertySource propertySource = (MapPropertySource)applicationContext.getEnvironment().getPropertySources().get("__grindJobContext");
                if (propertySource == null) {
                    throw new IllegalStateException("Expected MapPropertySource was not set for __grindJobContext");
                }
                if (this.isBeanCandidate(result)) {
                    if (result instanceof Collection) {
                        if (this.resultName != null && !this.resultName.isEmpty()) {
                            this.notifyDiagnostic(DiagnosticLevel.TRACE, () -> "Task: " + this.taskDisplayString + " Storing result as Collection Property \"" + this.resultName + "\" Value: " + String.valueOf(result), sink, options, log);
                            ((Map)propertySource.getSource()).put(this.resultName, result);
                        } else {
                            for (Object val : (Collection)result) {
                                String beanName = val.getClass().getSimpleName() + "_" + String.valueOf(UUID.randomUUID());
                                this.notifyDiagnostic(DiagnosticLevel.TRACE, () -> "Task: " + this.taskDisplayString + " Storing result as Singleton: \"" + beanName + "\" Value: " + String.valueOf(result), sink, options, log);
                                beanFactory.registerSingleton(beanName, val);
                            }
                        }
                    } else {
                        String beanName = this.resultName != null && !this.resultName.isEmpty() ? this.resultName : clazz.getSimpleName();
                        this.notifyDiagnostic(DiagnosticLevel.TRACE, () -> "Task: " + this.taskDisplayString + " Storing result as Singleton: \"" + beanName + "\" Value: " + String.valueOf(result), sink, options, log);
                        beanFactory.registerSingleton(beanName, result);
                    }
                } else if (this.resultName != null && !this.resultName.isEmpty()) {
                    this.notifyDiagnostic(DiagnosticLevel.TRACE, () -> "Task: " + this.taskDisplayString + " Storing result as Property: \"" + this.resultName + "\" Value: " + String.valueOf(result), sink, options, log);
                    ((Map)propertySource.getSource()).put(this.resultName, result);
                } else {
                    this.notifyDiagnostic(DiagnosticLevel.WARN, () -> "Task: " + this.taskDisplayString + " Cannot store Application Context Property. All primitive types must have a name defined.", sink, options, log);
                }
            } else {
                this.notifyDiagnostic(DiagnosticLevel.WARN, () -> "Task: " + this.taskDisplayString + " Result was requested to be stored, but result is NULL", sink, options, log);
            }
        }
    }

    private boolean isBeanCandidate(Object result) {
        boolean ret = false;
        Class<?> clazz = result.getClass();
        if (!(clazz.isArray() || clazz.isEnum() || ClassUtils.isPrimitiveOrWrapper(clazz) || clazz.isAnnotation() || result instanceof CharSequence || result instanceof Date || result instanceof Calendar)) {
            ret = true;
        }
        return ret;
    }
}

