/*
 * Decompiled with CFR 0.152.
 */
package org.kinotic.continuum.grind.internal.api;

import java.util.function.Function;
import org.kinotic.continuum.grind.internal.api.AbstractTask;
import org.springframework.context.support.GenericApplicationContext;

public class InstanceTask<T, R>
extends AbstractTask<R> {
    private final T instance;
    private final Function<T, R> invokerFunction;

    public InstanceTask(T instance, Function<T, R> invokerFunction) {
        this.instance = instance;
        this.invokerFunction = invokerFunction;
    }

    public InstanceTask(String description, T instance, Function<T, R> invokerFunction) {
        super(description);
        this.instance = instance;
        this.invokerFunction = invokerFunction;
    }

    @Override
    public R execute(GenericApplicationContext applicationContext) throws Exception {
        applicationContext.getAutowireCapableBeanFactory().autowireBean(this.instance);
        applicationContext.getAutowireCapableBeanFactory().initializeBean(this.instance, "");
        return this.invokerFunction.apply(this.instance);
    }
}

