/*
 * Decompiled with CFR 0.152.
 */
package org.kinotic.continuum.grind.api;

import org.apache.commons.lang3.Validate;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.MapPropertySource;

public class ContextUtils {
    public static <T> T getProperty(String propertyName, GenericApplicationContext applicationContext) {
        Validate.notBlank((CharSequence)propertyName, (String)"propertyName must not be blank", (Object[])new Object[0]);
        MapPropertySource propertySource = ContextUtils.getGrindPropertySource(applicationContext);
        return (T)propertySource.getProperty(propertyName);
    }

    public static MapPropertySource getGrindPropertySource(GenericApplicationContext applicationContext) {
        Validate.notNull((Object)applicationContext, (String)"applicationContext must not be null", (Object[])new Object[0]);
        MapPropertySource propertySource = (MapPropertySource)applicationContext.getEnvironment().getPropertySources().get("__grindJobContext");
        Validate.notNull((Object)propertySource, (String)"Could not find Grind property source", (Object[])new Object[0]);
        return propertySource;
    }
}

