/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mcp;

import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpServer;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.mcp.transport.VertxMcpTransport;
import io.vertx.ext.web.Router;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpVerticle
extends AbstractVerticle {
    private static final Logger log = LoggerFactory.getLogger(McpVerticle.class);
    private final int mcpPort;
    private final VertxMcpTransport transport;
    private final McpServer.AsyncSpecification<?> mcpServerSpec;
    private McpAsyncServer mcpServer;
    private HttpServer httpServer;

    public void start(Promise<Void> startPromise) throws Exception {
        this.mcpServer = this.mcpServerSpec.build();
        Router router = this.transport.getRouter();
        this.httpServer = this.vertx.createHttpServer();
        this.httpServer.requestHandler((Handler)router).listen(this.mcpPort, ar -> {
            if (ar.succeeded()) {
                log.info("MCP Transport server started on port {}", (Object)this.mcpPort);
                startPromise.complete();
            } else {
                log.error("Failed to start MCP Transport server", ar.cause());
                startPromise.fail(ar.cause());
            }
        });
    }

    public void stop(Promise<Void> stopPromise) throws Exception {
        if (this.mcpServer != null) {
            this.mcpServer.closeGracefully().doOnSuccess(v -> this.stopHttpServer(stopPromise)).doOnError(throwable -> {
                log.error("Error during MCP server graceful shutdown", throwable);
                this.stopHttpServer(stopPromise);
            }).subscribe();
        } else {
            this.stopHttpServer(stopPromise);
        }
    }

    private void stopHttpServer(Promise<Void> stopPromise) {
        if (this.httpServer != null) {
            this.httpServer.close(ar -> {
                if (ar.succeeded()) {
                    log.info("MCP Transport server stopped");
                    stopPromise.complete();
                } else {
                    log.error("Failed to stop MCP Transport server", ar.cause());
                    stopPromise.fail(ar.cause());
                }
            });
        } else {
            stopPromise.complete();
        }
    }

    @Generated
    public McpVerticle(int mcpPort, VertxMcpTransport transport, McpServer.AsyncSpecification<?> mcpServerSpec) {
        this.mcpPort = mcpPort;
        this.transport = transport;
        this.mcpServerSpec = mcpServerSpec;
    }
}

