/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mcp.transport;

import io.vertx.core.Vertx;
import java.time.Duration;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepAliveService {
    private static final Logger log = LoggerFactory.getLogger(KeepAliveService.class);
    private final Vertx vertx;
    private final Duration keepAliveInterval;
    private Long keepAliveTimerId;
    private volatile boolean isActive = true;

    public KeepAliveService(Vertx vertx, Duration keepAliveInterval) {
        this.vertx = vertx;
        this.keepAliveInterval = keepAliveInterval != null ? keepAliveInterval : Duration.ofSeconds(30L);
    }

    public void start(Consumer<Void> pingAction) {
        if (this.keepAliveInterval.isZero() || this.keepAliveInterval.isNegative()) {
            return;
        }
        long intervalMs = this.keepAliveInterval.toMillis();
        this.keepAliveTimerId = this.vertx.setPeriodic(intervalMs, timerId -> {
            if (this.isActive && pingAction != null) {
                log.trace("Sending keep-alive ping");
                pingAction.accept(null);
            }
        });
        log.debug("Started keep-alive ping mechanism with interval: {}", (Object)this.keepAliveInterval);
    }

    public void stop() {
        if (this.keepAliveTimerId != null) {
            this.vertx.cancelTimer(this.keepAliveTimerId.longValue());
            this.keepAliveTimerId = null;
            this.isActive = false;
            log.debug("Stopped keep-alive ping mechanism");
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public Duration getKeepAliveInterval() {
        return this.keepAliveInterval;
    }
}

