/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp.lite.frame;

import io.vertx.core.buffer.Buffer;
import io.vertx.ext.stomp.lite.frame.Frame;
import io.vertx.ext.stomp.lite.frame.Headers;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;

public interface Frames {
    public static final Frame PING = new Frame(Frame.Command.PING, (Map)Headers.create(), null){

        @Override
        public Buffer toBuffer() {
            return Buffer.buffer((String)"\n");
        }
    };

    public static Frame createErrorFrame(String message, Map<String, String> headers, String body) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(headers);
        Objects.requireNonNull(body);
        return new Frame(Frame.Command.ERROR, Headers.create(headers).add("message", message).add("content-length", Integer.toString(body.length())).add("content-type", "text/plain"), Buffer.buffer((String)body));
    }

    public static Frame createErrorFrame(Throwable throwable, boolean includeStackTrace) {
        Frame ret = includeStackTrace ? Frames.createErrorFrame(throwable.getMessage(), Headers.create(), ExceptionUtils.getStackTrace((Throwable)throwable)) : Frames.createErrorFrame(throwable.getMessage(), Headers.create(), "");
        return ret;
    }

    public static Frame createReceiptFrame(String receiptId, Map<String, String> headers) {
        Objects.requireNonNull(receiptId);
        Objects.requireNonNull(headers);
        return new Frame(Frame.Command.RECEIPT, Headers.create(headers).add("receipt-id", receiptId), null);
    }

    public static Frame ping() {
        return PING;
    }
}

