/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp.lite.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.ext.stomp.lite.StompServerHandlerFactory;
import io.vertx.ext.stomp.lite.StompServerOptions;
import io.vertx.ext.stomp.lite.frame.FrameException;
import io.vertx.ext.stomp.lite.frame.FrameParser;
import io.vertx.ext.stomp.lite.frame.InvalidConnectFrame;
import io.vertx.ext.stomp.lite.handler.DefaultStompServerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StompServerWebSocketHandler
implements Handler<ServerWebSocket> {
    private static final Logger log = LoggerFactory.getLogger(StompServerWebSocketHandler.class);
    private Vertx vertx;
    private StompServerOptions options;
    private StompServerHandlerFactory factory;

    public StompServerWebSocketHandler(Vertx vertx, StompServerOptions options, StompServerHandlerFactory factory) {
        this.vertx = vertx;
        this.options = options;
        this.factory = factory;
    }

    public void handle(ServerWebSocket socket) {
        DefaultStompServerConnection defaultStompServerConnection = new DefaultStompServerConnection(socket, this.vertx, this.options, this.factory);
        if (!socket.path().equals(this.options.getWebsocketPath())) {
            String error = "Receiving a web socket connection on an invalid path (" + socket.path() + "), the path is configured to " + this.options.getWebsocketPath() + ". Rejecting connection";
            log.error(error);
            socket.reject();
            defaultStompServerConnection.clientCausedException(new IllegalStateException(error), false);
        } else {
            socket.exceptionHandler(exception -> {
                log.debug("The STOMP server caught a WebSocket error - closing connection", exception);
                defaultStompServerConnection.clientCausedException((Throwable)exception, false);
            });
            socket.closeHandler(v -> defaultStompServerConnection.close());
            FrameParser parser = new FrameParser(this.options);
            parser.errorHandler((Handler<FrameException>)((Handler)exception -> defaultStompServerConnection.clientCausedException((Throwable)exception, false))).handler(defaultStompServerConnection);
            socket.handler(buffer -> {
                if (!defaultStompServerConnection.isConnected()) {
                    if (buffer.length() > this.options.getMaxConnectFrameLength()) {
                        log.debug("Client sent a frame larger than the maximum allowed connect frame");
                        defaultStompServerConnection.clientCausedException(new InvalidConnectFrame("Client sent a frame larger than the maximum allowed connect frame", (Buffer)buffer), false);
                    } else if (buffer.length() > 7) {
                        String possibleConnectCommand = new String(buffer.getBytes(0, 7));
                        if (possibleConnectCommand.equals("CONNECT")) {
                            FrameParser connectParser = new FrameParser(this.options);
                            connectParser.errorHandler((Handler<FrameException>)((Handler)exception -> defaultStompServerConnection.clientCausedException(new InvalidConnectFrame("Error parsing connect frame", (Throwable)exception, (Buffer)buffer), false))).handler(defaultStompServerConnection);
                            connectParser.handle((Buffer)buffer);
                        } else {
                            log.debug("Initial frame does not contain a connect command");
                            defaultStompServerConnection.clientCausedException(new InvalidConnectFrame("Initial frame does not contain a connect command", (Buffer)buffer), false);
                        }
                    } else {
                        log.debug("Client sent an incomplete connect frame");
                        defaultStompServerConnection.clientCausedException(new InvalidConnectFrame("Client sent an incomplete connect frame", (Buffer)buffer), false);
                    }
                } else {
                    parser.handle((Buffer)buffer);
                }
            });
        }
    }
}

