/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp.lite.frame;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.parsetools.RecordParser;
import io.vertx.ext.stomp.lite.StompServerOptions;
import io.vertx.ext.stomp.lite.frame.Frame;
import io.vertx.ext.stomp.lite.frame.FrameException;
import io.vertx.ext.stomp.lite.frame.Frames;
import io.vertx.ext.stomp.lite.frame.HeaderCodec;
import java.util.HashMap;
import java.util.Objects;

public class FrameParser
implements Handler<Buffer> {
    public static final String UTF_8 = "utf-8";
    public static final String NULL = "\u0000";
    public static final String EOL = "\n";
    public static final String CARRIAGE_RETURN = "\r";
    public static final char LINE_FEED = '\n';
    public static final String COLON = ":";
    public static final char ESCAPE = '\\';
    public static final String COMMA = ",";
    private final StompServerOptions properties;
    private Frame.Command command;
    private HashMap<String, String> headers = new HashMap();
    private Handler<Frame> handler;
    private int bodyLength = 0;
    private Handler<FrameException> errorHandler;
    private final RecordParser frameParser = RecordParser.newDelimited((String)"\n", this::handleLine);
    private State current = State.COMMAND;

    public FrameParser(StompServerOptions properties) {
        this.properties = properties;
    }

    public FrameParser() {
        this(new StompServerOptions());
    }

    public synchronized FrameParser handler(Handler<Frame> handler) {
        Objects.requireNonNull(handler);
        this.handler = handler;
        return this;
    }

    public synchronized FrameParser errorHandler(Handler<FrameException> handler) {
        this.errorHandler = handler;
        return this;
    }

    private void handleLine(Buffer buffer) {
        switch (this.current) {
            case COMMAND: {
                if (this.isEmpty(buffer)) {
                    this.reset();
                    this.handler.handle((Object)Frames.ping());
                    break;
                }
                String commandLine = buffer.toString(UTF_8).trim();
                try {
                    this.command = Frame.Command.valueOf(commandLine);
                }
                catch (IllegalArgumentException e) {
                    this.command = Frame.Command.UNKNOWN;
                    this.headers.put("frame-command", commandLine);
                }
                this.current = State.HEADERS;
                break;
            }
            case HEADERS: {
                if (this.isEmpty(buffer)) {
                    this.current = State.BODY;
                    String length = this.headers.get("content-length");
                    if (length != null) {
                        int contentLength = Integer.valueOf(length);
                        this.frameParser.fixedSizeMode(contentLength);
                        break;
                    }
                    this.frameParser.delimitedMode(NULL);
                    break;
                }
                String line = buffer.toString(UTF_8);
                int index = line.indexOf(COLON);
                if (index == -1) {
                    this.reportOrThrow("Invalid header line : '" + buffer + "'");
                    return;
                }
                String header = line.substring(0, index);
                String value = line.substring(index + 1);
                if (this.hasExceededNumberOfHeaders()) {
                    this.reportOrThrow("Number of headers exceeded");
                    return;
                }
                if (this.hasExceededHeaderLength(header, value)) {
                    this.reportOrThrow("Header length exceeded");
                    return;
                }
                this.headers.putIfAbsent(header, this.decode(this.strip(value)));
                break;
            }
            case BODY: {
                if (this.bodyLength == 0) {
                    this.bodyLength = buffer.length();
                    if (this.hasExceededBodySize()) {
                        this.reportOrThrow("Body size exceeded");
                        return;
                    }
                }
                try {
                    Frame frame = new Frame(this.command, this.headers, buffer);
                    this.reset();
                    this.handler.handle((Object)frame);
                    break;
                }
                catch (FrameException e) {
                    this.reportOrThrow("Malformed frame received");
                }
            }
        }
    }

    private void reset() {
        this.command = null;
        this.bodyLength = 0;
        this.headers = new HashMap();
        this.current = State.COMMAND;
        this.frameParser.delimitedMode(EOL);
    }

    private boolean hasExceededHeaderLength(String header, String value) {
        return value.length() > this.properties.getMaxHeaderLength() || header.length() > this.properties.getMaxHeaderLength();
    }

    private boolean hasExceededNumberOfHeaders() {
        return this.headers.size() + 1 > this.properties.getMaxHeaders();
    }

    private String decode(String value) {
        return HeaderCodec.decode(value, this.command == Frame.Command.CONNECT || this.command == Frame.Command.CONNECTED);
    }

    private String strip(String s) {
        if (s.endsWith(CARRIAGE_RETURN)) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    private boolean isEmpty(Buffer buffer) {
        return buffer.toString().length() == 0 || buffer.toString().equals(CARRIAGE_RETURN) || buffer.length() == 1 && buffer.getByte(0) == 0;
    }

    public synchronized void handle(Buffer event) {
        if (this.current == State.BODY) {
            this.bodyLength += event.length();
            if (this.hasExceededBodySize()) {
                this.reportOrThrow("Body size exceeded");
                return;
            }
        }
        this.frameParser.handle(event);
    }

    private boolean hasExceededBodySize() {
        return this.bodyLength >= this.properties.getMaxBodyLength();
    }

    private void reportOrThrow(String error) {
        FrameException exception = new FrameException(error);
        this.reset();
        if (this.errorHandler == null) {
            throw exception;
        }
        this.errorHandler.handle((Object)exception);
    }

    static enum State {
        COMMAND,
        HEADERS,
        BODY;

    }
}

