/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.flume;

import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.flume.FlumeException;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.URIBuilder;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.DataModelUtil;
import org.kitesdk.data.spi.EntityAccessor;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.StorageKey;
import org.kitesdk.data.spi.filesystem.PathConversion;

public class Log4jAppender
extends org.apache.flume.clients.log4jappender.Log4jAppender {
    private static final String PARTITION_PREFIX = "kite.partition.";
    private String datasetRepositoryUri;
    private String datasetNamespace;
    private String datasetName;
    private boolean initialized;
    private PartitionStrategy partitionStrategy;
    private EntityAccessor<Object> accessor;
    private StorageKey key;

    public Log4jAppender() {
        this.setAvroReflectionEnabled(true);
    }

    public Log4jAppender(String hostname, int port) {
        super(hostname, port);
        this.setAvroReflectionEnabled(true);
    }

    @Override
    public boolean requiresLayout() {
        return false;
    }

    @Deprecated
    public void setDatasetRepositoryClass(String datasetRepositoryClass) {
        throw new UnsupportedOperationException("datasetRepositoryClass is no longer supported. Use datasetRepositoryUri with a 'repo:' URI.");
    }

    public void setDatasetRepositoryUri(String datasetRepositoryUri) {
        this.datasetRepositoryUri = datasetRepositoryUri;
    }

    public void setDatasetNamespace(String datasetNamespace) {
        this.datasetNamespace = datasetNamespace;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    @Override
    protected void populateAvroHeaders(Map<String, String> hdrs, Schema schema, Object message) {
        if (!this.initialized) {
            try {
                URL schemaUrl;
                URI datasetUri = this.datasetNamespace == null ? new URIBuilder(this.datasetRepositoryUri, "default", this.datasetName).build() : new URIBuilder(this.datasetRepositoryUri, this.datasetNamespace, this.datasetName).build();
                Dataset dataset = (Dataset)Datasets.load((URI)datasetUri, Object.class);
                if (dataset.getDescriptor().isPartitioned()) {
                    this.partitionStrategy = dataset.getDescriptor().getPartitionStrategy();
                    this.accessor = DataModelUtil.accessor((Class)dataset.getType(), (Schema)dataset.getDescriptor().getSchema());
                    this.key = new StorageKey(this.partitionStrategy);
                }
                if ((schemaUrl = dataset.getDescriptor().getSchemaUrl()) != null) {
                    this.setAvroSchemaUrl(schemaUrl.toExternalForm());
                }
            }
            catch (Exception e) {
                throw new FlumeException((Throwable)e);
            }
            finally {
                this.initialized = true;
            }
        }
        super.populateAvroHeaders(hdrs, schema, message);
        if (this.partitionStrategy != null) {
            this.key.reuseFor(message, this.accessor);
            int i = 0;
            for (FieldPartitioner fp : Accessor.getDefault().getFieldPartitioners(this.partitionStrategy)) {
                hdrs.put(PARTITION_PREFIX + fp.getName(), PathConversion.valueToString((FieldPartitioner)fp, (Object)this.key.get(i++)));
            }
        }
    }
}

