/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.clients.log4jappender;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.flume.FlumeException;
import org.apache.flume.api.RpcClientFactory;
import org.apache.flume.clients.log4jappender.Log4jAppender;
import org.apache.log4j.helpers.LogLog;

public class LoadBalancingLog4jAppender
extends Log4jAppender {
    private String hosts;
    private String selector;
    private String maxBackoff;

    public void setHosts(String hostNames) {
        this.hosts = hostNames;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public void setMaxBackoff(String maxBackoff) {
        this.maxBackoff = maxBackoff;
    }

    @Override
    public void activateOptions() throws FlumeException {
        try {
            Properties properties = this.getProperties(this.hosts, this.selector, this.maxBackoff);
            this.rpcClient = RpcClientFactory.getInstance((Properties)properties);
        }
        catch (FlumeException e) {
            String errormsg = "RPC client creation failed! " + e.getMessage();
            LogLog.error((String)errormsg);
            throw e;
        }
    }

    private Properties getProperties(String hosts, String selector, String maxBackoff) throws FlumeException {
        if (StringUtils.isEmpty((String)hosts)) {
            throw new IllegalArgumentException("hosts must not be null");
        }
        Properties props = new Properties();
        String[] hostsAndPorts = hosts.split("\\s+");
        StringBuilder names = new StringBuilder();
        for (int i = 0; i < hostsAndPorts.length; ++i) {
            String hostAndPort = hostsAndPorts[i];
            String name = "h" + i;
            props.setProperty("hosts." + name, hostAndPort);
            names.append(name).append(" ");
        }
        props.put("hosts", names.toString());
        props.put("client.type", RpcClientFactory.ClientType.DEFAULT_LOADBALANCE.toString());
        if (!StringUtils.isEmpty((String)selector)) {
            props.put("host-selector", selector);
        }
        if (!StringUtils.isEmpty((String)maxBackoff)) {
            long millis = Long.parseLong(maxBackoff.trim());
            if (millis <= 0L) {
                throw new IllegalArgumentException("Misconfigured max backoff, value must be greater than 0");
            }
            props.put("backoff", String.valueOf(true));
            props.put("maxBackoff", maxBackoff);
        }
        return props;
    }
}

