/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.avro;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.reflect.ReflectData;
import org.kitesdk.morphline.api.MorphlineRuntimeException;

final class AvroConversions {
    static final Object ERROR = new Object();

    private AvroConversions() {
    }

    private static boolean nullOk(Schema schema) {
        if (Schema.Type.NULL == schema.getType()) {
            return true;
        }
        if (Schema.Type.UNION == schema.getType()) {
            for (Schema candidate : schema.getTypes()) {
                if (!AvroConversions.nullOk(candidate)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object toAvro(Object item, Schema.Field field) {
        if (item == null && !AvroConversions.nullOk(field.schema())) {
            try {
                return ReflectData.get().getDefaultValue(field);
            }
            catch (AvroRuntimeException e) {
                return ERROR;
            }
        }
        Object result = AvroConversions.toAvro(item, field.schema());
        return result;
    }

    public static Object toAvro(Object item, Schema schema) {
        switch (schema.getType()) {
            case RECORD: {
                if (item instanceof Map) {
                    Map map = (Map)item;
                    GenericData.Record record = new GenericData.Record(schema);
                    for (Schema.Field field : schema.getFields()) {
                        Object value = map.get(field.name());
                        Object result = AvroConversions.toAvro(value, field);
                        if (result == ERROR) {
                            return ERROR;
                        }
                        record.put(field.pos(), result);
                    }
                    return record;
                }
                return ERROR;
            }
            case ENUM: {
                if (schema.hasEnumSymbol(item.toString())) {
                    return item.toString();
                }
                return ERROR;
            }
            case ARRAY: {
                if (item instanceof List) {
                    ListIterator<Object> iter = ((List)item).listIterator();
                    while (iter.hasNext()) {
                        Object result = AvroConversions.toAvro(iter.next(), schema.getElementType());
                        if (result == ERROR) {
                            return ERROR;
                        }
                        iter.set(result);
                    }
                    return item;
                }
                return ERROR;
            }
            case MAP: {
                if (item instanceof Map) {
                    Map map = (Map)item;
                    for (Map.Entry entry : map.entrySet()) {
                        if (!(entry.getKey() instanceof CharSequence)) {
                            return ERROR;
                        }
                        Object result = AvroConversions.toAvro(entry.getValue(), schema.getValueType());
                        if (result == ERROR) {
                            return ERROR;
                        }
                        entry.setValue(result);
                    }
                    return item;
                }
                return ERROR;
            }
            case UNION: {
                return AvroConversions.toAvroUnion(item, schema);
            }
            case FIXED: {
                if (item instanceof byte[]) {
                    return new GenericData.Fixed(schema, (byte[])item);
                }
                return ERROR;
            }
            case STRING: {
                assert (item != null);
                return item.toString();
            }
            case BYTES: {
                if (item instanceof ByteBuffer) {
                    return item;
                }
                if (item instanceof byte[]) {
                    return ByteBuffer.wrap((byte[])item);
                }
                return ERROR;
            }
            case INT: {
                if (item instanceof Integer) {
                    return item;
                }
                if (item instanceof Number) {
                    return ((Number)item).intValue();
                }
                try {
                    return Integer.valueOf(item.toString());
                }
                catch (NumberFormatException e) {
                    return ERROR;
                }
            }
            case LONG: {
                if (item instanceof Long) {
                    return item;
                }
                if (item instanceof Number) {
                    return ((Number)item).longValue();
                }
                try {
                    return Long.valueOf(item.toString());
                }
                catch (NumberFormatException e) {
                    return ERROR;
                }
            }
            case FLOAT: {
                if (item instanceof Float) {
                    return item;
                }
                if (item instanceof Number) {
                    return Float.valueOf(((Number)item).floatValue());
                }
                try {
                    return Float.valueOf(item.toString());
                }
                catch (NumberFormatException e) {
                    return ERROR;
                }
            }
            case DOUBLE: {
                if (item instanceof Double) {
                    return item;
                }
                if (item instanceof Number) {
                    return ((Number)item).doubleValue();
                }
                try {
                    return Double.valueOf(item.toString());
                }
                catch (NumberFormatException e) {
                    return ERROR;
                }
            }
            case BOOLEAN: {
                if (item instanceof Boolean) {
                    return item;
                }
                assert (item != null);
                String str = item.toString();
                if ("true".equals(str)) {
                    return Boolean.TRUE;
                }
                if ("false".equals(str)) {
                    return Boolean.FALSE;
                }
                return ERROR;
            }
            case NULL: {
                if (item == null) {
                    return null;
                }
                return ERROR;
            }
        }
        throw new MorphlineRuntimeException("Unknown Avro schema type: " + schema.getType());
    }

    private static Object toAvroUnion(Object item, Schema schema) {
        assert (schema.getType() == Schema.Type.UNION);
        List types = schema.getTypes();
        int index = -1;
        if (item instanceof Map) {
            for (int j = 0; j < types.size(); ++j) {
                Schema.Type t = ((Schema)types.get(j)).getType();
                if (t != Schema.Type.RECORD && t != Schema.Type.MAP) continue;
                index = j;
                break;
            }
        } else {
            try {
                index = GenericData.get().resolveUnion(schema, item);
            }
            catch (AvroRuntimeException e) {
                // empty catch block
            }
        }
        if (index >= 0) {
            Schema candidate = (Schema)types.get(index);
            Object result = AvroConversions.toAvro(item, candidate);
            return result;
        }
        for (Schema candidate : types) {
            Object result = AvroConversions.toAvro(item, candidate);
            if (result == ERROR) continue;
            return result;
        }
        return ERROR;
    }
}

