/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.avro;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.typesafe.config.Config;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.util.Utf8;
import org.junit.Ignore;
import org.junit.Test;
import org.kitesdk.morphline.api.AbstractMorphlineTest;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.avro.ReadAvroContainerBuilder;
import org.kitesdk.morphline.base.Notifications;
import org.kitesdk.morphline.stdio.AbstractParser;

public class AvroMorphlineTest
extends AbstractMorphlineTest {
    private static final String[] TWEET_FIELD_NAMES = new String[]{"id", "in_reply_to_status_id", "in_reply_to_user_id", "retweet_count", "retweeted", "text", "user_description"};

    @Test
    public void testToAvroMap() throws Exception {
        this.morphline = this.createMorphline("test-morphlines/toAvroMap", new Config[0]);
        byte[] bytes = new byte[]{47, 13};
        Record jdoc1 = new Record();
        jdoc1.put("intField", (Object)20);
        jdoc1.put("longField", (Object)200L);
        jdoc1.put("stringField", (Object)"200");
        jdoc1.put("boolField", (Object)Boolean.TRUE);
        jdoc1.put("floatField", (Object)Float.valueOf(200.0f));
        jdoc1.put("doubleField", (Object)200.0);
        jdoc1.put("bytesField", (Object)bytes);
        jdoc1.put("nullField", null);
        jdoc1.getFields().putAll((Object)"arrayField", Arrays.asList(10.0, 20.0));
        this.collector.reset();
        AvroMorphlineTest.assertTrue((boolean)this.morphline.process(jdoc1));
        GenericData.Record actual = (GenericData.Record)this.collector.getFirstRecord().getFirstValue("_attachment_body");
        Map map = (Map)actual.get("content");
        AvroMorphlineTest.assertEquals(Arrays.asList(20), map.get("intField"));
        AvroMorphlineTest.assertNull(map.get("defaultIntField"));
        AvroMorphlineTest.assertEquals(Arrays.asList(200L), map.get("longField"));
        AvroMorphlineTest.assertEquals(Arrays.asList("200"), map.get("stringField"));
        AvroMorphlineTest.assertEquals(Arrays.asList(Boolean.TRUE), map.get("boolField"));
        AvroMorphlineTest.assertEquals(Arrays.asList(Float.valueOf(200.0f)), map.get("floatField"));
        AvroMorphlineTest.assertEquals(Arrays.asList(200.0), map.get("doubleField"));
        AvroMorphlineTest.assertEquals(Arrays.asList(ByteBuffer.wrap(bytes)), map.get("bytesField"));
        AvroMorphlineTest.assertEquals(Collections.singletonList(null), map.get("nullField"));
        AvroMorphlineTest.assertEquals(Arrays.asList(10.0, 20.0), map.get("arrayField"));
    }

    @Test
    public void testToAvroBasic() throws Exception {
        Schema schema = new Schema.Parser().parse(new File("src/test/resources/test-avro-schemas/interop.avsc"));
        this.morphline = this.createMorphline("test-morphlines/toAvroWithSchemaFile", new Config[0]);
        byte[] bytes = new byte[]{47, 13};
        byte[] fixed = new byte[16];
        Record jdoc1 = new Record();
        jdoc1.put("_dataset_descriptor_schema", (Object)schema);
        this.collector.reset();
        AvroMorphlineTest.assertFalse((boolean)this.morphline.process(jdoc1));
        jdoc1.put("intField", (Object)"notAnInteger");
        this.collector.reset();
        AvroMorphlineTest.assertFalse((boolean)this.morphline.process(jdoc1));
        jdoc1.replaceValues("intField", (Object)"20");
        jdoc1.put("longField", (Object)"200");
        jdoc1.put("stringField", (Object)"abc");
        jdoc1.put("boolField", (Object)"true");
        jdoc1.put("floatField", (Object)"200");
        jdoc1.put("doubleField", (Object)"200");
        jdoc1.put("bytesField", (Object)bytes);
        jdoc1.put("nullField", null);
        jdoc1.getFields().putAll((Object)"arrayField", Arrays.asList(10.0, 20.0));
        jdoc1.put("mapField", new HashMap(ImmutableMap.of((Object)"myMap", (Object)ImmutableMap.of((Object)"label", (Object)"car"))));
        jdoc1.put("unionField", new ArrayList(Arrays.asList(new byte[][]{bytes})));
        jdoc1.put("enumField", (Object)"B");
        jdoc1.put("fixedField", (Object)fixed);
        jdoc1.put("recordField", (Object)ImmutableMap.of((Object)"label", (Object)"house", (Object)"children", new ArrayList(Arrays.asList(new byte[][]{bytes}))));
        this.collector.reset();
        AvroMorphlineTest.assertTrue((boolean)this.morphline.process(jdoc1));
        GenericData.Record actual = (GenericData.Record)this.collector.getFirstRecord().getFirstValue("_attachment_body");
        AvroMorphlineTest.assertEquals((Object)20, (Object)actual.get("intField"));
        AvroMorphlineTest.assertEquals((Object)123, (Object)actual.get("defaultIntField"));
        AvroMorphlineTest.assertEquals((Object)200L, (Object)actual.get("longField"));
        AvroMorphlineTest.assertEquals((Object)"abc", (Object)actual.get("stringField"));
        AvroMorphlineTest.assertEquals((Object)Boolean.TRUE, (Object)actual.get("boolField"));
        AvroMorphlineTest.assertEquals((Object)Float.valueOf(200.0f), (Object)actual.get("floatField"));
        AvroMorphlineTest.assertEquals((Object)200.0, (Object)actual.get("doubleField"));
        AvroMorphlineTest.assertEquals((Object)ByteBuffer.wrap(bytes), (Object)actual.get("bytesField"));
        AvroMorphlineTest.assertNull((Object)actual.get("nullField"));
        AvroMorphlineTest.assertEquals(Arrays.asList(10.0, 20.0), (Object)actual.get("arrayField"));
        GenericData.Record expected = new GenericData.Record(schema.getField("mapField").schema().getValueType());
        expected.put("label", (Object)"car");
        AvroMorphlineTest.assertEquals((Object)ImmutableMap.of((Object)"myMap", (Object)expected), (Object)actual.get("mapField"));
        AvroMorphlineTest.assertEquals(Arrays.asList(ByteBuffer.wrap(bytes)), (Object)actual.get("unionField"));
        AvroMorphlineTest.assertEquals((Object)"B", (Object)actual.get("enumField"));
        AvroMorphlineTest.assertEquals((Object)new GenericData.Fixed(schema.getField("fixedField").schema(), fixed), (Object)actual.get("fixedField"));
        expected = new GenericData.Record(schema.getField("recordField").schema());
        expected.put("label", (Object)"house");
        expected.put("children", new ArrayList<ByteBuffer>(Arrays.asList(ByteBuffer.wrap(bytes))));
        AvroMorphlineTest.assertEquals((Object)expected, (Object)actual.get("recordField"));
    }

    @Test
    public void testToAvroWithUnion() throws Exception {
        this.morphline = this.createMorphline("test-morphlines/toAvro", new Config[0]);
        List<Schema> types = Arrays.asList(Schema.create((Schema.Type)Schema.Type.INT), Schema.create((Schema.Type)Schema.Type.LONG), Schema.create((Schema.Type)Schema.Type.FLOAT), Schema.create((Schema.Type)Schema.Type.DOUBLE), Schema.create((Schema.Type)Schema.Type.BOOLEAN), Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL));
        this.processAndVerifyUnion(5, 5, types);
        this.processAndVerifyUnion(5L, 5L, types);
        this.processAndVerifyUnion(Float.valueOf(5.0f), Float.valueOf(5.0f), types);
        this.processAndVerifyUnion(5.0, 5.0, types);
        this.processAndVerifyUnion("5", "5", types);
        this.processAndVerifyUnion(Boolean.TRUE, Boolean.TRUE, types);
        this.processAndVerifyUnion(Boolean.FALSE, Boolean.FALSE, types);
        this.processAndVerifyUnion(null, null, types);
        this.processAndVerifyUnion(Arrays.asList(1, 2), "[1, 2]", types);
        types = Arrays.asList(Schema.create((Schema.Type)Schema.Type.DOUBLE), Schema.create((Schema.Type)Schema.Type.INT));
        this.processAndVerifyUnion("5", 5.0, types);
        types = Arrays.asList(Schema.create((Schema.Type)Schema.Type.INT), Schema.create((Schema.Type)Schema.Type.DOUBLE));
        this.processAndVerifyUnion("5", 5, types);
        types = Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.DOUBLE));
        this.processAndVerifyUnion(5, "5", types);
        types = Arrays.asList(Schema.create((Schema.Type)Schema.Type.DOUBLE), Schema.create((Schema.Type)Schema.Type.STRING));
        this.processAndVerifyUnion(5, 5.0, types);
        Schema recordSchema = Schema.createRecord((String)"Rec", (String)"arec", null, (boolean)false);
        recordSchema.setFields(Arrays.asList(new Schema.Field("foo", Schema.create((Schema.Type)Schema.Type.STRING), null, null)));
        types = Arrays.asList(Schema.create((Schema.Type)Schema.Type.INT), Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.STRING)), recordSchema);
        HashMap map = new HashMap(ImmutableMap.of((Object)"foo", (Object)"bar"));
        this.processAndVerifyUnion(map, new HashMap(map), types);
        types = Arrays.asList(Schema.create((Schema.Type)Schema.Type.INT), recordSchema, Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.STRING)));
        GenericData.Record avroRecord = new GenericData.Record(recordSchema);
        avroRecord.put("foo", (Object)"bar");
        this.processAndVerifyUnion(map, avroRecord, types);
    }

    private void processAndVerifyUnion(Object input, Object expected, List<Schema> types) {
        Schema documentSchema = Schema.createRecord((String)"Doc", (String)"adoc", null, (boolean)false);
        Schema unionSchema = Schema.createUnion(types);
        documentSchema.setFields(Arrays.asList(new Schema.Field("price", unionSchema, null, null)));
        GenericData.Record document1 = new GenericData.Record(documentSchema);
        document1.put("price", expected);
        Record jdoc1 = new Record();
        jdoc1.put("_dataset_descriptor_schema", (Object)documentSchema);
        jdoc1.put("price", input);
        Record expect1 = jdoc1.copy();
        expect1.put("_attachment_body", (Object)document1);
        this.processAndVerifySuccess(jdoc1, expect1, false);
    }

    @Test
    public void testAvroArrayUnionDocument() throws Exception {
        Schema documentSchema = Schema.createRecord((String)"Doc", (String)"adoc", null, (boolean)false);
        ArrayList<Schema.Field> docFields = new ArrayList<Schema.Field>();
        Schema intArraySchema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT));
        Schema intArrayUnionSchema = Schema.createUnion(Arrays.asList(intArraySchema, Schema.create((Schema.Type)Schema.Type.NULL)));
        Schema itemListSchema = Schema.createArray((Schema)intArrayUnionSchema);
        docFields.add(new Schema.Field("price", itemListSchema, null, null));
        documentSchema.setFields(docFields);
        GenericData.Record document0 = new GenericData.Record(documentSchema);
        document0.put("price", (Object)new GenericData.Array(itemListSchema, Arrays.asList(new GenericData.Array(intArraySchema, Arrays.asList(1, 2, 3, 4, 5)), new GenericData.Array(intArraySchema, Arrays.asList(10, 20)), null, null, new GenericData.Array(intArraySchema, Arrays.asList(100, 200)), null)));
        GenericData.Record document1 = new GenericData.Record(documentSchema);
        document1.put("price", (Object)new GenericData.Array(itemListSchema, Arrays.asList(new GenericData.Array(intArraySchema, Arrays.asList(1000)))));
        this.morphline = this.createMorphline("test-morphlines/extractAvroPaths", new Config[0]);
        this.deleteAllDocuments();
        Record record = new Record();
        record.put("_attachment_body", (Object)document0);
        this.startSession();
        AvroMorphlineTest.assertTrue((boolean)this.morphline.process(record));
        AvroMorphlineTest.assertEquals((long)1L, (long)this.collector.getRecords().size());
        List<Object> expected = Arrays.asList(Arrays.asList(Arrays.asList(1, 2, 3, 4, 5), Arrays.asList(10, 20), null, null, Arrays.asList(100, 200), null));
        AvroMorphlineTest.assertEquals(expected, (Object)this.collector.getFirstRecord().get("/price"));
        AvroMorphlineTest.assertEquals(expected, (Object)this.collector.getFirstRecord().get("/price/[]"));
        AvroMorphlineTest.assertEquals(Arrays.asList(new Object[0]), (Object)this.collector.getFirstRecord().get("/unknownField"));
        this.deleteAllDocuments();
        record = new Record();
        record.put("_attachment_body", (Object)document1);
        this.startSession();
        AvroMorphlineTest.assertTrue((boolean)this.morphline.process(record));
        AvroMorphlineTest.assertEquals((long)1L, (long)this.collector.getRecords().size());
        expected = Arrays.asList(Arrays.asList(Arrays.asList(1000)));
        AvroMorphlineTest.assertEquals(expected, (Object)this.collector.getFirstRecord().get("/price"));
        AvroMorphlineTest.assertEquals(expected, (Object)this.collector.getFirstRecord().get("/price/[]"));
        AvroMorphlineTest.assertEquals(Arrays.asList(new Object[0]), (Object)this.collector.getFirstRecord().get("/unknownField"));
        this.morphline = this.createMorphline("test-morphlines/extractAvroPathsFlattened", new Config[0]);
        this.deleteAllDocuments();
        record = new Record();
        record.put("_attachment_body", (Object)document0);
        this.startSession();
        AvroMorphlineTest.assertTrue((boolean)this.morphline.process(record));
        AvroMorphlineTest.assertEquals((long)1L, (long)this.collector.getRecords().size());
        expected = Arrays.asList(1, 2, 3, 4, 5, 10, 20, 100, 200);
        AvroMorphlineTest.assertEquals(expected, (Object)this.collector.getFirstRecord().get("/price"));
        AvroMorphlineTest.assertEquals(expected, (Object)this.collector.getFirstRecord().get("/price/[]"));
        AvroMorphlineTest.assertEquals(Arrays.asList(new Object[0]), (Object)this.collector.getFirstRecord().get("/unknownField"));
        this.ingestAndVerifyAvro(documentSchema, document0);
        this.ingestAndVerifyAvro(documentSchema, document0, document1);
        Record event = new Record();
        event.getFields().put((Object)"_attachment_body", (Object)document0);
        this.morphline = this.createMorphline("test-morphlines/extractAvroTree", new Config[0]);
        this.deleteAllDocuments();
        System.out.println(document0);
        AvroMorphlineTest.assertTrue((boolean)this.load(event));
        AvroMorphlineTest.assertEquals((long)1L, (long)this.queryResultSetSize("*:*"));
        Record first = this.collector.getFirstRecord();
        AbstractParser.removeAttachments((Record)first);
        AvroMorphlineTest.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 10, 20, 100, 200), (Object)first.get("/price"));
        AvroMorphlineTest.assertEquals((long)1L, (long)first.getFields().asMap().size());
        this.morphline = this.createMorphline("test-morphlines/toAvro", new Config[0]);
        Record jdoc1 = new Record();
        jdoc1.put("_dataset_descriptor_schema", (Object)documentSchema);
        jdoc1.put("price", Arrays.asList(1000));
        Record expect1 = jdoc1.copy();
        expect1.put("_attachment_body", (Object)document1);
        this.processAndVerifySuccess(jdoc1, expect1, false);
        Record jdoc0 = new Record();
        jdoc0.put("_dataset_descriptor_schema", (Object)documentSchema);
        jdoc0.getFields().putAll((Object)"price", Arrays.asList(Arrays.asList(1, 2, 3, 4, 5), Arrays.asList(10, 20), null, null, Arrays.asList(100, 200), null));
        Record expect0 = jdoc0.copy();
        expect0.put("_attachment_body", (Object)document0);
        this.processAndVerifySuccess(jdoc0, expect0, false);
    }

    @Test
    public void testAvroComplexDocuments() throws Exception {
        Schema documentSchema = Schema.createRecord((String)"Document", (String)"adoc", null, (boolean)false);
        ArrayList<Schema.Field> docFields = new ArrayList<Schema.Field>();
        docFields.add(new Schema.Field("docId", Schema.create((Schema.Type)Schema.Type.INT), null, null));
        Schema linksSchema = Schema.createRecord((String)"Links", (String)"alink", null, (boolean)false);
        ArrayList<Schema.Field> linkFields = new ArrayList<Schema.Field>();
        linkFields.add(new Schema.Field("backward", Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT)), null, null));
        linkFields.add(new Schema.Field("forward", Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT)), null, null));
        linksSchema.setFields(linkFields);
        docFields.add(new Schema.Field("links", Schema.createUnion(Arrays.asList(linksSchema, Schema.create((Schema.Type)Schema.Type.NULL))), null, null));
        Schema nameSchema = Schema.createRecord((String)"Name", (String)"aname", null, (boolean)false);
        ArrayList<Schema.Field> nameFields = new ArrayList<Schema.Field>();
        Schema languageSchema = Schema.createRecord((String)"Language", (String)"alanguage", null, (boolean)false);
        ArrayList<Schema.Field> languageFields = new ArrayList<Schema.Field>();
        languageFields.add(new Schema.Field("code", Schema.create((Schema.Type)Schema.Type.STRING), null, null));
        languageFields.add(new Schema.Field("country", Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL))), null, null));
        languageSchema.setFields(languageFields);
        nameFields.add(new Schema.Field("language", Schema.createArray((Schema)languageSchema), null, null));
        nameFields.add(new Schema.Field("url", Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL))), null, null));
        nameSchema.setFields(nameFields);
        docFields.add(new Schema.Field("name", Schema.createArray((Schema)nameSchema), null, null));
        documentSchema.setFields(docFields);
        GenericData.Record document0 = new GenericData.Record(documentSchema);
        document0.put("docId", (Object)10);
        GenericData.Record links = new GenericData.Record(linksSchema);
        links.put("forward", (Object)new GenericData.Array(linksSchema.getField("forward").schema(), Arrays.asList(20, 40, 60)));
        links.put("backward", (Object)new GenericData.Array(linksSchema.getField("backward").schema(), Arrays.asList(new Object[0])));
        document0.put("links", (Object)links);
        GenericData.Record name0 = new GenericData.Record(nameSchema);
        GenericData.Record language0 = new GenericData.Record(languageSchema);
        language0.put("code", (Object)"en-us");
        language0.put("country", (Object)"us");
        GenericData.Record language1 = new GenericData.Record(languageSchema);
        language1.put("code", (Object)"en");
        name0.put("language", (Object)new GenericData.Array(nameSchema.getField("language").schema(), Arrays.asList(language0, language1)));
        name0.put("url", (Object)"http://A");
        GenericData.Record name1 = new GenericData.Record(nameSchema);
        name1.put("language", (Object)new GenericData.Array(nameSchema.getField("language").schema(), Arrays.asList(new Object[0])));
        name1.put("url", (Object)"http://B");
        GenericData.Record name2 = new GenericData.Record(nameSchema);
        GenericData.Record language2 = new GenericData.Record(languageSchema);
        language2.put("code", (Object)"en-gb");
        language2.put("country", (Object)"gb");
        name2.put("language", (Object)new GenericData.Array(nameSchema.getField("language").schema(), Arrays.asList(language2)));
        document0.put("name", (Object)new GenericData.Array(documentSchema.getField("name").schema(), Arrays.asList(name0, name1, name2)));
        GenericData.Record document1 = new GenericData.Record(documentSchema);
        document1.put("docId", (Object)20);
        GenericData.Record links1 = new GenericData.Record(linksSchema);
        links1.put("backward", (Object)new GenericData.Array(linksSchema.getField("backward").schema(), Arrays.asList(10, 30)));
        links1.put("forward", (Object)new GenericData.Array(linksSchema.getField("forward").schema(), Arrays.asList(80)));
        document1.put("links", (Object)links1);
        GenericData.Record name4 = new GenericData.Record(nameSchema);
        name4.put("language", (Object)new GenericData.Array(nameSchema.getField("language").schema(), Arrays.asList(new Object[0])));
        name4.put("url", (Object)"http://C");
        document1.put("name", (Object)new GenericData.Array(documentSchema.getField("name").schema(), Arrays.asList(name4)));
        this.morphline = this.createMorphline("test-morphlines/extractAvroPaths", new Config[0]);
        this.deleteAllDocuments();
        Record record = new Record();
        record.put("_attachment_body", (Object)document0);
        this.startSession();
        AvroMorphlineTest.assertTrue((boolean)this.morphline.process(record));
        AvroMorphlineTest.assertEquals((long)1L, (long)this.collector.getRecords().size());
        AvroMorphlineTest.assertEquals(Arrays.asList(10), (Object)this.collector.getFirstRecord().get("/docId"));
        AvroMorphlineTest.assertEquals(Arrays.asList(Arrays.asList(new Object[0])), (Object)this.collector.getFirstRecord().get("/links/backward"));
        List<Object> expected = Arrays.asList(Arrays.asList(20, 40, 60));
        AvroMorphlineTest.assertEquals(expected, (Object)this.collector.getFirstRecord().get("/links/forward"));
        AvroMorphlineTest.assertEquals(expected, (Object)this.collector.getFirstRecord().get("/links/forward/[]"));
        AvroMorphlineTest.assertEquals(expected, (Object)this.collector.getFirstRecord().get("/links/forward[]"));
        AvroMorphlineTest.assertEquals(Arrays.asList("en-us", "en", "en-gb"), (Object)this.collector.getFirstRecord().get("/name/[]/language/[]/code"));
        AvroMorphlineTest.assertEquals(Arrays.asList("en-us", "en", "en-gb"), (Object)this.collector.getFirstRecord().get("/name[]/language[]/code"));
        AvroMorphlineTest.assertEquals(Arrays.asList("us", "gb"), (Object)this.collector.getFirstRecord().get("/name/[]/language/[]/country"));
        AvroMorphlineTest.assertEquals(Arrays.asList("us", "gb"), (Object)this.collector.getFirstRecord().get("/name[]/language[]/country"));
        AvroMorphlineTest.assertEquals(Arrays.asList(new Object[0]), (Object)this.collector.getFirstRecord().get("/unknownField"));
        this.morphline = this.createMorphline("test-morphlines/extractAvroPathsFlattened", new Config[0]);
        this.deleteAllDocuments();
        record = new Record();
        record.put("_attachment_body", (Object)document0);
        this.startSession();
        AvroMorphlineTest.assertTrue((boolean)this.morphline.process(record));
        AvroMorphlineTest.assertEquals((long)1L, (long)this.collector.getRecords().size());
        AvroMorphlineTest.assertEquals(Arrays.asList(10), (Object)this.collector.getFirstRecord().get("/docId"));
        AvroMorphlineTest.assertEquals(Arrays.asList(20, 40, 60), (Object)this.collector.getFirstRecord().get("/links"));
        AvroMorphlineTest.assertEquals(Arrays.asList(new Object[0]), (Object)this.collector.getFirstRecord().get("/links/backward"));
        expected = Arrays.asList(20, 40, 60);
        AvroMorphlineTest.assertEquals(expected, (Object)this.collector.getFirstRecord().get("/links/forward"));
        AvroMorphlineTest.assertEquals(expected, (Object)this.collector.getFirstRecord().get("/links/forward/[]"));
        AvroMorphlineTest.assertEquals(expected, (Object)this.collector.getFirstRecord().get("/links/forward[]"));
        AvroMorphlineTest.assertEquals(Arrays.asList("en-us", "en", "en-gb"), (Object)this.collector.getFirstRecord().get("/name/[]/language/[]/code"));
        AvroMorphlineTest.assertEquals(Arrays.asList("en-us", "en", "en-gb"), (Object)this.collector.getFirstRecord().get("/name[]/language[]/code"));
        AvroMorphlineTest.assertEquals(Arrays.asList("us", "gb"), (Object)this.collector.getFirstRecord().get("/name/[]/language/[]/country"));
        AvroMorphlineTest.assertEquals(Arrays.asList("us", "gb"), (Object)this.collector.getFirstRecord().get("/name[]/language[]/country"));
        AvroMorphlineTest.assertEquals(Arrays.asList(new Object[0]), (Object)this.collector.getFirstRecord().get("/unknownField"));
        expected = Arrays.asList("en-us", "us", "en", "http://A", "http://B", "en-gb", "gb");
        AvroMorphlineTest.assertEquals(expected, (Object)this.collector.getFirstRecord().get("/name"));
        this.ingestAndVerifyAvro(documentSchema, document0);
        this.ingestAndVerifyAvro(documentSchema, document0, document1);
        Record event = new Record();
        event.getFields().put((Object)"_attachment_body", (Object)document0);
        this.morphline = this.createMorphline("test-morphlines/extractAvroTree", new Config[0]);
        this.deleteAllDocuments();
        AvroMorphlineTest.assertTrue((boolean)this.load(event));
        AvroMorphlineTest.assertEquals((long)1L, (long)this.queryResultSetSize("*:*"));
        Record first = this.collector.getFirstRecord();
        AvroMorphlineTest.assertEquals(Arrays.asList("us", "gb"), (Object)first.get("/name/language/country"));
        AvroMorphlineTest.assertEquals(Arrays.asList("en-us", "en", "en-gb"), (Object)first.get("/name/language/code"));
        AvroMorphlineTest.assertEquals(Arrays.asList(20, 40, 60), (Object)first.get("/links/forward"));
        AvroMorphlineTest.assertEquals(Arrays.asList("http://A", "http://B"), (Object)first.get("/name/url"));
        AvroMorphlineTest.assertEquals(Arrays.asList(10), (Object)first.get("/docId"));
        AbstractParser.removeAttachments((Record)first);
        AvroMorphlineTest.assertEquals((long)5L, (long)first.getFields().asMap().size());
        this.morphline = this.createMorphline("test-morphlines/toAvro", new Config[0]);
        Record jdoc1 = new Record();
        jdoc1.put("_dataset_descriptor_schema", (Object)documentSchema);
        jdoc1.put("docId", (Object)20);
        jdoc1.put("links", (Object)ImmutableMap.of((Object)"backward", Arrays.asList(10, 30), (Object)"forward", Arrays.asList(80)));
        jdoc1.getFields().putAll((Object)"name", Arrays.asList(ImmutableMap.of((Object)"language", Arrays.asList(new Object[0]), (Object)"url", (Object)"http://C")));
        Record expect1 = jdoc1.copy();
        expect1.put("_attachment_body", (Object)document1);
        this.processAndVerifySuccess(jdoc1, expect1, false);
        Record jdoc0 = new Record();
        jdoc0.put("_dataset_descriptor_schema", (Object)documentSchema);
        jdoc0.put("docId", (Object)10);
        jdoc0.put("links", (Object)ImmutableMap.of((Object)"backward", Arrays.asList(new Object[0]), (Object)"forward", Arrays.asList(20, 40, 60)));
        jdoc0.getFields().putAll((Object)"name", Arrays.asList(ImmutableMap.of((Object)"language", new ArrayList<ImmutableMap>(Arrays.asList(ImmutableMap.of((Object)"code", (Object)"en-us", (Object)"country", (Object)"us"), ImmutableMap.of((Object)"code", (Object)"en"))), (Object)"url", (Object)"http://A"), ImmutableMap.of((Object)"language", Arrays.asList(new Object[0]), (Object)"url", (Object)"http://B"), ImmutableMap.of((Object)"language", new ArrayList<ImmutableMap>(Arrays.asList(ImmutableMap.of((Object)"code", (Object)"en-gb", (Object)"country", (Object)"gb"))))));
        Record expect0 = jdoc0.copy();
        expect0.put("_attachment_body", (Object)document0);
        this.processAndVerifySuccess(jdoc0, expect0, false);
    }

    @Test
    public void testMap() throws Exception {
        Schema schema = new Schema.Parser().parse(new File("src/test/resources/test-avro-schemas/intero1.avsc"));
        GenericData.Record document0 = new GenericData.Record(schema);
        LinkedHashMap<Utf8, GenericData.Record> map = new LinkedHashMap<Utf8, GenericData.Record>();
        Schema mapRecordSchema = schema.getField("mapField").schema().getValueType();
        GenericData.Record mapRecord = new GenericData.Record(mapRecordSchema);
        mapRecord.put("label", (Object)"nadja");
        map.put(AvroMorphlineTest.utf8("foo"), mapRecord);
        document0.put("mapField", map);
        this.morphline = this.createMorphline("test-morphlines/extractAvroPaths", new Config[0]);
        this.deleteAllDocuments();
        Record record = new Record();
        record.put("_attachment_body", (Object)document0);
        this.startSession();
        AvroMorphlineTest.assertTrue((boolean)this.morphline.process(record));
        AvroMorphlineTest.assertEquals((long)1L, (long)this.collector.getRecords().size());
        AvroMorphlineTest.assertEquals(Arrays.asList("nadja"), (Object)this.collector.getFirstRecord().get("/mapField/foo/label"));
        AvroMorphlineTest.assertEquals(Arrays.asList(new Object[0]), (Object)this.collector.getFirstRecord().get("/unknownField"));
        this.morphline = this.createMorphline("test-morphlines/extractAvroPathsFlattened", new Config[0]);
        this.deleteAllDocuments();
        record = new Record();
        record.put("_attachment_body", (Object)document0);
        this.startSession();
        AvroMorphlineTest.assertTrue((boolean)this.morphline.process(record));
        AvroMorphlineTest.assertEquals((long)1L, (long)this.collector.getRecords().size());
        AvroMorphlineTest.assertEquals(Arrays.asList("nadja"), (Object)this.collector.getFirstRecord().get("/mapField/foo/label"));
        AvroMorphlineTest.assertEquals(Arrays.asList(new Object[0]), (Object)this.collector.getFirstRecord().get("/unknownField"));
        this.ingestAndVerifyAvro(schema, document0);
        Record event = new Record();
        event.getFields().put((Object)"_attachment_body", (Object)document0);
        this.morphline = this.createMorphline("test-morphlines/extractAvroTree", new Config[0]);
        this.deleteAllDocuments();
        AvroMorphlineTest.assertTrue((boolean)this.load(event));
        AvroMorphlineTest.assertEquals((long)1L, (long)this.queryResultSetSize("*:*"));
        Record first = this.collector.getFirstRecord();
        AvroMorphlineTest.assertEquals(Arrays.asList("nadja"), (Object)first.get("/mapField/foo/label"));
        AbstractParser.removeAttachments((Record)first);
        AvroMorphlineTest.assertEquals((long)1L, (long)first.getFields().asMap().size());
        this.morphline = this.createMorphline("test-morphlines/toAvro", new Config[0]);
        Record jdoc0 = new Record();
        jdoc0.put("_dataset_descriptor_schema", (Object)schema);
        jdoc0.put("mapField", new HashMap(ImmutableMap.of((Object)AvroMorphlineTest.utf8("foo"), (Object)ImmutableMap.of((Object)"label", (Object)"nadja"))));
        Record expect0 = jdoc0.copy();
        expect0.put("_attachment_body", (Object)document0);
        this.processAndVerifySuccess(jdoc0, expect0, false);
        jdoc0 = new Record();
        jdoc0.put("_dataset_descriptor_schema", (Object)schema);
        jdoc0.put("mapField", new HashMap(ImmutableMap.of((Object)AvroMorphlineTest.utf8("foo"), (Object)ImmutableMap.of((Object)"label", (Object)"nadja"))));
        jdoc0.put("mapField", new HashMap(ImmutableMap.of((Object)AvroMorphlineTest.utf8("foo"), (Object)ImmutableMap.of((Object)"label", (Object)"nadja"))));
        this.collector.reset();
        AvroMorphlineTest.assertFalse((boolean)this.morphline.process(jdoc0));
        jdoc0 = new Record();
        jdoc0.put("_dataset_descriptor_schema", (Object)schema);
        jdoc0.put("mapField", new HashMap(ImmutableMap.of((Object)AvroMorphlineTest.utf8("foo"), (Object)ImmutableMap.of())));
        this.collector.reset();
        AvroMorphlineTest.assertFalse((boolean)this.morphline.process(jdoc0));
        Schema schema2 = new Schema.Parser().parse(new File("src/test/resources/test-avro-schemas/intero2.avsc"));
        jdoc0 = new Record();
        jdoc0.put("_dataset_descriptor_schema", (Object)schema2);
        jdoc0.put("mapField", new HashMap(ImmutableMap.of((Object)AvroMorphlineTest.utf8("foo"), (Object)ImmutableMap.of())));
        this.collector.reset();
        AvroMorphlineTest.assertTrue((boolean)this.morphline.process(jdoc0));
        GenericData.Record result = (GenericData.Record)this.collector.getFirstRecord().getFirstValue("_attachment_body");
        GenericData.Record result2 = (GenericData.Record)((Map)result.get("mapField")).get(AvroMorphlineTest.utf8("foo"));
        AvroMorphlineTest.assertEquals((Object)"nadja", (Object)result2.get("label"));
    }

    private void processAndVerifySuccess(Record input, Record expected, boolean isSame) {
        this.collector.reset();
        this.startSession();
        AvroMorphlineTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
        AvroMorphlineTest.assertTrue((boolean)this.morphline.process(input));
        AvroMorphlineTest.assertEquals((Object)expected, (Object)this.collector.getFirstRecord());
        if (isSame) {
            AvroMorphlineTest.assertSame((Object)input, (Object)this.collector.getFirstRecord());
        } else {
            AvroMorphlineTest.assertNotSame((Object)input, (Object)this.collector.getFirstRecord());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ingestAndVerifyAvro(Schema schema, GenericData.Record ... records) throws IOException {
        byte[] bytes;
        String[] formats;
        this.deleteAllDocuments();
        GenericDatumWriter datum = new GenericDatumWriter(schema);
        DataFileWriter writer = new DataFileWriter((DatumWriter)datum);
        writer.setMeta("Meta-Key0", "Meta-Value0");
        writer.setMeta("Meta-Key1", "Meta-Value1");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        writer.create(schema, (OutputStream)bout);
        for (GenericData.Record record : records) {
            writer.append((Object)record);
        }
        writer.flush();
        writer.close();
        DataFileReader reader = new DataFileReader((SeekableInput)new ReadAvroContainerBuilder.ForwardOnlySeekableInputStream((InputStream)new ByteArrayInputStream(bout.toByteArray())), (DatumReader)new GenericDatumReader());
        Schema schema2 = reader.getSchema();
        AvroMorphlineTest.assertEquals((Object)schema, (Object)schema2);
        for (GenericData.Record record : records) {
            AvroMorphlineTest.assertTrue((boolean)reader.hasNext());
            GenericData.Record record2 = (GenericData.Record)reader.next();
            AvroMorphlineTest.assertEquals((Object)record, (Object)record2);
        }
        AvroMorphlineTest.assertFalse((boolean)reader.hasNext());
        reader.close();
        Record event = new Record();
        event.getFields().put((Object)"_attachment_body", (Object)new ByteArrayInputStream(bout.toByteArray()));
        this.morphline = this.createMorphline("test-morphlines/readAvroContainer", new Config[0]);
        this.deleteAllDocuments();
        AvroMorphlineTest.assertTrue((boolean)this.load(event));
        AvroMorphlineTest.assertEquals((long)records.length, (long)this.queryResultSetSize("*:*"));
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        bout = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)bout, null);
        for (GenericData.Record record : records) {
            datumWriter.write((Object)record, (Encoder)encoder);
        }
        encoder.flush();
        Object decoder = DecoderFactory.get().binaryDecoder((InputStream)new ByteArrayInputStream(bout.toByteArray()), null);
        GenericDatumReader datumReader = new GenericDatumReader(schema);
        for (int i = 0; i < records.length; ++i) {
            GenericData.Record record3 = (GenericData.Record)datumReader.read(null, (Decoder)decoder);
            AvroMorphlineTest.assertEquals((Object)records[i], (Object)record3);
        }
        event = new Record();
        event.getFields().put((Object)"_attachment_body", (Object)new ByteArrayInputStream(bout.toByteArray()));
        File tmp = new File("target/tmp-test-schema.avsc");
        try {
            tmp.deleteOnExit();
            Files.write((CharSequence)schema.toString(true), (File)tmp, (Charset)Charsets.UTF_8);
            this.morphline = this.createMorphline("test-morphlines/readAvroWithExternalSchema", new Config[0]);
            this.deleteAllDocuments();
            AvroMorphlineTest.assertTrue((boolean)this.load(event));
            AvroMorphlineTest.assertEquals((long)records.length, (long)this.queryResultSetSize("*:*"));
        }
        finally {
            tmp.delete();
        }
        for (GenericData.Record record : records) {
            event = new Record();
            event.getFields().put((Object)"_attachment_body", (Object)record);
            this.morphline = this.createMorphline("test-morphlines/extractAvroTree", new Config[0]);
            this.deleteAllDocuments();
            AvroMorphlineTest.assertTrue((boolean)this.load(event));
            AvroMorphlineTest.assertEquals((long)1L, (long)this.queryResultSetSize("*:*"));
        }
        for (String format : formats = new String[]{"", "AndSnappy"}) {
            this.morphline = this.createMorphline("test-morphlines/writeAvroToByteArrayWithContainer" + format, new Config[0]);
            event = new Record();
            event.getFields().putAll((Object)"_attachment_body", Arrays.asList(records));
            this.deleteAllDocuments();
            AvroMorphlineTest.assertTrue((boolean)this.load(event));
            AvroMorphlineTest.assertEquals((long)1L, (long)this.collector.getFirstRecord().get("_attachment_body").size());
            bytes = (byte[])this.collector.getFirstRecord().getFirstValue("_attachment_body");
            AvroMorphlineTest.assertNotNull((Object)bytes);
            reader = new DataFileReader((SeekableInput)new ReadAvroContainerBuilder.ForwardOnlySeekableInputStream((InputStream)new ByteArrayInputStream(bytes)), (DatumReader)new GenericDatumReader());
            AvroMorphlineTest.assertEquals((Object)"bar", (Object)new String(reader.getMeta("foo"), Charsets.UTF_8));
            AvroMorphlineTest.assertEquals((Object)"Nadja", (Object)new String(reader.getMeta("firstName"), Charsets.UTF_8));
            AvroMorphlineTest.assertEquals((Object)schema, (Object)reader.getSchema());
            for (GenericData.Record record : records) {
                AvroMorphlineTest.assertTrue((boolean)reader.hasNext());
                GenericData.Record record2 = (GenericData.Record)reader.next();
                AvroMorphlineTest.assertEquals((Object)record, (Object)record2);
            }
            AvroMorphlineTest.assertFalse((boolean)reader.hasNext());
            reader.close();
        }
        for (String format : formats = new String[]{"Binary", "JSON"}) {
            this.morphline = this.createMorphline("test-morphlines/writeAvroToByteArrayWithContainerless" + format, new Config[0]);
            event = new Record();
            event.getFields().putAll((Object)"_attachment_body", Arrays.asList(records));
            this.deleteAllDocuments();
            AvroMorphlineTest.assertTrue((boolean)this.load(event));
            AvroMorphlineTest.assertEquals((long)1L, (long)this.collector.getFirstRecord().get("_attachment_body").size());
            bytes = (byte[])this.collector.getFirstRecord().getFirstValue("_attachment_body");
            AvroMorphlineTest.assertNotNull((Object)bytes);
            decoder = format.equals("Binary") ? DecoderFactory.get().binaryDecoder((InputStream)new ByteArrayInputStream(bytes), null) : DecoderFactory.get().jsonDecoder(schema, (InputStream)new ByteArrayInputStream(bytes));
            datumReader = new GenericDatumReader(schema);
            for (int i = 0; i < records.length; ++i) {
                GenericData.Record record3 = (GenericData.Record)datumReader.read(null, (Decoder)decoder);
                AvroMorphlineTest.assertEquals((Object)records[i], (Object)record3);
            }
            try {
                datumReader.read(null, (Decoder)decoder);
                AvroMorphlineTest.fail();
            }
            catch (EOFException e) {
                // empty catch block
            }
        }
    }

    @Test
    public void testReadAvroWithMissingExternalSchema() throws Exception {
        try {
            this.morphline = this.createMorphline("test-morphlines/readAvroWithMissingExternalSchema", new Config[0]);
            AvroMorphlineTest.fail();
        }
        catch (MorphlineCompilationException e) {
            AvroMorphlineTest.assertTrue((boolean)e.getMessage().startsWith("You must specify an external Avro writer schema because this is required to read containerless Avro"));
        }
    }

    @Test
    public void testReadAvroTweetsContainer() throws Exception {
        this.runTweetContainer("test-morphlines/readAvroTweetsContainer", TWEET_FIELD_NAMES);
    }

    @Test
    public void testReadAvroTweetsContainerWithExternalSchema() throws Exception {
        this.runTweetContainer("test-morphlines/readAvroTweetsContainerWithExternalSchema", TWEET_FIELD_NAMES);
    }

    @Test
    public void testReadAvroTweetsContainerWithExternalSubSchema() throws Exception {
        String[] subSchemaFieldNames = new String[]{"id", "text"};
        this.runTweetContainer("test-morphlines/readAvroTweetsContainerWithExternalSubSchema", subSchemaFieldNames);
    }

    private void runTweetContainer(String morphlineConfigFile, String[] fieldNames) throws Exception {
        File file = new File("target/test-classes/test-documents/sample-statuses-20120906-141433-medium.avro");
        this.morphline = this.createMorphline(morphlineConfigFile, new Config[0]);
        for (int j = 0; j < 3; ++j) {
            Record record = new Record();
            byte[] body = Files.toByteArray((File)file);
            record.put("_attachment_body", (Object)body);
            this.collector.reset();
            this.startSession();
            Notifications.notifyBeginTransaction((Command)this.morphline);
            AvroMorphlineTest.assertTrue((boolean)this.morphline.process(record));
            AvroMorphlineTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
            AvroMorphlineTest.assertEquals((long)2104L, (long)this.collector.getRecords().size());
            DataFileReader reader = new DataFileReader(file, (DatumReader)new GenericDatumReader());
            int i = 0;
            while (reader.hasNext()) {
                Record actual = (Record)this.collector.getRecords().get(i);
                GenericData.Record expected = (GenericData.Record)reader.next();
                this.assertTweetEquals(expected, actual, fieldNames, i);
                ++i;
            }
            AvroMorphlineTest.assertEquals((long)this.collector.getRecords().size(), (long)i);
        }
    }

    @Test
    public void testReadAvroTweetsWithExternalSchema() throws Exception {
        this.runTweets("test-morphlines/readAvroTweetsWithExternalSchema", TWEET_FIELD_NAMES);
    }

    @Test
    public void testReadAvroTweetsWithExternalSubSchema() throws Exception {
        String[] subSchemaFieldNames = new String[]{"id", "text"};
        this.runTweets("test-morphlines/readAvroTweetsWithExternalSubSchema", subSchemaFieldNames);
    }

    @Test
    public void testReadAvroJsonTweetsWithExternalSchema() throws Exception {
        this.runTweets("test-morphlines/readAvroJsonTweetsWithExternalSchema", TWEET_FIELD_NAMES);
    }

    @Test
    public void testReadAvroJsonTweetsWithExternalSubSchema() throws Exception {
        String[] subSchemaFieldNames = new String[]{"id", "text"};
        this.runTweets("test-morphlines/readAvroJsonTweetsWithExternalSubSchema", subSchemaFieldNames);
    }

    private void runTweets(String morphlineConfigFile, String[] fieldNames) throws Exception {
        File file = new File("target/test-classes/test-documents/sample-statuses-20120906-141433-medium.avro");
        ArrayList<GenericData.Record> expecteds = new ArrayList<GenericData.Record>();
        DataFileReader reader = new DataFileReader(file, (DatumReader)new GenericDatumReader());
        Schema schema = reader.getSchema();
        while (reader.hasNext()) {
            GenericData.Record expected = (GenericData.Record)reader.next();
            expecteds.add(expected);
        }
        AvroMorphlineTest.assertEquals((long)2104L, (long)expecteds.size());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Object encoder = morphlineConfigFile.contains("Json") ? EncoderFactory.get().jsonEncoder(schema, (OutputStream)bout) : EncoderFactory.get().binaryEncoder((OutputStream)bout, null);
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        for (GenericData.Record record : expecteds) {
            datumWriter.write((Object)record, (Encoder)encoder);
        }
        encoder.flush();
        this.morphline = this.createMorphline(morphlineConfigFile, new Config[0]);
        for (int j = 0; j < 3; ++j) {
            GenericData.Record record;
            record = new Record();
            record.put("_attachment_body", (Object)bout.toByteArray());
            this.collector.reset();
            this.startSession();
            Notifications.notifyBeginTransaction((Command)this.morphline);
            AvroMorphlineTest.assertTrue((boolean)this.morphline.process((Record)record));
            AvroMorphlineTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
            AvroMorphlineTest.assertEquals((long)2104L, (long)this.collector.getRecords().size());
            reader = new DataFileReader(file, (DatumReader)new GenericDatumReader());
            int i = 0;
            while (reader.hasNext()) {
                Record actual = (Record)this.collector.getRecords().get(i);
                GenericData.Record expected = (GenericData.Record)reader.next();
                this.assertTweetEquals(expected, actual, fieldNames, i);
                ++i;
            }
            AvroMorphlineTest.assertEquals((long)this.collector.getRecords().size(), (long)i);
        }
    }

    private void assertTweetEquals(GenericData.Record expected, Record actual, String[] fieldNames, int i) {
        for (String fieldName : fieldNames) {
            AvroMorphlineTest.assertEquals((String)(i + " fieldName: " + fieldName), (Object)expected.get(fieldName).toString(), (Object)actual.getFirstValue(fieldName).toString());
        }
        for (String fieldName : TWEET_FIELD_NAMES) {
            if (Arrays.asList(fieldNames).contains(fieldName)) continue;
            AvroMorphlineTest.assertFalse((boolean)actual.getFields().containsKey((Object)fieldName));
        }
    }

    @Test
    @Ignore
    public void benchmarkAvro() throws Exception {
        this.benchmarkAvro("test-morphlines/readAvroTweetsWithExternalSchema");
        this.benchmarkAvro("test-morphlines/readAvroJsonTweetsWithExternalSchema");
        this.benchmarkAvro("test-morphlines/readAvroTweetsContainer");
    }

    private void benchmarkAvro(String morphlineConfigFile) throws Exception {
        byte[] bytes;
        System.out.println("Now benchmarking " + morphlineConfigFile + " ...");
        long durationSecs = 10L;
        File file = new File("target/test-classes/test-documents/sample-statuses-20120906-141433.avro");
        this.morphline = this.createMorphline(morphlineConfigFile, new Config[0]);
        if (morphlineConfigFile.contains("Container")) {
            bytes = Files.toByteArray((File)file);
        } else {
            ArrayList<GenericData.Record> expecteds = new ArrayList<GenericData.Record>();
            DataFileReader reader = new DataFileReader(file, (DatumReader)new GenericDatumReader());
            Schema schema = reader.getSchema();
            while (reader.hasNext()) {
                GenericData.Record expected = (GenericData.Record)reader.next();
                expecteds.add(expected);
            }
            AvroMorphlineTest.assertEquals((long)2L, (long)expecteds.size());
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            Object encoder = morphlineConfigFile.contains("Json") ? EncoderFactory.get().jsonEncoder(schema, (OutputStream)bout) : EncoderFactory.get().binaryEncoder((OutputStream)bout, null);
            GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
            for (GenericData.Record record : expecteds) {
                datumWriter.write((Object)record, (Encoder)encoder);
            }
            encoder.flush();
            bytes = bout.toByteArray();
        }
        long start = System.currentTimeMillis();
        long duration = durationSecs * 1000L;
        int iters = 0;
        while (System.currentTimeMillis() < start + duration) {
            Record record = new Record();
            record.put("_attachment_body", (Object)bytes);
            this.collector.reset();
            this.startSession();
            AvroMorphlineTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
            AvroMorphlineTest.assertTrue((boolean)this.morphline.process(record));
            ++iters;
        }
        float secs = (float)(System.currentTimeMillis() - start) / 1000.0f;
        System.out.println("Results: iters=" + iters + ", took[secs]=" + secs + ", iters/secs=" + (float)iters / secs);
    }

    private boolean load(Record record) {
        this.startSession();
        return this.morphline.process(record);
    }

    private int queryResultSetSize(String query) {
        return this.collector.getRecords().size();
    }

    private static Utf8 utf8(String str) {
        return new Utf8(str);
    }

    private String toString(GenericData.Record avroRecord) {
        Record record = new Record();
        for (Schema.Field field : avroRecord.getSchema().getFields()) {
            record.put(field.name(), avroRecord.get(field.pos()));
        }
        return record.toString();
    }
}

