/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.avro;

import com.google.common.annotations.Beta;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.avro.AvroConversions;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.shaded.com.google.common.io.Closeables;
import org.kitesdk.morphline.stdio.AbstractParser;

@Beta
public final class ToAvroMapBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("toAvroMap");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ToAvroMap(this, config, parent, child, context);
    }

    private static final class ToAvroMap
    extends AbstractCommand {
        private final Schema schema;

        public ToAvroMap(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            InputStream in = null;
            try {
                in = ((Object)((Object)this)).getClass().getResourceAsStream("morphlineRecord.avsc");
                this.schema = new Schema.Parser().parse(in);
            }
            catch (IOException e) {
                try {
                    throw new MorphlineCompilationException("Cannot parse morphlineRecord schema", config, (Throwable)e, builder);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(in);
                    throw throwable;
                }
            }
            Closeables.closeQuietly((Closeable)in);
            this.validateArguments();
        }

        protected boolean doProcess(Record inputRecord) {
            Record outputRecord = inputRecord.copy();
            AbstractParser.removeAttachments((Record)outputRecord);
            HashMap map = inputRecord.getFields().asMap();
            map = new HashMap(map);
            Schema.Field field = (Schema.Field)this.schema.getFields().get(0);
            Object avroResult = AvroConversions.toAvro(map, field.schema());
            if (avroResult == AvroConversions.ERROR) {
                this.LOG.debug("Cannot convert record: {} to schema: {}", (Object)inputRecord, (Object)this.schema);
                return false;
            }
            GenericData.Record avroRecord = new GenericData.Record(this.schema);
            avroRecord.put(field.pos(), avroResult);
            outputRecord.put("_attachment_body", (Object)avroRecord);
            return super.doProcess(outputRecord);
        }
    }
}

