/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.maxmind;

import com.typesafe.config.Config;
import org.junit.Ignore;
import org.junit.Test;
import org.kitesdk.morphline.api.AbstractMorphlineTest;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.Notifications;

public class MaxmindMorphlineTest
extends AbstractMorphlineTest {
    @Test
    public void testIPv4() throws Exception {
        this.morphline = this.createMorphline("test-morphlines/geoIP", new Config[0]);
        Record record = new Record();
        String ip = "128.101.101.101";
        record.put("ip", (Object)ip);
        Record expected = new Record();
        expected.put("ip", (Object)ip);
        expected.put("/country/iso_code", (Object)"US");
        expected.put("/country/names/en", (Object)"United States");
        expected.put("/country/names/zh-CN", (Object)"\u7f8e\u56fd");
        expected.put("/subdivisions[]/names/en", (Object)"Minnesota");
        expected.put("/subdivisions[]/iso_code", (Object)"MN");
        expected.put("/city/names/en", (Object)"Minneapolis");
        expected.put("/postal/code", (Object)"55455");
        expected.put("/location/latitude", (Object)44.9733);
        expected.put("/location/longitude", (Object)-93.2323);
        expected.put("/location/latitude_longitude", (Object)"44.9733,-93.2323");
        expected.put("/location/longitude_latitude", (Object)"-93.2323,44.9733");
        this.processAndVerifySuccess(record, expected, false);
        Notifications.notifyShutdown((Command)this.morphline);
        Notifications.notifyShutdown((Command)this.morphline);
    }

    @Test
    public void testIPv6() throws Exception {
        this.morphline = this.createMorphline("test-morphlines/geoIP", new Config[0]);
        Record record = new Record();
        String ip = "2001:620::1";
        record.put("ip", (Object)ip);
        Record expected = new Record();
        expected.put("ip", (Object)ip);
        expected.put("/country/iso_code", (Object)"CH");
        expected.put("/country/names/en", (Object)"Switzerland");
        expected.put("/country/names/zh-CN", (Object)"\u745e\u58eb");
        expected.put("/location/latitude", (Object)47.00016);
        expected.put("/location/longitude", (Object)8.01427);
        expected.put("/location/latitude_longitude", (Object)"47.00016,8.01427");
        expected.put("/location/longitude_latitude", (Object)"8.01427,47.00016");
        this.processAndVerifySuccess(record, expected, false);
        Notifications.notifyShutdown((Command)this.morphline);
        Notifications.notifyShutdown((Command)this.morphline);
    }

    private void processAndVerifySuccess(Record input, Record expected, boolean isSame) {
        this.collector.reset();
        this.startSession();
        MaxmindMorphlineTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
        MaxmindMorphlineTest.assertTrue((boolean)this.morphline.process(input));
        this.collector.getFirstRecord().removeAll("_attachment_body");
        MaxmindMorphlineTest.assertEquals((Object)expected, (Object)this.collector.getFirstRecord());
        if (isSame) {
            MaxmindMorphlineTest.assertSame((Object)input, (Object)this.collector.getFirstRecord());
        } else {
            MaxmindMorphlineTest.assertNotSame((Object)input, (Object)this.collector.getFirstRecord());
        }
    }

    @Test
    @Ignore
    public void benchmark() throws Exception {
        String morphlineConfigFile = "test-morphlines/geoIP";
        long durationSecs = 20L;
        System.out.println("Now benchmarking " + morphlineConfigFile + " ...");
        this.morphline = this.createMorphline(morphlineConfigFile, new Config[0]);
        long start = System.currentTimeMillis();
        long duration = durationSecs * 1000L;
        int iters = 0;
        while (System.currentTimeMillis() < start + duration) {
            Record record = new Record();
            String msg = "128.101.101.101";
            record.put("ip", (Object)msg);
            this.collector.reset();
            this.startSession();
            MaxmindMorphlineTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
            MaxmindMorphlineTest.assertTrue((boolean)this.morphline.process(record));
            ++iters;
        }
        float secs = (float)(System.currentTimeMillis() - start) / 1000.0f;
        System.out.println("Results: iters=" + iters + ", took[secs]=" + secs + ", iters/secs=" + (float)iters / secs);
    }
}

