/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.maxmind;

import com.fasterxml.jackson.databind.JsonNode;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import org.junit.After;
import org.junit.Ignore;
import org.junit.Test;
import org.kitesdk.morphline.api.AbstractMorphlineTest;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.Notifications;
import org.kitesdk.morphline.maxmind.GeoIPBuilder;

public class MaxmindMorphlineTest
extends AbstractMorphlineTest {
    private Command buildCommand(String inputField, String db) {
        Config config = ConfigFactory.parseString((String)String.format("inputField=%s\ndatabase=target/test-classes/%s\n", inputField, db));
        return new GeoIPBuilder().build(config, (Command)new RootCommand(), (Command)this.collector, new MorphlineContext.Builder().build());
    }

    @After
    public void tearDown() throws Exception {
        if (this.morphline != null) {
            Notifications.notifyShutdown((Command)this.morphline);
            Notifications.notifyShutdown((Command)this.morphline);
            this.morphline = null;
        }
        super.tearDown();
    }

    @Test
    public void testIPv4CountryOnly() throws Exception {
        this.morphline = this.buildCommand("ip", "GeoLite2-Country.mmdb");
        Record record = new Record();
        String ip = "128.101.101.101";
        record.put("ip", (Object)"128.101.101.101");
        this.processAndVerifySuccess2(record, true, false, 6252001, null);
    }

    @Test
    public void testNotFoundIPv4() throws Exception {
        this.morphline = this.buildCommand("ip", "GeoLite2-City.mmdb");
        Record record = new Record();
        String ip = "127.0.0.1";
        record.put("ip", (Object)"127.0.0.1");
        this.processAndVerifySuccess2(record, false, false, null, null);
    }

    @Test
    public void testBadData() throws Exception {
        this.morphline = this.buildCommand("ip", "GeoLite2-City.mmdb");
        Record record = new Record();
        String ip = "DAT DATA";
        record.put("ip", (Object)"DAT DATA");
        this.processAndVerifySuccess2(record, false, false, null, null);
    }

    @Test
    public void testEmpty() throws Exception {
        this.morphline = this.buildCommand("ip", "GeoLite2-City.mmdb");
        Record record = new Record();
        this.processAndVerifySuccess2(record, false, false, null, null);
    }

    @Test
    public void testIPv6CountryOnly() throws Exception {
        this.morphline = this.buildCommand("ip", "GeoLite2-Country.mmdb");
        Record record = new Record();
        String ip = "2001:4860:4860::8888";
        record.put("ip", (Object)"2001:4860:4860::8888");
        this.processAndVerifySuccess2(record, true, false, 6252001, null);
    }

    @Test
    public void testNotFoundIPv6() throws Exception {
        this.morphline = this.buildCommand("ip", "GeoLite2-City.mmdb");
        Record record = new Record();
        String ip = "::1";
        record.put("ip", (Object)"::1");
        this.processAndVerifySuccess2(record, false, false, null, null);
    }

    @Test(expected=MorphlineCompilationException.class)
    public void testBadDBPath() throws Exception {
        this.buildCommand("ip", "BAD-PATH-MMDB");
    }

    private void processAndVerifySuccess2(Record input, boolean isSuccess, boolean isSame, Integer countryGeoNameId, Integer cityGeoNameId) {
        Record inputCopy = input.copy();
        this.collector.reset();
        this.startSession();
        MaxmindMorphlineTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
        MaxmindMorphlineTest.assertEquals((Object)isSuccess, (Object)this.morphline.process(inputCopy));
        if (!isSuccess) {
            MaxmindMorphlineTest.assertEquals((long)0L, (long)this.collector.getRecords().size());
        } else {
            MaxmindMorphlineTest.assertEquals((long)1L, (long)this.collector.getRecords().size());
            Record actual = this.collector.getFirstRecord();
            Object body = actual.getFirstValue("_attachment_body");
            actual.removeAll("_attachment_body");
            MaxmindMorphlineTest.assertEquals((Object)input, (Object)actual);
            MaxmindMorphlineTest.assertTrue((boolean)(body instanceof JsonNode));
            JsonNode jsonNode = (JsonNode)body;
            MaxmindMorphlineTest.assertNotNull((Object)jsonNode);
            JsonNode countryNode = jsonNode.get("country");
            if (countryGeoNameId != null) {
                MaxmindMorphlineTest.assertNotNull((Object)countryNode);
                MaxmindMorphlineTest.assertEquals((long)countryGeoNameId.intValue(), (long)countryNode.get("geoname_id").asInt());
            } else {
                MaxmindMorphlineTest.assertNull((Object)countryNode);
            }
            JsonNode cityNode = jsonNode.get("city");
            if (cityGeoNameId != null) {
                MaxmindMorphlineTest.assertNotNull((Object)cityNode);
                MaxmindMorphlineTest.assertEquals((long)cityGeoNameId.intValue(), (long)cityNode.get("geoname_id").asInt());
            } else {
                MaxmindMorphlineTest.assertNull((Object)cityNode);
            }
        }
    }

    @Test
    public void testIPv4() throws Exception {
        this.morphline = this.createMorphline("test-morphlines/geoIP", new Config[0]);
        Record record = new Record();
        String ip = "128.101.101.101";
        record.put("ip", (Object)ip);
        Record expected = new Record();
        expected.put("ip", (Object)ip);
        expected.put("/country/iso_code", (Object)"US");
        expected.put("/country/names/en", (Object)"United States");
        expected.put("/country/names/zh-CN", (Object)"\u7f8e\u56fd");
        expected.put("/subdivisions[]/names/en", (Object)"Minnesota");
        expected.put("/subdivisions[]/iso_code", (Object)"MN");
        expected.put("/city/names/en", (Object)"Minneapolis");
        expected.put("/postal/code", (Object)"55455");
        expected.put("/location/latitude", (Object)44.9733);
        expected.put("/location/longitude", (Object)-93.2323);
        expected.put("/location/latitude_longitude", (Object)"44.9733,-93.2323");
        expected.put("/location/longitude_latitude", (Object)"-93.2323,44.9733");
        this.processAndVerifySuccess(record, expected, false);
    }

    @Test
    public void testIPv6() throws Exception {
        this.morphline = this.createMorphline("test-morphlines/geoIP", new Config[0]);
        Record record = new Record();
        String ip = "2001:620::1";
        record.put("ip", (Object)ip);
        Record expected = new Record();
        expected.put("ip", (Object)ip);
        expected.put("/country/iso_code", (Object)"CH");
        expected.put("/country/names/en", (Object)"Switzerland");
        expected.put("/country/names/zh-CN", (Object)"\u745e\u58eb");
        expected.put("/location/latitude", (Object)47.00016);
        expected.put("/location/longitude", (Object)8.01427);
        expected.put("/location/latitude_longitude", (Object)"47.00016,8.01427");
        expected.put("/location/longitude_latitude", (Object)"8.01427,47.00016");
        this.processAndVerifySuccess(record, expected, false);
    }

    private void processAndVerifySuccess(Record input, Record expected, boolean isSame) {
        this.collector.reset();
        this.startSession();
        MaxmindMorphlineTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
        MaxmindMorphlineTest.assertTrue((boolean)this.morphline.process(input));
        this.collector.getFirstRecord().removeAll("_attachment_body");
        MaxmindMorphlineTest.assertEquals((Object)expected, (Object)this.collector.getFirstRecord());
        if (isSame) {
            MaxmindMorphlineTest.assertSame((Object)input, (Object)this.collector.getFirstRecord());
        } else {
            MaxmindMorphlineTest.assertNotSame((Object)input, (Object)this.collector.getFirstRecord());
        }
    }

    @Test
    @Ignore
    public void benchmark() throws Exception {
        String morphlineConfigFile = "test-morphlines/geoIP";
        long durationSecs = 20L;
        System.out.println("Now benchmarking " + morphlineConfigFile + " ...");
        this.morphline = this.createMorphline(morphlineConfigFile, new Config[0]);
        long start = System.currentTimeMillis();
        long duration = durationSecs * 1000L;
        int iters = 0;
        while (System.currentTimeMillis() < start + duration) {
            Record record = new Record();
            String msg = "128.101.101.101";
            record.put("ip", (Object)msg);
            this.collector.reset();
            this.startSession();
            MaxmindMorphlineTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
            MaxmindMorphlineTest.assertTrue((boolean)this.morphline.process(record));
            ++iters;
        }
        float secs = (float)(System.currentTimeMillis() - start) / 1000.0f;
        System.out.println("Results: iters=" + iters + ", took[secs]=" + secs + ", iters/secs=" + (float)iters / secs);
    }

    private static final class RootCommand
    implements Command {
        private RootCommand() {
        }

        public Command getParent() {
            return null;
        }

        public void notify(Record notification) {
            throw new UnsupportedOperationException("Root command should be invisible and must not be called");
        }

        public boolean process(Record record) {
            throw new UnsupportedOperationException("Root command should be invisible and must not be called");
        }
    }
}

