/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.saxon;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.typesafe.config.Config;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.junit.Ignore;
import org.junit.Test;
import org.kitesdk.morphline.api.AbstractMorphlineTest;
import org.kitesdk.morphline.api.Record;

public class SaxonMorphlineTest
extends AbstractMorphlineTest {
    @Test
    public void testXQueryTweetTexts() throws Exception {
        this.morphline = this.createMorphline("test-morphlines/xquery-tweet-texts", new Config[0]);
        FileInputStream in = new FileInputStream(new File("target/test-classes/test-documents/sample-statuses-20120906-141433.xml"));
        Record record = new Record();
        record.put("id", (Object)"123");
        record.put("_attachment_body", (Object)in);
        this.processAndVerifySuccess(record, new Multimap[]{ImmutableMultimap.of((Object)"id", (Object)"123", (Object)"text", (Object)"sample tweet one"), ImmutableMultimap.of((Object)"id", (Object)"123", (Object)"text", (Object)"sample tweet two")});
        ((InputStream)in).close();
    }

    @Test
    public void testXQueryTweetUsers() throws Exception {
        this.morphline = this.createMorphline("test-morphlines/xquery-tweet-users", new Config[0]);
        FileInputStream in = new FileInputStream(new File("target/test-classes/test-documents/sample-statuses-20120906-141433.xml"));
        Record record = new Record();
        record.put("_attachment_body", (Object)in);
        this.processAndVerifySuccess(record, new Multimap[]{ImmutableMultimap.of((Object)"followers_count", (Object)"111", (Object)"id", (Object)"11111112", (Object)"screen_name", (Object)"fake_user1", (Object)"greeting", (Object)"hello world", (Object)"annotation", (Object)"An XSLT Morphline"), ImmutableMultimap.of((Object)"followers_count", (Object)"222", (Object)"id", (Object)"222223", (Object)"screen_name", (Object)"fake_user2", (Object)"greeting", (Object)"hello world", (Object)"annotation", (Object)"An XSLT Morphline")});
        ((InputStream)in).close();
    }

    @Test
    public void testXQueryAtomFeeds() throws Exception {
        this.morphline = this.createMorphline("test-morphlines/xquery-atom-feeds", new Config[0]);
        FileInputStream in = new FileInputStream(new File("target/test-classes/test-documents/atom.xml"));
        Record record = new Record();
        record.put("_attachment_body", (Object)in);
        this.processAndVerifySuccess(record, new Multimap[]{ImmutableMultimap.of((Object)"id", (Object)"tag:blogger.com,1999:blog-10832468.post-112136653221060965", (Object)"summary", (Object)"A Great Place To Pick Up Cast Iron Pan Or Circulon Cookware On The Web \t\t \t\tYou don't have to wait to get the cast iron pan that is right for you.  Everything you need to know about cast iron pan is online.  All this came to me as I was looking out the window.  You decide what cast iron pan is right for you. It is so easy and fast!  Cast Iron Pan : Cast Iron Pan", (Object)"title", (Object)"Cast Iron Pan", (Object)"generator", (Object)"Blogger"), ImmutableMultimap.of((Object)"id", (Object)"tag:blogger.com,1999:blog-10832468.post-112135176551133849", (Object)"summary", (Object)"A Great Place To Shop For Soapstone Cookware Or Roll Pan Cheap \t\t \t\tThe best part about it is, it's so easy.  You will always have your soapstone cookware.  Go over to Google and type in soapstone cookware in the search form.  soapstone cookware popped right out in front of me.  Just try a single search for soapstone cookware.  Soapstone Cookware : Soapstone Cookware", (Object)"title", (Object)"Soapstone Cookware", (Object)"generator", (Object)"Blogger"), ImmutableMultimap.of((Object)"id", (Object)"tag:blogger.com,1999:blog-10832468.post-112133988275976426", (Object)"summary", (Object)"The Best Place To Obtain Air Core Cookware Set Or Cookware Stores On The Internet \t\t \t\tThere is no better way to get air core cookware set faster.  Everything you need to know about air core cookware set is online.  The internet is the place to find it.  This is not just local info, you literally have access to worldwide solutions for air core cookware set.  The online forms to get my air core", (Object)"title", (Object)"Air Core Cookware Set", (Object)"generator", (Object)"Blogger")});
        ((InputStream)in).close();
    }

    @Test
    public void testXQueryShakespeareSpeakers() throws Exception {
        this.morphline = this.createMorphline("test-morphlines/xquery-shakespeare-speakers", new Config[0]);
        FileInputStream in = new FileInputStream(new File("target/test-classes/test-documents/othello.xml"));
        Record record = new Record();
        record.put("_attachment_body", (Object)in);
        this.processAndVerifySuccess(record, new Multimap[]{ImmutableMultimap.of((Object)"name", (Object)"OTHELLO", (Object)"frequency", (Object)"274"), ImmutableMultimap.of((Object)"name", (Object)"IAGO", (Object)"frequency", (Object)"272"), ImmutableMultimap.of((Object)"name", (Object)"DESDEMONA", (Object)"frequency", (Object)"165")});
        ((InputStream)in).close();
    }

    @Test
    public void testXQueryAtomicValues() throws Exception {
        this.morphline = this.createMorphline("test-morphlines/xquery-atomic-values", new Config[0]);
        FileInputStream in = new FileInputStream(new File("target/test-classes/test-documents/sample-statuses-20120906-141433.xml"));
        Record record = new Record();
        record.put("_attachment_body", (Object)in);
        this.processAndVerifySuccess(record, new Multimap[0]);
        ((InputStream)in).close();
    }

    @Test
    public void testXsltIdentityHelloWorld() throws Exception {
        this.morphline = this.createMorphline("test-morphlines/xslt-helloworld-identity", new Config[0]);
        FileInputStream in = new FileInputStream(new File("target/test-classes/test-documents/helloworld.xml"));
        Record record = new Record();
        record.put("_attachment_body", (Object)in);
        this.processAndVerifySuccess(record, new Multimap[]{ImmutableMultimap.of((Object)"description", (Object)"An XSLT Morphline", (Object)"welcome", (Object)"Hello, World!", (Object)"id", (Object)"2")});
        ((InputStream)in).close();
    }

    @Test
    public void testXsltHelloWorldSequence() throws Exception {
        this.morphline = this.createMorphline("test-morphlines/xslt-helloworld-sequence", new Config[0]);
        FileInputStream in = new FileInputStream(new File("target/test-classes/test-documents/helloworld.xml"));
        Record record = new Record();
        record.put("id", (Object)"123");
        record.put("_attachment_body", (Object)in);
        this.processAndVerifySuccess(record, new Multimap[]{ImmutableMultimap.of((Object)"id", (Object)"123", (Object)"attr", (Object)"foo", (Object)"HEAD", (Object)"title1", (Object)"BODY", (Object)"Hello, World!Paragraph1aParagraph1b"), ImmutableMultimap.of((Object)"id", (Object)"123", (Object)"HEAD", (Object)"title2", (Object)"BODY", (Object)"Hello, World!Paragraph2aParagraph2b")});
        ((InputStream)in).close();
    }

    @Test
    public void testXQueryJoin() throws Exception {
        File table = new File("target/test-table.xml");
        this.generateTestTable(table, 3);
        this.morphline = this.createMorphline("test-morphlines/xquery-join", new Config[0]);
        FileInputStream in = new FileInputStream(new File("target/test-classes/test-documents/helloworld.xml"));
        Record record = new Record();
        record.put("id", (Object)"123");
        record.put("_attachment_body", (Object)in);
        this.processAndVerifySuccess(record, new Multimap[]{ImmutableMultimap.of((Object)"id", (Object)"123", (Object)"outputId", (Object)"2", (Object)"outputText", (Object)"Hello, World!")});
        ((InputStream)in).close();
    }

    private void generateTestTable(File file, int numRecords) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), Charsets.UTF_8));
        writer.write("<items>");
        for (int i = 0; i < numRecords; ++i) {
            writer.write("\n<item id=\"" + i + "\">" + i + "</item>");
        }
        writer.write("\n</items>");
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    @Test
    @Ignore
    public void benchmarkSaxon() throws Exception {
        File table = new File("target/test-table.xml");
        this.generateTestTable(table, 1000000);
        System.out.println("Setup done.");
        String morphlineConfigFile = "test-morphlines/xquery-join";
        long durationSecs = 20L;
        File file = new File("target/test-classes/test-documents/helloworld.xml");
        System.out.println("Now benchmarking " + morphlineConfigFile + " ...");
        this.morphline = this.createMorphline(morphlineConfigFile, new Config[0]);
        byte[] bytes = Files.toByteArray((File)file);
        long start = System.currentTimeMillis();
        long duration = durationSecs * 1000L;
        int iters = 0;
        while (System.currentTimeMillis() < start + duration) {
            Record record = new Record();
            record.put("_attachment_body", (Object)bytes);
            this.collector.reset();
            this.startSession();
            SaxonMorphlineTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
            SaxonMorphlineTest.assertTrue((boolean)this.morphline.process(record));
            ++iters;
        }
        float secs = (float)(System.currentTimeMillis() - start) / 1000.0f;
        System.out.println("Results: iters=" + iters + ", took[secs]=" + secs + ", iters/secs=" + (float)iters / secs);
    }

    private void processAndVerifySuccess(Record input, Multimap ... expectedMaps) {
        this.collector.reset();
        this.startSession();
        SaxonMorphlineTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
        SaxonMorphlineTest.assertTrue((boolean)this.morphline.process(input));
        Iterator iter = this.collector.getRecords().iterator();
        int i = 0;
        for (Multimap expected : expectedMaps) {
            SaxonMorphlineTest.assertTrue((boolean)iter.hasNext());
            SaxonMorphlineTest.assertEquals((Object)expected, (Object)((Record)iter.next()).getFields());
            ++i;
        }
        SaxonMorphlineTest.assertFalse((boolean)iter.hasNext());
    }
}

