/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.saxon;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.typesafe.config.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Ignore;
import org.junit.Test;
import org.kitesdk.morphline.api.AbstractMorphlineTest;
import org.kitesdk.morphline.api.Collector;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.Notifications;
import org.kitesdk.morphline.stdlib.PipeBuilder;

public class TagsoupMorphlineTest
extends AbstractMorphlineTest {
    @Test
    public void testConvertHTML() throws Exception {
        this.morphline = this.createMorphline("test-morphlines/convertHTML", new Config[0]);
        FileInputStream in = new FileInputStream(new File("target/test-classes/test-documents/helloworld.html"));
        Record record = new Record();
        record.put("id", (Object)"123");
        record.put("_attachment_body", (Object)in);
        String expected = Files.toString((File)new File("target/test-classes/test-documents/convertHTML-expected-output.xml"), (Charset)Charsets.UTF_8);
        this.processAndVerifySuccess(record, new Multimap[]{ImmutableMultimap.of((Object)"id", (Object)"123", (Object)"message", (Object)expected)});
        ((InputStream)in).close();
    }

    @Test
    public void testConvertHTMLBlog() throws Exception {
        this.morphline = this.createMorphline("test-morphlines/convertHTML", new Config[0]);
        FileInputStream in = new FileInputStream(new File("target/test-classes/test-documents/blog.html"));
        Record record = new Record();
        record.put("id", (Object)"123");
        record.put("_attachment_body", (Object)in);
        String expected = Files.toString((File)new File("target/test-classes/test-documents/convertHTMLBlog-expected-output.xml"), (Charset)Charsets.UTF_8);
        this.processAndVerifySuccess(record, new Multimap[]{ImmutableMultimap.of((Object)"id", (Object)"123", (Object)"message", (Object)expected)});
        ((InputStream)in).close();
    }

    @Test
    public void testConvertHTMLBlogThenRunXSQLT() throws Exception {
        this.morphline = this.createMorphline("test-morphlines/convertHTMLBlogThenRunXSLT", new Config[0]);
        byte[] bytes = Files.toByteArray((File)new File("target/test-classes/test-documents/blog.html"));
        Record record = new Record();
        record.put("id", (Object)"123");
        record.put("_attachment_body", (Object)bytes);
        for (int i = 0; i < 3; ++i) {
            TagsoupMorphlineTest.assertTrue((boolean)this.morphline.process(record.copy()));
        }
    }

    @Test
    public void testConvertHTMLAndExtractLinks() throws Exception {
        this.morphline = this.createMorphline("test-morphlines/convertHTMLandExtractLinks", new Config[0]);
        FileInputStream in = new FileInputStream(new File("target/test-classes/test-documents/helloworld.html"));
        Record record = new Record();
        record.put("id", (Object)"123");
        record.put("_attachment_body", (Object)in);
        this.processAndVerifySuccess(record, new Multimap[]{ImmutableMultimap.of((Object)"id", (Object)"123", (Object)"a", (Object)"Visit Foo!", (Object)"myhref", (Object)"http://www.foo.com/", (Object)"mytarget", (Object)"_foo"), ImmutableMultimap.of((Object)"id", (Object)"123", (Object)"a", (Object)"Visit Bar!", (Object)"myhref", (Object)"http://www.bar.com/")});
        ((InputStream)in).close();
    }

    private void processAndVerifySuccess(Record input, Multimap ... expectedMaps) {
        this.collector.reset();
        this.startSession();
        TagsoupMorphlineTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
        TagsoupMorphlineTest.assertTrue((boolean)this.morphline.process(input));
        Iterator iter = this.collector.getRecords().iterator();
        int i = 0;
        for (Multimap expected : expectedMaps) {
            TagsoupMorphlineTest.assertTrue((boolean)iter.hasNext());
            TagsoupMorphlineTest.assertEquals((Object)expected, (Object)((Record)iter.next()).getFields());
            ++i;
        }
        TagsoupMorphlineTest.assertFalse((boolean)iter.hasNext());
    }

    private void processAndVerifySuccess(Command myMorphline, Collector myCollector, Record input, Multimap ... expectedMaps) {
        myCollector.reset();
        Notifications.notifyStartSession((Command)myMorphline);
        TagsoupMorphlineTest.assertEquals((long)1L, (long)myCollector.getNumStartEvents());
        TagsoupMorphlineTest.assertTrue((boolean)myMorphline.process(input));
        Iterator iter = myCollector.getRecords().iterator();
        int i = 0;
        for (Multimap expected : expectedMaps) {
            TagsoupMorphlineTest.assertTrue((boolean)iter.hasNext());
            TagsoupMorphlineTest.assertEquals((Object)expected, (Object)((Record)iter.next()).getFields());
            ++i;
        }
        TagsoupMorphlineTest.assertFalse((boolean)iter.hasNext());
    }

    @Test
    @Ignore
    public void testMultiThreading() throws Exception {
        byte[] bytes = Files.toByteArray((File)new File("target/test-classes/test-documents/helloworld.html"));
        String expected = Files.toString((File)new File("target/test-classes/test-documents/convertHTML-expected-output.xml"), (Charset)Charsets.UTF_8);
        this.testMultiThreading(bytes, expected);
    }

    @Test
    @Ignore
    public void testMultiThreadingBlog() throws Exception {
        byte[] bytes = Files.toByteArray((File)new File("target/test-classes/test-documents/blog.html"));
        String expected = Files.toString((File)new File("target/test-classes/test-documents/convertHTMLBlog-expected-output.xml"), (Charset)Charsets.UTF_8);
        this.testMultiThreading(bytes, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMultiThreading(final byte[] bytes, final String expected) throws Exception {
        Logger logger = Logger.getLogger(MorphlineContext.class);
        Level oldLevel = logger.getLevel();
        logger.setLevel(Level.WARN);
        final AtomicLong totalIters = new AtomicLong(0L);
        final CountDownLatch hasException = new CountDownLatch(1);
        try {
            int t;
            int numThreads = 16;
            int durationMillis = 2000;
            Thread[] threads = new Thread[numThreads];
            for (t = 0; t < numThreads; ++t) {
                threads[t] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int iters = 0;
                            MorphlineContext ctx = new MorphlineContext.Builder().build();
                            Config config = TagsoupMorphlineTest.this.parse("test-morphlines/convertHTML", new Config[0]);
                            Collector myCollector = new Collector();
                            Command myMorphline = new PipeBuilder().build(config, null, (Command)myCollector, ctx);
                            long start = System.currentTimeMillis();
                            while (System.currentTimeMillis() < start + 2000L) {
                                Record record = new Record();
                                record.put("id", (Object)"123");
                                record.put("_attachment_body", (Object)bytes);
                                for (int i = 0; i < 3; ++i) {
                                    TagsoupMorphlineTest.this.processAndVerifySuccess(myMorphline, myCollector, record.copy(), new Multimap[]{ImmutableMultimap.of((Object)"id", (Object)"123", (Object)"message", (Object)expected)});
                                }
                                ++iters;
                            }
                            totalIters.addAndGet(iters);
                        }
                        catch (Exception e) {
                            hasException.countDown();
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            for (t = 0; t < numThreads; ++t) {
                threads[t].start();
            }
            for (t = 0; t < numThreads; ++t) {
                threads[t].join();
            }
        }
        finally {
            logger.setLevel(oldLevel);
        }
        System.out.println("tagsoupTotalIters=" + totalIters);
        TagsoupMorphlineTest.assertTrue((hasException.getCount() > 0L ? 1 : 0) != 0);
    }
}

