/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.saxon;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class MyConcatExtensionFunctionDefinition
extends ExtensionFunctionDefinition {
    public StructuredQName getFunctionQName() {
        return new StructuredQName("myfn", "my.custom.uri", "my-concat-def");
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.ANY_SEQUENCE};
    }

    public SequenceType getResultType(SequenceType[] sequenceTypes) {
        return SequenceType.SINGLE_STRING;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext ctx, Sequence[] secs) throws XPathException {
                if (secs.length == 0) {
                    throw new XPathException("Missing argument");
                }
                StringBuilder buf = new StringBuilder();
                for (Sequence seq : secs) {
                    SequenceIterator iter = seq.iterate();
                    while (iter.next() != null) {
                        buf.append(iter.current().getStringValue());
                    }
                }
                return new StringValue((CharSequence)buf.toString());
            }
        };
    }
}

