/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.twitter;

import com.typesafe.config.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TimeZone;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.morphline.api.AbstractMorphlineTest;
import org.kitesdk.morphline.api.Record;

public class ReadJsonTweetsTest
extends AbstractMorphlineTest {
    private TimeZone defaultTimeZone = TimeZone.getDefault();

    @Before
    public void setUp() throws Exception {
        TimeZone.setDefault(TimeZone.getTimeZone("US/Pacific"));
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        TimeZone.setDefault(this.defaultTimeZone);
    }

    @Test
    public void testReadJsonTweets() throws Exception {
        this.morphline = this.createMorphline("test-morphlines/readJsonTweets", new Config[0]);
        Record record = new Record();
        record.put("_attachment_body", (Object)this.getInputStream("non-length-delimited-20130430-234145-tweets.json.gz"));
        record.put("_attachment_name", (Object)"non-length-delimited-20130430-234145-tweets.json.gz");
        this.startSession();
        ReadJsonTweetsTest.assertTrue((boolean)this.morphline.process(record));
        ReadJsonTweetsTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
        Iterator iter = this.collector.getRecords().iterator();
        ReadJsonTweetsTest.assertEquals(Arrays.asList("1985-09-04T18:01:01Z"), (Object)((Record)iter.next()).get("created_at"));
        ReadJsonTweetsTest.assertEquals(Arrays.asList("1985-09-04T19:14:34Z"), (Object)((Record)iter.next()).get("created_at"));
        ReadJsonTweetsTest.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testReadJsonTweetsLengthDelimited() throws Exception {
        this.morphline = this.createMorphline("test-morphlines/readJsonTweetsLengthDelimited", new Config[0]);
        Record record = new Record();
        record.put("_attachment_body", (Object)this.getInputStream("sample-statuses-20120906-141433"));
        this.startSession();
        ReadJsonTweetsTest.assertTrue((boolean)this.morphline.process(record));
        ReadJsonTweetsTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
        Iterator iter = this.collector.getRecords().iterator();
        ReadJsonTweetsTest.assertEquals(Arrays.asList("1985-09-04T18:01:01Z"), (Object)((Record)iter.next()).get("created_at"));
        ReadJsonTweetsTest.assertEquals(Arrays.asList("1985-09-04T19:14:34Z"), (Object)((Record)iter.next()).get("created_at"));
        ReadJsonTweetsTest.assertFalse((boolean)iter.hasNext());
    }

    private InputStream getInputStream(String file) throws FileNotFoundException {
        return new FileInputStream(new File("target/test-classes/test-documents/" + file));
    }
}

