/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import org.apache.hadoop.fs.BlockLocation;
import org.junit.Assert;
import org.junit.Test;

public class TestBlockLocation {
    private static final String[] EMPTY_STR_ARRAY = new String[0];

    private static void checkBlockLocation(BlockLocation loc) throws Exception {
        TestBlockLocation.checkBlockLocation(loc, 0L, 0L, false);
    }

    private static void checkBlockLocation(BlockLocation loc, long offset, long length, boolean corrupt) throws Exception {
        TestBlockLocation.checkBlockLocation(loc, EMPTY_STR_ARRAY, EMPTY_STR_ARRAY, EMPTY_STR_ARRAY, EMPTY_STR_ARRAY, offset, length, corrupt);
    }

    private static void checkBlockLocation(BlockLocation loc, String[] names, String[] hosts, String[] cachedHosts, String[] topologyPaths, long offset, long length, boolean corrupt) throws Exception {
        Assert.assertNotNull((Object)loc.getHosts());
        Assert.assertNotNull((Object)loc.getCachedHosts());
        Assert.assertNotNull((Object)loc.getNames());
        Assert.assertNotNull((Object)loc.getTopologyPaths());
        Assert.assertArrayEquals((Object[])hosts, (Object[])loc.getHosts());
        Assert.assertArrayEquals((Object[])cachedHosts, (Object[])loc.getCachedHosts());
        Assert.assertArrayEquals((Object[])names, (Object[])loc.getNames());
        Assert.assertArrayEquals((Object[])topologyPaths, (Object[])loc.getTopologyPaths());
        Assert.assertEquals((long)offset, (long)loc.getOffset());
        Assert.assertEquals((long)length, (long)loc.getLength());
        Assert.assertEquals((Object)corrupt, (Object)loc.isCorrupt());
    }

    @Test(timeout=5000L)
    public void testBlockLocationConstructors() throws Exception {
        BlockLocation loc = new BlockLocation();
        TestBlockLocation.checkBlockLocation(loc);
        loc = new BlockLocation(null, null, 1L, 2L);
        TestBlockLocation.checkBlockLocation(loc, 1L, 2L, false);
        loc = new BlockLocation(null, null, null, 1L, 2L);
        TestBlockLocation.checkBlockLocation(loc, 1L, 2L, false);
        loc = new BlockLocation(null, null, null, 1L, 2L, true);
        TestBlockLocation.checkBlockLocation(loc, 1L, 2L, true);
        loc = new BlockLocation(null, null, null, null, 1L, 2L, true);
        TestBlockLocation.checkBlockLocation(loc, 1L, 2L, true);
    }

    @Test(timeout=5000L)
    public void testBlockLocationSetters() throws Exception {
        BlockLocation loc = new BlockLocation();
        loc.setHosts(null);
        loc.setCachedHosts(null);
        loc.setNames(null);
        loc.setTopologyPaths(null);
        TestBlockLocation.checkBlockLocation(loc);
        String[] names = new String[]{"name"};
        String[] hosts = new String[]{"host"};
        String[] cachedHosts = new String[]{"cachedHost"};
        String[] topologyPaths = new String[]{"path"};
        loc.setNames(names);
        loc.setHosts(hosts);
        loc.setCachedHosts(cachedHosts);
        loc.setTopologyPaths(topologyPaths);
        loc.setOffset(1L);
        loc.setLength(2L);
        loc.setCorrupt(true);
        TestBlockLocation.checkBlockLocation(loc, names, hosts, cachedHosts, topologyPaths, 1L, 2L, true);
    }
}

