/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestSequenceFileSync {
    private static final int NUMRECORDS = 2000;
    private static final int RECORDSIZE = 80;
    private static final Random rand = new Random();
    private static final String REC_FMT = "%d RECORDID %d : ";

    private static void forOffset(SequenceFile.Reader reader, IntWritable key, Text val, int iter, long off, int expectedRecord) throws IOException {
        val.clear();
        reader.sync(off);
        reader.next((Writable)key, (Writable)val);
        Assert.assertEquals((long)key.get(), (long)expectedRecord);
        String test = String.format(REC_FMT, expectedRecord, expectedRecord);
        Assert.assertEquals((String)("Invalid value " + val), (long)0L, (long)val.find(test, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLowSyncpoint() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path path = new Path(System.getProperty("test.build.data", "/tmp"), "sequencefile.sync.test");
        IntWritable input = new IntWritable();
        Text val = new Text();
        SequenceFile.Writer writer = new SequenceFile.Writer((FileSystem)fs, conf, path, IntWritable.class, Text.class);
        try {
            TestSequenceFileSync.writeSequenceFile(writer, 2000);
            for (int i = 0; i < 5; ++i) {
                SequenceFile.Reader reader;
                if (i % 2 == 0) {
                    reader = new SequenceFile.Reader((FileSystem)fs, path, conf);
                } else {
                    FSDataInputStream in = fs.open(path);
                    long length = fs.getFileStatus(path).getLen();
                    int buffersize = conf.getInt("io.file.buffer.size", 4096);
                    reader = new SequenceFile.Reader(in, buffersize, 0L, length, conf);
                }
                try {
                    TestSequenceFileSync.forOffset(reader, input, val, i, 0L, 0);
                    TestSequenceFileSync.forOffset(reader, input, val, i, 65L, 0);
                    TestSequenceFileSync.forOffset(reader, input, val, i, 2000L, 21);
                    TestSequenceFileSync.forOffset(reader, input, val, i, 0L, 0);
                    continue;
                }
                finally {
                    reader.close();
                }
            }
        }
        finally {
            fs.delete(path, false);
        }
    }

    public static void writeSequenceFile(SequenceFile.Writer writer, int numRecords) throws IOException {
        IntWritable key = new IntWritable();
        Text val = new Text();
        for (int numWritten = 0; numWritten < numRecords; ++numWritten) {
            key.set(numWritten);
            TestSequenceFileSync.randomText(val, numWritten, 80);
            writer.append((Writable)key, (Writable)val);
        }
        writer.close();
    }

    static void randomText(Text val, int id, int recordSize) {
        val.clear();
        StringBuilder ret = new StringBuilder(recordSize);
        ret.append(String.format(REC_FMT, id, id));
        recordSize -= ret.length();
        for (int i = 0; i < recordSize; ++i) {
            ret.append(rand.nextInt(9));
        }
        val.set(ret.toString());
    }
}

