/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import junit.framework.Assert;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenInfo;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSelector;
import org.apache.hadoop.security.token.delegation.TestDelegationToken;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;

public class MiniRPCBenchmark {
    private static final String KEYTAB_FILE_KEY = "test.keytab.file";
    private static final String USER_NAME_KEY = "test.user.name";
    private static final String MINI_USER = "miniUser";
    private static final String RENEWER = "renewer";
    private static final String GROUP_NAME_1 = "MiniGroup1";
    private static final String GROUP_NAME_2 = "MiniGroup2";
    private static final String[] GROUP_NAMES = new String[]{"MiniGroup1", "MiniGroup2"};
    private UserGroupInformation currentUgi = null;
    private Level logLevel;

    MiniRPCBenchmark(Level l) {
        this.logLevel = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long connectToServer(Configuration conf, InetSocketAddress addr) throws IOException {
        long l;
        MiniProtocol client = null;
        try {
            long start = Time.now();
            client = (MiniProtocol)RPC.getProxy(MiniProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
            long end = Time.now();
            l = end - start;
        }
        catch (Throwable throwable) {
            RPC.stopProxy(client);
            throw throwable;
        }
        RPC.stopProxy((Object)client);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectToServerAndGetDelegationToken(final Configuration conf, final InetSocketAddress addr) throws IOException {
        MiniProtocol client = null;
        try {
            UserGroupInformation current = UserGroupInformation.getCurrentUser();
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)MINI_USER, (UserGroupInformation)current, (String[])GROUP_NAMES);
            try {
                client = (MiniProtocol)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<MiniProtocol>(){

                    @Override
                    public MiniProtocol run() throws IOException {
                        MiniProtocol p = (MiniProtocol)RPC.getProxy(MiniProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
                        Token<TestDelegationToken.TestDelegationTokenIdentifier> token = p.getDelegationToken(new Text(MiniRPCBenchmark.RENEWER));
                        MiniRPCBenchmark.this.currentUgi = UserGroupInformation.createUserForTesting((String)MiniRPCBenchmark.MINI_USER, (String[])GROUP_NAMES);
                        SecurityUtil.setTokenService(token, (InetSocketAddress)addr);
                        MiniRPCBenchmark.this.currentUgi.addToken(token);
                        return p;
                    }
                });
            }
            catch (InterruptedException e) {
                Assert.fail((String)Arrays.toString(e.getStackTrace()));
            }
        }
        finally {
            RPC.stopProxy(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long connectToServerUsingDelegationToken(final Configuration conf, final InetSocketAddress addr) throws IOException {
        long l;
        MiniProtocol client = null;
        try {
            long start = Time.now();
            try {
                client = (MiniProtocol)this.currentUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<MiniProtocol>(){

                    @Override
                    public MiniProtocol run() throws IOException {
                        return (MiniProtocol)RPC.getProxy(MiniProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            long end = Time.now();
            l = end - start;
        }
        catch (Throwable throwable) {
            RPC.stopProxy(client);
            throw throwable;
        }
        RPC.stopProxy((Object)client);
        return l;
    }

    static void setLoggingLevel(Level level) {
        LogManager.getLogger((String)Server.class.getName()).setLevel(level);
        ((Log4JLogger)Server.AUDITLOG).getLogger().setLevel(level);
        LogManager.getLogger((String)Client.class.getName()).setLevel(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long runMiniBenchmark(Configuration conf, int count, String keytabKey, String userNameKey) throws IOException {
        String user = System.getProperty("user.name");
        if (userNameKey != null) {
            user = conf.get(userNameKey, user);
        }
        String keytabFile = null;
        if (keytabKey != null) {
            keytabFile = conf.get(keytabKey, keytabFile);
        }
        MiniServer miniServer = null;
        try {
            miniServer = new MiniServer(conf, user, keytabFile);
            InetSocketAddress addr = miniServer.getAddress();
            this.connectToServer(conf, addr);
            MiniRPCBenchmark.setLoggingLevel(this.logLevel);
            long elapsed = 0L;
            for (int idx = 0; idx < count; ++idx) {
                elapsed += this.connectToServer(conf, addr);
            }
            long l = elapsed;
            return l;
        }
        finally {
            if (miniServer != null) {
                miniServer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long runMiniBenchmarkWithDelegationToken(Configuration conf, int count, String keytabKey, String userNameKey) throws IOException {
        String user = System.getProperty("user.name");
        if (userNameKey != null) {
            user = conf.get(userNameKey, user);
        }
        String keytabFile = null;
        if (keytabKey != null) {
            keytabFile = conf.get(keytabKey, keytabFile);
        }
        MiniServer miniServer = null;
        UserGroupInformation.setConfiguration((Configuration)conf);
        String shortUserName = UserGroupInformation.createRemoteUser((String)user).getShortUserName();
        try {
            conf.setStrings(ProxyUsers.getProxySuperuserGroupConfKey((String)shortUserName), new String[]{GROUP_NAME_1});
            this.configureSuperUserIPAddresses(conf, shortUserName);
            miniServer = new MiniServer(conf, user, keytabFile);
            InetSocketAddress addr = miniServer.getAddress();
            this.connectToServerAndGetDelegationToken(conf, addr);
            MiniRPCBenchmark.setLoggingLevel(this.logLevel);
            long elapsed = 0L;
            for (int idx = 0; idx < count; ++idx) {
                elapsed += this.connectToServerUsingDelegationToken(conf, addr);
            }
            long l = elapsed;
            return l;
        }
        finally {
            if (miniServer != null) {
                miniServer.stop();
            }
        }
    }

    static void printUsage() {
        System.err.println("Usage: MiniRPCBenchmark <numIterations> [<keytabFile> [<userName> [useToken|useKerberos [<logLevel>]]]]");
        System.exit(-1);
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Benchmark: RPC session establishment.");
        if (args.length < 1) {
            MiniRPCBenchmark.printUsage();
        }
        Configuration conf = new Configuration();
        int count = Integer.parseInt(args[0]);
        if (args.length > 1) {
            conf.set(KEYTAB_FILE_KEY, args[1]);
        }
        if (args.length > 2) {
            conf.set(USER_NAME_KEY, args[2]);
        }
        boolean useDelegationToken = false;
        if (args.length > 3) {
            useDelegationToken = args[3].equalsIgnoreCase("useToken");
        }
        Level l = Level.ERROR;
        if (args.length > 4) {
            l = Level.toLevel((String)args[4]);
        }
        MiniRPCBenchmark mb = new MiniRPCBenchmark(l);
        long elapsedTime = 0L;
        if (useDelegationToken) {
            System.out.println("Running MiniRPCBenchmark with delegation token authentication.");
            elapsedTime = mb.runMiniBenchmarkWithDelegationToken(conf, count, KEYTAB_FILE_KEY, USER_NAME_KEY);
        } else {
            String auth = SecurityUtil.getAuthenticationMethod((Configuration)conf).toString();
            System.out.println("Running MiniRPCBenchmark with " + auth + " authentication.");
            elapsedTime = mb.runMiniBenchmark(conf, count, KEYTAB_FILE_KEY, USER_NAME_KEY);
        }
        System.out.println(VersionInfo.getVersion());
        System.out.println("Number  of  connects: " + count);
        System.out.println("Average connect time: " + (double)elapsedTime / (double)count);
    }

    private void configureSuperUserIPAddresses(Configuration conf, String superUserShortName) throws IOException {
        ArrayList<String> ipList = new ArrayList<String>();
        Enumeration<NetworkInterface> netInterfaceList = NetworkInterface.getNetworkInterfaces();
        while (netInterfaceList.hasMoreElements()) {
            NetworkInterface inf = netInterfaceList.nextElement();
            Enumeration<InetAddress> addrList = inf.getInetAddresses();
            while (addrList.hasMoreElements()) {
                InetAddress addr = addrList.nextElement();
                ipList.add(addr.getHostAddress());
            }
        }
        StringBuilder builder = new StringBuilder();
        for (String ip : ipList) {
            builder.append(ip);
            builder.append(',');
        }
        builder.append("127.0.1.1,");
        builder.append(InetAddress.getLocalHost().getCanonicalHostName());
        conf.setStrings(ProxyUsers.getProxySuperuserIpConfKey((String)superUserShortName), new String[]{builder.toString()});
    }

    static class MiniServer
    implements MiniProtocol {
        private static final String DEFAULT_SERVER_ADDRESS = "0.0.0.0";
        private TestDelegationToken.TestDelegationTokenSecretManager secretManager;
        private Server rpcServer;

        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            if (protocol.equals(MiniProtocol.class.getName())) {
                return 1L;
            }
            throw new IOException("Unknown protocol: " + protocol);
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHashCode) throws IOException {
            if (protocol.equals(MiniProtocol.class.getName())) {
                return new ProtocolSignature(1L, null);
            }
            throw new IOException("Unknown protocol: " + protocol);
        }

        @Override
        public Token<TestDelegationToken.TestDelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
            String owner = UserGroupInformation.getCurrentUser().getUserName();
            String realUser = UserGroupInformation.getCurrentUser().getRealUser() == null ? "" : UserGroupInformation.getCurrentUser().getRealUser().getUserName();
            TestDelegationToken.TestDelegationTokenIdentifier tokenId = new TestDelegationToken.TestDelegationTokenIdentifier(new Text(owner), renewer, new Text(realUser));
            return new Token((TokenIdentifier)tokenId, (SecretManager)this.secretManager);
        }

        MiniServer(Configuration conf, String user, String keytabFile) throws IOException {
            UserGroupInformation.setConfiguration((Configuration)conf);
            UserGroupInformation.loginUserFromKeytab((String)user, (String)keytabFile);
            this.secretManager = new TestDelegationToken.TestDelegationTokenSecretManager(86400000L, 604800000L, 86400000L, 3600000L);
            this.secretManager.startThreads();
            this.rpcServer = new RPC.Builder(conf).setProtocol(MiniProtocol.class).setInstance((Object)this).setBindAddress(DEFAULT_SERVER_ADDRESS).setPort(0).setNumHandlers(1).setVerbose(false).setSecretManager((SecretManager)this.secretManager).build();
            this.rpcServer.start();
        }

        void stop() {
            if (this.rpcServer != null) {
                this.rpcServer.stop();
            }
            this.rpcServer = null;
        }

        InetSocketAddress getAddress() {
            if (this.rpcServer == null) {
                return null;
            }
            return NetUtils.getConnectAddress((Server)this.rpcServer);
        }
    }

    @KerberosInfo(serverPrincipal="test.user.name")
    @TokenInfo(value=TestDelegationTokenSelector.class)
    public static interface MiniProtocol
    extends VersionedProtocol {
        public static final long versionID = 1L;

        public Token<TestDelegationToken.TestDelegationTokenIdentifier> getDelegationToken(Text var1) throws IOException;
    }

    public static class TestDelegationTokenSelector
    extends AbstractDelegationTokenSelector<TestDelegationToken.TestDelegationTokenIdentifier> {
        protected TestDelegationTokenSelector() {
            super(new Text("MY KIND"));
        }
    }
}

