/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.impl.TestMetricsConfig;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.sink.FileSink;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestFileSink {
    private File outFile;

    private File getTestTempFile(String prefix, String suffix) throws IOException {
        String tmpPath = System.getProperty("java.io.tmpdir", "/tmp");
        String user = System.getProperty("user.name", "unknown-user");
        File dir = new File(tmpPath + "/" + user);
        dir.mkdirs();
        return File.createTempFile(prefix, suffix, dir);
    }

    @Test(timeout=6000L)
    public void testFileSink() throws IOException {
        this.outFile = this.getTestTempFile("test-file-sink-", ".out");
        String outPath = this.outFile.getAbsolutePath();
        new ConfigBuilder().add("*.period", 10000).add("test.sink.mysink0.class", FileSink.class.getName()).add("test.sink.mysink0.filename", outPath).add("test.sink.mysink0.context", "test1").save(TestMetricsConfig.getTestFilename("hadoop-metrics2-test"));
        MetricsSystemImpl ms = new MetricsSystemImpl("test");
        ms.start();
        MyMetrics1 mm1 = new MyMetrics1().registerWith((MetricsSystem)ms);
        new MyMetrics2().registerWith((MetricsSystem)ms);
        mm1.testMetric1.incr();
        mm1.testMetric2.incr(2);
        ms.publishMetricsNow();
        ms.stop();
        ms.shutdown();
        FileInputStream is = new FileInputStream(this.outFile);
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)this.outFile.length());
        IOUtils.copyBytes((InputStream)is, (OutputStream)baos, (int)1024, (boolean)true);
        String outFileContent = new String(baos.toByteArray(), "UTF-8");
        Pattern expectedContentPattern = Pattern.compile("^\\d+\\s+test1.testRecord1:\\s+Context=test1,\\s+(testTag1=testTagValue1,\\s+testTag2=testTagValue2|testTag2=testTagValue2,\\s+testTag1=testTagValue1),\\s+Hostname=.*,\\s+(testMetric1=1,\\s+testMetric2=2|testMetric2=2,\\s+testMetric1=1)$[\\n\\r]*^\\d+\\s+test1.testRecord2:\\s+Context=test1,\\s+testTag22=testTagValue22,\\s+Hostname=.*$[\\n\\r]*", 8);
        Assert.assertTrue((boolean)expectedContentPattern.matcher(outFileContent).matches());
    }

    @After
    public void after() {
        if (this.outFile != null) {
            this.outFile.delete();
            Assert.assertTrue((!this.outFile.exists() ? 1 : 0) != 0);
        }
    }

    @Metrics(name="testRecord2", context="test1")
    static class MyMetrics2 {
        MyMetrics2() {
        }

        @Metric(value={"testTag22", ""}, type=Metric.Type.TAG)
        String testTag1() {
            return "testTagValue22";
        }

        public MyMetrics2 registerWith(MetricsSystem ms) {
            return (MyMetrics2)ms.register("m2", null, (Object)this);
        }
    }

    @Metrics(name="testRecord1", context="test1")
    static class MyMetrics1 {
        @Metric(value={"testMetric1", "An integer gauge"}, always=true)
        MutableGaugeInt testMetric1;
        @Metric(value={"testMetric2", "An integer gauge"}, always=true)
        MutableGaugeInt testMetric2;

        MyMetrics1() {
        }

        @Metric(value={"testTag1", ""}, type=Metric.Type.TAG)
        String testTag1() {
            return "testTagValue1";
        }

        @Metric(value={"testTag2", ""}, type=Metric.Type.TAG)
        String gettestTag2() {
            return "testTagValue2";
        }

        public MyMetrics1 registerWith(MetricsSystem ms) {
            return (MyMetrics1)ms.register("m1", null, (Object)this);
        }
    }
}

