/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.protobuf.generated.HFileProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class FixedFileTrailer {
    private static final Log LOG = LogFactory.getLog(FixedFileTrailer.class);
    private static final int PBUF_TRAILER_MINOR_VERSION = 2;
    private static final int MAX_COMPARATOR_NAME_LENGTH = 128;
    private long fileInfoOffset;
    private long loadOnOpenDataOffset;
    private int dataIndexCount;
    private long uncompressedDataIndexSize;
    private int metaIndexCount;
    private long totalUncompressedBytes;
    private long entryCount;
    private Compression.Algorithm compressionCodec = Compression.Algorithm.NONE;
    private int numDataIndexLevels;
    private long firstDataBlockOffset;
    private long lastDataBlockOffset;
    private String comparatorClassName = KeyValue.COMPARATOR.getLegacyKeyComparatorName();
    private final int majorVersion;
    private final int minorVersion;
    private static final int[] TRAILER_SIZE = FixedFileTrailer.computeTrailerSizeByVersion();
    private static final int MAX_TRAILER_SIZE = FixedFileTrailer.getMaxTrailerSize();
    private static final int NOT_PB_SIZE = 12;

    FixedFileTrailer(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        HFile.checkFormatVersion(majorVersion);
    }

    private static int[] computeTrailerSizeByVersion() {
        int[] versionToSize = new int[3];
        for (int version = 2; version <= 2; ++version) {
            FixedFileTrailer fft = new FixedFileTrailer(version, 0);
            DataOutputStream dos = new DataOutputStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
            try {
                fft.serialize(dos);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            versionToSize[version] = dos.size();
        }
        return versionToSize;
    }

    private static int getMaxTrailerSize() {
        int maxSize = 0;
        for (int version = 2; version <= 2; ++version) {
            maxSize = Math.max(FixedFileTrailer.getTrailerSize(version), maxSize);
        }
        return maxSize;
    }

    static int getTrailerSize(int version) {
        return TRAILER_SIZE[version];
    }

    public int getTrailerSize() {
        return FixedFileTrailer.getTrailerSize(this.majorVersion);
    }

    void serialize(DataOutputStream outputStream) throws IOException {
        HFile.checkFormatVersion(this.majorVersion);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream baosDos = new DataOutputStream(baos);
        BlockType.TRAILER.write((DataOutput)baosDos);
        if (this.majorVersion > 2 || this.majorVersion == 2 && this.minorVersion >= 2) {
            this.serializeAsPB(baosDos);
        } else {
            this.serializeAsWritable(baosDos);
        }
        baosDos.writeInt(FixedFileTrailer.materializeVersion(this.majorVersion, this.minorVersion));
        baos.writeTo(outputStream);
    }

    void serializeAsPB(DataOutputStream output) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HFileProtos.FileTrailerProto.newBuilder().setFileInfoOffset(this.fileInfoOffset).setLoadOnOpenDataOffset(this.loadOnOpenDataOffset).setUncompressedDataIndexSize(this.uncompressedDataIndexSize).setTotalUncompressedBytes(this.totalUncompressedBytes).setDataIndexCount(this.dataIndexCount).setMetaIndexCount(this.metaIndexCount).setEntryCount(this.entryCount).setNumDataIndexLevels(this.numDataIndexLevels).setFirstDataBlockOffset(this.firstDataBlockOffset).setLastDataBlockOffset(this.lastDataBlockOffset).setComparatorClassName(this.comparatorClassName).setCompressionCodec(this.compressionCodec.ordinal()).build().writeDelimitedTo((OutputStream)baos);
        baos.writeTo(output);
        int padding = this.getTrailerSize() - 12 - baos.size();
        if (padding < 0) {
            throw new IOException("Pbuf encoding size exceeded fixed trailer size limit");
        }
        for (int i = 0; i < padding; ++i) {
            output.write(0);
        }
    }

    void serializeAsWritable(DataOutputStream output) throws IOException {
        output.writeLong(this.fileInfoOffset);
        output.writeLong(this.loadOnOpenDataOffset);
        output.writeInt(this.dataIndexCount);
        output.writeLong(this.uncompressedDataIndexSize);
        output.writeInt(this.metaIndexCount);
        output.writeLong(this.totalUncompressedBytes);
        output.writeLong(this.entryCount);
        output.writeInt(this.compressionCodec.ordinal());
        output.writeInt(this.numDataIndexLevels);
        output.writeLong(this.firstDataBlockOffset);
        output.writeLong(this.lastDataBlockOffset);
        Bytes.writeStringFixedSize((DataOutput)output, (String)this.comparatorClassName, (int)128);
    }

    void deserialize(DataInputStream inputStream) throws IOException {
        HFile.checkFormatVersion(this.majorVersion);
        BlockType.TRAILER.readAndCheck(inputStream);
        if (this.majorVersion > 2 || this.majorVersion == 2 && this.minorVersion >= 2) {
            this.deserializeFromPB(inputStream);
        } else {
            this.deserializeFromWritable(inputStream);
        }
        int version = inputStream.readInt();
        this.expectMajorVersion(FixedFileTrailer.extractMajorVersion(version));
        this.expectMinorVersion(FixedFileTrailer.extractMinorVersion(version));
    }

    void deserializeFromPB(DataInputStream inputStream) throws IOException {
        int start = inputStream.available();
        HFileProtos.FileTrailerProto.Builder builder = HFileProtos.FileTrailerProto.newBuilder();
        builder.mergeDelimitedFrom((InputStream)inputStream);
        int size = start - inputStream.available();
        inputStream.skip(this.getTrailerSize() - 12 - size);
        if (builder.hasFileInfoOffset()) {
            this.fileInfoOffset = builder.getFileInfoOffset();
        }
        if (builder.hasLoadOnOpenDataOffset()) {
            this.loadOnOpenDataOffset = builder.getLoadOnOpenDataOffset();
        }
        if (builder.hasUncompressedDataIndexSize()) {
            this.uncompressedDataIndexSize = builder.getUncompressedDataIndexSize();
        }
        if (builder.hasTotalUncompressedBytes()) {
            this.totalUncompressedBytes = builder.getTotalUncompressedBytes();
        }
        if (builder.hasDataIndexCount()) {
            this.dataIndexCount = builder.getDataIndexCount();
        }
        if (builder.hasMetaIndexCount()) {
            this.metaIndexCount = builder.getMetaIndexCount();
        }
        if (builder.hasEntryCount()) {
            this.entryCount = builder.getEntryCount();
        }
        if (builder.hasNumDataIndexLevels()) {
            this.numDataIndexLevels = builder.getNumDataIndexLevels();
        }
        if (builder.hasFirstDataBlockOffset()) {
            this.firstDataBlockOffset = builder.getFirstDataBlockOffset();
        }
        if (builder.hasLastDataBlockOffset()) {
            this.lastDataBlockOffset = builder.getLastDataBlockOffset();
        }
        if (builder.hasComparatorClassName()) {
            this.setComparatorClass(FixedFileTrailer.getComparatorClass(builder.getComparatorClassName()));
        }
        this.compressionCodec = builder.hasCompressionCodec() ? Compression.Algorithm.values()[builder.getCompressionCodec()] : Compression.Algorithm.NONE;
    }

    void deserializeFromWritable(DataInput input) throws IOException {
        this.fileInfoOffset = input.readLong();
        this.loadOnOpenDataOffset = input.readLong();
        this.dataIndexCount = input.readInt();
        this.uncompressedDataIndexSize = input.readLong();
        this.metaIndexCount = input.readInt();
        this.totalUncompressedBytes = input.readLong();
        this.entryCount = input.readLong();
        this.compressionCodec = Compression.Algorithm.values()[input.readInt()];
        this.numDataIndexLevels = input.readInt();
        this.firstDataBlockOffset = input.readLong();
        this.lastDataBlockOffset = input.readLong();
        this.setComparatorClass(FixedFileTrailer.getComparatorClass(Bytes.readStringFixedSize((DataInput)input, (int)128)));
    }

    private void append(StringBuilder sb, String s) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(s);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.append(sb, "fileinfoOffset=" + this.fileInfoOffset);
        this.append(sb, "loadOnOpenDataOffset=" + this.loadOnOpenDataOffset);
        this.append(sb, "dataIndexCount=" + this.dataIndexCount);
        this.append(sb, "metaIndexCount=" + this.metaIndexCount);
        this.append(sb, "totalUncomressedBytes=" + this.totalUncompressedBytes);
        this.append(sb, "entryCount=" + this.entryCount);
        this.append(sb, "compressionCodec=" + this.compressionCodec);
        this.append(sb, "uncompressedDataIndexSize=" + this.uncompressedDataIndexSize);
        this.append(sb, "numDataIndexLevels=" + this.numDataIndexLevels);
        this.append(sb, "firstDataBlockOffset=" + this.firstDataBlockOffset);
        this.append(sb, "lastDataBlockOffset=" + this.lastDataBlockOffset);
        this.append(sb, "comparatorClassName=" + this.comparatorClassName);
        this.append(sb, "majorVersion=" + this.majorVersion);
        this.append(sb, "minorVersion=" + this.minorVersion);
        return sb.toString();
    }

    public static FixedFileTrailer readFromStream(FSDataInputStream istream, long fileSize) throws IOException {
        int bufferSize = MAX_TRAILER_SIZE;
        long seekPoint = fileSize - (long)bufferSize;
        if (seekPoint < 0L) {
            seekPoint = 0L;
            bufferSize = (int)fileSize;
        }
        istream.seek(seekPoint);
        ByteBuffer buf = ByteBuffer.allocate(bufferSize);
        istream.readFully(buf.array(), buf.arrayOffset(), buf.arrayOffset() + buf.limit());
        buf.position(buf.limit() - 4);
        int version = buf.getInt();
        int majorVersion = FixedFileTrailer.extractMajorVersion(version);
        int minorVersion = FixedFileTrailer.extractMinorVersion(version);
        HFile.checkFormatVersion(majorVersion);
        int trailerSize = FixedFileTrailer.getTrailerSize(majorVersion);
        FixedFileTrailer fft = new FixedFileTrailer(majorVersion, minorVersion);
        fft.deserialize(new DataInputStream(new ByteArrayInputStream(buf.array(), buf.arrayOffset() + bufferSize - trailerSize, trailerSize)));
        return fft;
    }

    public void expectMajorVersion(int expected) {
        if (this.majorVersion != expected) {
            throw new IllegalArgumentException("Invalid HFile major version: " + this.majorVersion + " (expected: " + expected + ")");
        }
    }

    public void expectMinorVersion(int expected) {
        if (this.minorVersion != expected) {
            throw new IllegalArgumentException("Invalid HFile minor version: " + this.minorVersion + " (expected: " + expected + ")");
        }
    }

    public void expectAtLeastMajorVersion(int lowerBound) {
        if (this.majorVersion < lowerBound) {
            throw new IllegalArgumentException("Invalid HFile major version: " + this.majorVersion + " (expected: " + lowerBound + " or higher).");
        }
    }

    public long getFileInfoOffset() {
        return this.fileInfoOffset;
    }

    public void setFileInfoOffset(long fileInfoOffset) {
        this.fileInfoOffset = fileInfoOffset;
    }

    public long getLoadOnOpenDataOffset() {
        return this.loadOnOpenDataOffset;
    }

    public void setLoadOnOpenOffset(long loadOnOpenDataOffset) {
        this.loadOnOpenDataOffset = loadOnOpenDataOffset;
    }

    public int getDataIndexCount() {
        return this.dataIndexCount;
    }

    public void setDataIndexCount(int dataIndexCount) {
        this.dataIndexCount = dataIndexCount;
    }

    public int getMetaIndexCount() {
        return this.metaIndexCount;
    }

    public void setMetaIndexCount(int metaIndexCount) {
        this.metaIndexCount = metaIndexCount;
    }

    public long getTotalUncompressedBytes() {
        return this.totalUncompressedBytes;
    }

    public void setTotalUncompressedBytes(long totalUncompressedBytes) {
        this.totalUncompressedBytes = totalUncompressedBytes;
    }

    public long getEntryCount() {
        return this.entryCount;
    }

    public void setEntryCount(long newEntryCount) {
        this.entryCount = newEntryCount;
    }

    public Compression.Algorithm getCompressionCodec() {
        return this.compressionCodec;
    }

    public void setCompressionCodec(Compression.Algorithm compressionCodec) {
        this.compressionCodec = compressionCodec;
    }

    public int getNumDataIndexLevels() {
        this.expectAtLeastMajorVersion(2);
        return this.numDataIndexLevels;
    }

    public void setNumDataIndexLevels(int numDataIndexLevels) {
        this.expectAtLeastMajorVersion(2);
        this.numDataIndexLevels = numDataIndexLevels;
    }

    public long getLastDataBlockOffset() {
        this.expectAtLeastMajorVersion(2);
        return this.lastDataBlockOffset;
    }

    public void setLastDataBlockOffset(long lastDataBlockOffset) {
        this.expectAtLeastMajorVersion(2);
        this.lastDataBlockOffset = lastDataBlockOffset;
    }

    public long getFirstDataBlockOffset() {
        this.expectAtLeastMajorVersion(2);
        return this.firstDataBlockOffset;
    }

    public void setFirstDataBlockOffset(long firstDataBlockOffset) {
        this.expectAtLeastMajorVersion(2);
        this.firstDataBlockOffset = firstDataBlockOffset;
    }

    public String getComparatorClassName() {
        return this.comparatorClassName;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setComparatorClass(Class<? extends KeyValue.KVComparator> klass) {
        try {
            KeyValue.KVComparator comp = klass.newInstance();
            this.comparatorClassName = KeyValue.COMPARATOR.getClass().equals(klass) ? KeyValue.COMPARATOR.getLegacyKeyComparatorName() : (KeyValue.META_COMPARATOR.getClass().equals(klass) ? KeyValue.META_COMPARATOR.getLegacyKeyComparatorName() : (KeyValue.RAW_COMPARATOR.getClass().equals(klass) ? KeyValue.RAW_COMPARATOR.getLegacyKeyComparatorName() : klass.getName()));
        }
        catch (Exception e) {
            throw new RuntimeException("Comparator class " + klass.getName() + " is not instantiable", e);
        }
    }

    private static Class<? extends KeyValue.KVComparator> getComparatorClass(String comparatorClassName) throws IOException {
        try {
            if (comparatorClassName.equals(KeyValue.COMPARATOR.getLegacyKeyComparatorName())) {
                comparatorClassName = KeyValue.COMPARATOR.getClass().getName();
            } else if (comparatorClassName.equals(KeyValue.META_COMPARATOR.getLegacyKeyComparatorName())) {
                comparatorClassName = KeyValue.META_COMPARATOR.getClass().getName();
            } else if (comparatorClassName.equals(KeyValue.RAW_COMPARATOR.getLegacyKeyComparatorName())) {
                comparatorClassName = KeyValue.RAW_COMPARATOR.getClass().getName();
            }
            return Class.forName(comparatorClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(ex);
        }
    }

    public static KeyValue.KVComparator createComparator(String comparatorClassName) throws IOException {
        try {
            return FixedFileTrailer.getComparatorClass(comparatorClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new IOException("Comparator class " + comparatorClassName + " is not instantiable", e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Comparator class " + comparatorClassName + " is not instantiable", e);
        }
    }

    KeyValue.KVComparator createComparator() throws IOException {
        this.expectAtLeastMajorVersion(2);
        return FixedFileTrailer.createComparator(this.comparatorClassName);
    }

    public long getUncompressedDataIndexSize() {
        return this.uncompressedDataIndexSize;
    }

    public void setUncompressedDataIndexSize(long uncompressedDataIndexSize) {
        this.expectAtLeastMajorVersion(2);
        this.uncompressedDataIndexSize = uncompressedDataIndexSize;
    }

    private static int extractMajorVersion(int serializedVersion) {
        return serializedVersion & 0xFFFFFF;
    }

    private static int extractMinorVersion(int serializedVersion) {
        return serializedVersion >>> 24;
    }

    private static int materializeVersion(int majorVersion, int minorVersion) {
        return majorVersion & 0xFFFFFF | minorVersion << 24;
    }
}

