/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheColumnFamilySummary;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.Cacheable;

@InterfaceAudience.Private
public class SimpleBlockCache
implements BlockCache {
    private Map<BlockCacheKey, Ref> cache = new HashMap<BlockCacheKey, Ref>();
    private ReferenceQueue q = new ReferenceQueue();
    public int dumps = 0;

    void processQueue() {
        Ref r;
        while ((r = (Ref)this.q.poll()) != null) {
            this.cache.remove(r.blockId);
            ++this.dumps;
        }
    }

    @Override
    public synchronized long size() {
        this.processQueue();
        return this.cache.size();
    }

    @Override
    public synchronized Cacheable getBlock(BlockCacheKey cacheKey, boolean caching, boolean repeat) {
        this.processQueue();
        Ref ref = this.cache.get(cacheKey);
        if (ref == null) {
            return null;
        }
        return (Cacheable)ref.get();
    }

    @Override
    public synchronized void cacheBlock(BlockCacheKey cacheKey, Cacheable block) {
        this.cache.put(cacheKey, new Ref(cacheKey, block, this.q));
    }

    @Override
    public synchronized void cacheBlock(BlockCacheKey cacheKey, Cacheable block, boolean inMemory) {
        this.cache.put(cacheKey, new Ref(cacheKey, block, this.q));
    }

    @Override
    public boolean evictBlock(BlockCacheKey cacheKey) {
        return this.cache.remove(cacheKey) != null;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public CacheStats getStats() {
        return null;
    }

    @Override
    public long getFreeSize() {
        return 0L;
    }

    @Override
    public long getCurrentSize() {
        return 0L;
    }

    @Override
    public long getEvictedCount() {
        return 0L;
    }

    @Override
    public int evictBlocksByHfileName(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<BlockCacheColumnFamilySummary> getBlockCacheColumnFamilySummaries(Configuration conf) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getBlockCount() {
        return 0L;
    }

    private static class Ref
    extends SoftReference<Cacheable> {
        public BlockCacheKey blockId;

        public Ref(BlockCacheKey blockId, Cacheable block, ReferenceQueue q) {
            super(block, q);
            this.blockId = blockId;
        }
    }
}

