/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.BlockingService;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import com.google.protobuf.TextFormat;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Operation;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.io.ByteBufferOutputStream;
import org.apache.hadoop.hbase.ipc.BadAuthException;
import org.apache.hadoop.hbase.ipc.BufferChain;
import org.apache.hadoop.hbase.ipc.EmptyServiceNameException;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.HBaseRPCErrorHandler;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServer;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapperImpl;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RequestContext;
import org.apache.hadoop.hbase.ipc.RpcCallContext;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.ipc.UnknownServiceException;
import org.apache.hadoop.hbase.ipc.UnsupportedCellCodecException;
import org.apache.hadoop.hbase.ipc.UnsupportedCompressionCodecException;
import org.apache.hadoop.hbase.ipc.WrongVersionException;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.HBasePolicyProvider;
import org.apache.hadoop.hbase.security.HBaseSaslRpcServer;
import org.apache.hadoop.hbase.security.SaslStatus;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSecretManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.StringUtils;
import org.cliffc.high_scale_lib.Counter;
import org.cloudera.htrace.Trace;
import org.cloudera.htrace.TraceInfo;
import org.cloudera.htrace.TraceScope;
import org.codehaus.jackson.map.ObjectMapper;

@InterfaceAudience.Private
public class RpcServer
implements RpcServerInterface {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.RpcServer");
    private final boolean authorize;
    private boolean isSecurityEnabled;
    public static final byte CURRENT_VERSION = 0;
    private static final int DEFAULT_MAX_CALLQUEUE_LENGTH_PER_HANDLER = 10;
    private static final int DEFAULT_MAX_CALLQUEUE_SIZE = 0x40000000;
    static final int BUFFER_INITIAL_SIZE = 1024;
    private static final String WARN_DELAYED_CALLS = "hbase.ipc.warn.delayedrpc.number";
    private static final int DEFAULT_WARN_DELAYED_CALLS = 1000;
    private final int warnDelayedCalls;
    private AtomicInteger delayedCalls;
    private final IPCUtil ipcUtil;
    private static final String AUTH_FAILED_FOR = "Auth failed for ";
    private static final String AUTH_SUCCESSFUL_FOR = "Auth successful for ";
    private static final Log AUDITLOG = LogFactory.getLog((String)("SecurityLogger." + Server.class.getName()));
    protected SecretManager<TokenIdentifier> secretManager;
    protected ServiceAuthorizationManager authManager;
    protected static final ThreadLocal<RpcServerInterface> SERVER = new ThreadLocal();
    private volatile boolean started = false;
    protected static final ThreadLocal<Call> CurCall = new ThreadLocal();
    protected final InetSocketAddress isa;
    protected int port;
    private int handlerCount;
    private int priorityHandlerCount;
    private int readThreads;
    protected int maxIdleTime;
    protected int thresholdIdleConnections;
    int maxConnectionsToNuke;
    protected MetricsHBaseServer metrics;
    protected final Configuration conf;
    private final int maxQueueSize;
    private int maxQueueLength;
    protected int socketSendBufferSize;
    protected final boolean tcpNoDelay;
    protected final boolean tcpKeepAlive;
    protected final long purgeTimeout;
    protected volatile boolean running = true;
    protected BlockingQueue<Call> callQueue;
    protected final Counter callQueueSize = new Counter();
    protected BlockingQueue<Call> priorityCallQueue;
    protected int highPriorityLevel;
    protected final List<Connection> connectionList = Collections.synchronizedList(new LinkedList());
    private Listener listener = null;
    protected Responder responder = null;
    protected int numConnections = 0;
    private Handler[] handlers = null;
    private Handler[] priorityHandlers = null;
    protected BlockingQueue<Call> replicationQueue;
    private int numOfReplicationHandlers = 0;
    private Handler[] replicationHandlers = null;
    protected HBaseRPCErrorHandler errorHandler = null;
    private static final String WARN_RESPONSE_TIME = "hbase.ipc.warn.response.time";
    private static final String WARN_RESPONSE_SIZE = "hbase.ipc.warn.response.size";
    private static final int DEFAULT_WARN_RESPONSE_TIME = 10000;
    private static final int DEFAULT_WARN_RESPONSE_SIZE = 0x6400000;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final int warnResponseTime;
    private final int warnResponseSize;
    private final Object serverInstance;
    private final List<BlockingServiceAndInterface> services;
    private UserProvider userProvider;
    private Function<Pair<RPCProtos.RequestHeader, Message>, Integer> qosFunction = null;
    private static int NIO_BUFFER_LIMIT = 65536;

    @Override
    public void setQosFunction(Function<Pair<RPCProtos.RequestHeader, Message>, Integer> newFunc) {
        this.qosFunction = newFunc;
    }

    protected int getQosLevel(Pair<RPCProtos.RequestHeader, Message> headerAndParam) {
        if (this.qosFunction == null) {
            return 0;
        }
        Integer res = (Integer)this.qosFunction.apply(headerAndParam);
        return res == null ? 0 : res;
    }

    public RpcServer(BlockingService service, InetSocketAddress isa, Configuration conf) throws IOException {
        this(null, "generic", Lists.newArrayList((Object[])new BlockingServiceAndInterface[]{new BlockingServiceAndInterface(service, null)}), isa, 3, 3, conf, 10);
    }

    public RpcServer(Server serverInstance, String name, List<BlockingServiceAndInterface> services, InetSocketAddress isa, int handlerCount, int priorityHandlerCount, Configuration conf, int highPriorityLevel) throws IOException {
        this.serverInstance = serverInstance;
        this.services = services;
        this.isa = isa;
        this.conf = conf;
        this.handlerCount = handlerCount;
        this.priorityHandlerCount = priorityHandlerCount;
        this.socketSendBufferSize = 0;
        this.maxQueueLength = this.conf.getInt("ipc.server.max.callqueue.length", handlerCount * 10);
        this.maxQueueSize = this.conf.getInt("ipc.server.max.callqueue.size", 0x40000000);
        this.readThreads = conf.getInt("ipc.server.read.threadpool.size", 10);
        this.callQueue = new LinkedBlockingQueue<Call>(this.maxQueueLength);
        this.priorityCallQueue = priorityHandlerCount > 0 ? new LinkedBlockingQueue<Call>(this.maxQueueLength) : null;
        this.highPriorityLevel = highPriorityLevel;
        this.maxIdleTime = 2 * conf.getInt("ipc.client.connection.maxidletime", 1000);
        this.maxConnectionsToNuke = conf.getInt("ipc.client.kill.max", 10);
        this.thresholdIdleConnections = conf.getInt("ipc.client.idlethreshold", 4000);
        this.purgeTimeout = conf.getLong("ipc.client.call.purge.timeout", (long)(2 * HConstants.DEFAULT_HBASE_RPC_TIMEOUT));
        this.numOfReplicationHandlers = conf.getInt("hbase.regionserver.replication.handler.count", 3);
        if (this.numOfReplicationHandlers > 0) {
            this.replicationQueue = new LinkedBlockingQueue<Call>(this.maxQueueLength);
        }
        this.warnResponseTime = conf.getInt(WARN_RESPONSE_TIME, 10000);
        this.warnResponseSize = conf.getInt(WARN_RESPONSE_SIZE, 0x6400000);
        this.listener = new Listener(name);
        this.port = this.listener.getAddress().getPort();
        this.metrics = new MetricsHBaseServer(name, new MetricsHBaseServerWrapperImpl(this));
        this.tcpNoDelay = conf.getBoolean("ipc.server.tcpnodelay", true);
        this.tcpKeepAlive = conf.getBoolean("ipc.server.tcpkeepalive", true);
        this.warnDelayedCalls = conf.getInt(WARN_DELAYED_CALLS, 1000);
        this.delayedCalls = new AtomicInteger(0);
        this.ipcUtil = new IPCUtil(conf);
        this.responder = new Responder();
        this.authorize = conf.getBoolean("hadoop.security.authorization", false);
        this.userProvider = UserProvider.instantiate((Configuration)conf);
        this.isSecurityEnabled = this.userProvider.isHBaseSecurityEnabled();
        if (this.isSecurityEnabled) {
            HBaseSaslRpcServer.init(conf);
        }
    }

    protected Connection getConnection(SocketChannel channel, long time) {
        return new Connection(channel, time);
    }

    private void setupResponse(ByteArrayOutputStream response, Call call, Throwable t, String error) throws IOException {
        if (response != null) {
            response.reset();
        }
        call.setResponse(null, null, t, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection(Connection connection) {
        List<Connection> list = this.connectionList;
        synchronized (list) {
            if (this.connectionList.remove(connection)) {
                --this.numConnections;
            }
        }
        connection.close();
    }

    Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setSocketSendBufSize(int size) {
        this.socketSendBufferSize = size;
    }

    @Override
    public void start() {
        this.startThreads();
        this.openServer();
    }

    @Override
    public void openServer() {
        this.started = true;
    }

    @Override
    public synchronized void startThreads() {
        AuthenticationTokenSecretManager mgr = this.createSecretManager();
        if (mgr != null) {
            this.setSecretManager(mgr);
            mgr.start();
        }
        this.authManager = new ServiceAuthorizationManager();
        HBasePolicyProvider.init(this.conf, this.authManager);
        this.responder.start();
        this.listener.start();
        this.handlers = this.startHandlers(this.callQueue, this.handlerCount);
        this.priorityHandlers = this.startHandlers(this.priorityCallQueue, this.priorityHandlerCount);
        this.replicationHandlers = this.startHandlers(this.replicationQueue, this.numOfReplicationHandlers);
    }

    @Override
    public void refreshAuthManager(PolicyProvider pp) {
        this.authManager.refresh(this.conf, pp);
    }

    private Handler[] startHandlers(BlockingQueue<Call> queue, int numOfHandlers) {
        if (numOfHandlers <= 0) {
            return null;
        }
        Handler[] handlers = new Handler[numOfHandlers];
        for (int i = 0; i < numOfHandlers; ++i) {
            handlers[i] = new Handler(queue, i);
            handlers[i].start();
        }
        return handlers;
    }

    private AuthenticationTokenSecretManager createSecretManager() {
        if (!this.isSecurityEnabled) {
            return null;
        }
        if (this.serverInstance == null) {
            return null;
        }
        if (!(this.serverInstance instanceof Server)) {
            return null;
        }
        Server server = (Server)this.serverInstance;
        Configuration conf = server.getConfiguration();
        long keyUpdateInterval = conf.getLong("hbase.auth.key.update.interval", 86400000L);
        long maxAge = conf.getLong("hbase.auth.token.max.lifetime", 604800000L);
        return new AuthenticationTokenSecretManager(conf, server.getZooKeeper(), server.getServerName().toString(), keyUpdateInterval, maxAge);
    }

    public SecretManager<? extends TokenIdentifier> getSecretManager() {
        return this.secretManager;
    }

    public void setSecretManager(SecretManager<? extends TokenIdentifier> secretManager) {
        this.secretManager = secretManager;
    }

    @Override
    public Pair<Message, CellScanner> call(BlockingService service, Descriptors.MethodDescriptor md, Message param, CellScanner cellScanner, long receiveTime, MonitoredRPCHandler status) throws IOException {
        try {
            boolean tooLarge;
            status.setRPC(md.getName(), new Object[]{param}, receiveTime);
            status.setRPCPacket(param);
            status.resume("Servicing call");
            long startTime = System.currentTimeMillis();
            PayloadCarryingRpcController controller = new PayloadCarryingRpcController(cellScanner);
            Message result = service.callBlockingMethod(md, (RpcController)controller, param);
            int processingTime = (int)(System.currentTimeMillis() - startTime);
            int qTime = (int)(startTime - receiveTime);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(CurCall.get().toString() + ", response " + TextFormat.shortDebugString((MessageOrBuilder)result) + " queueTime: " + qTime + " processingTime: " + processingTime));
            }
            this.metrics.dequeuedCall(qTime);
            this.metrics.processedCall(processingTime);
            long responseSize = result.getSerializedSize();
            boolean tooSlow = processingTime > this.warnResponseTime && this.warnResponseTime > -1;
            boolean bl = tooLarge = responseSize > (long)this.warnResponseSize && this.warnResponseSize > -1;
            if (tooSlow || tooLarge) {
                StringBuilder buffer = new StringBuilder(256);
                buffer.append(md.getName());
                buffer.append("(");
                buffer.append(param.getClass().getName());
                buffer.append(")");
                this.logResponse(new Object[]{param}, md.getName(), buffer.toString(), tooLarge ? "TooLarge" : "TooSlow", status.getClient(), startTime, processingTime, qTime, responseSize);
            }
            return new Pair((Object)result, (Object)(controller != null ? controller.cellScanner() : null));
        }
        catch (Throwable e) {
            if (e instanceof ServiceException) {
                e = e.getCause();
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            LOG.error((Object)"Unexpected throwable object ", e);
            throw new IOException(e.getMessage(), e);
        }
    }

    void logResponse(Object[] params, String methodName, String call, String tag, String clientAddress, long startTime, int processingTime, int qTime, long responseSize) throws IOException {
        HashMap<String, Object> responseInfo = new HashMap<String, Object>();
        responseInfo.put("starttimems", startTime);
        responseInfo.put("processingtimems", processingTime);
        responseInfo.put("queuetimems", qTime);
        responseInfo.put("responsesize", responseSize);
        responseInfo.put("client", clientAddress);
        responseInfo.put("class", this.serverInstance == null ? "" : this.serverInstance.getClass().getSimpleName());
        responseInfo.put("method", methodName);
        if (params.length == 2 && this.serverInstance instanceof HRegionServer && params[0] instanceof byte[] && params[1] instanceof Operation) {
            TableName tableName = TableName.valueOf((byte[])HRegionInfo.parseRegionName((byte[])((byte[])params[0]))[0]);
            responseInfo.put("table", tableName.getNameAsString());
            responseInfo.putAll(((Operation)params[1]).toMap());
            LOG.warn((Object)("(operation" + tag + "): " + MAPPER.writeValueAsString(responseInfo)));
        } else if (params.length == 1 && this.serverInstance instanceof HRegionServer && params[0] instanceof Operation) {
            responseInfo.putAll(((Operation)params[0]).toMap());
            LOG.warn((Object)("(operation" + tag + "): " + MAPPER.writeValueAsString(responseInfo)));
        } else {
            responseInfo.put("call", call);
            LOG.warn((Object)("(response" + tag + "): " + MAPPER.writeValueAsString(responseInfo)));
        }
    }

    @Override
    public synchronized void stop() {
        LOG.info((Object)("Stopping server on " + this.port));
        this.running = false;
        this.stopHandlers(this.handlers);
        this.stopHandlers(this.priorityHandlers);
        this.stopHandlers(this.replicationHandlers);
        this.listener.interrupt();
        this.listener.doStop();
        this.responder.interrupt();
        this.notifyAll();
    }

    private void stopHandlers(Handler[] handlers) {
        if (handlers != null) {
            for (Handler handler : handlers) {
                if (handler == null) continue;
                handler.interrupt();
            }
        }
    }

    @Override
    public synchronized void join() throws InterruptedException {
        while (this.running) {
            this.wait();
        }
    }

    @Override
    public synchronized InetSocketAddress getListenerAddress() {
        return this.listener.getAddress();
    }

    @Override
    public void setErrorHandler(HBaseRPCErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public MetricsHBaseServer getMetrics() {
        return this.metrics;
    }

    public void authorize(UserGroupInformation user, RPCProtos.ConnectionHeader connection, InetAddress addr) throws AuthorizationException {
        if (this.authorize) {
            Class<?> c = RpcServer.getServiceInterface(this.services, connection.getServiceName());
            this.authManager.authorize((UserGroupInformation)(user != null ? user : null), c, this.getConf(), addr);
        }
    }

    protected long channelWrite(GatheringByteChannel channel, BufferChain bufferChain) throws IOException {
        long count = bufferChain.write(channel, NIO_BUFFER_LIMIT);
        if (count > 0L) {
            this.metrics.sentBytes(count);
        }
        return count;
    }

    protected int channelRead(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        int count;
        int n = count = buffer.remaining() <= NIO_BUFFER_LIMIT ? channel.read(buffer) : RpcServer.channelIO(channel, null, buffer);
        if (count > 0) {
            this.metrics.receivedBytes(count);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int channelIO(ReadableByteChannel readCh, WritableByteChannel writeCh, ByteBuffer buf) throws IOException {
        int nBytes;
        int originalLimit = buf.limit();
        int initialRemaining = buf.remaining();
        int ret = 0;
        while (buf.remaining() > 0) {
            try {
                int ioSize = Math.min(buf.remaining(), NIO_BUFFER_LIMIT);
                buf.limit(buf.position() + ioSize);
                ret = readCh == null ? writeCh.write(buf) : readCh.read(buf);
                if (ret >= ioSize) continue;
                break;
            }
            finally {
                buf.limit(originalLimit);
            }
        }
        return (nBytes = initialRemaining - buf.remaining()) > 0 ? nBytes : ret;
    }

    public static RpcCallContext getCurrentCall() {
        return CurCall.get();
    }

    static BlockingServiceAndInterface getServiceAndInterface(List<BlockingServiceAndInterface> services, String serviceName) {
        for (BlockingServiceAndInterface bs : services) {
            if (!bs.getBlockingService().getDescriptorForType().getName().equals(serviceName)) continue;
            return bs;
        }
        return null;
    }

    static Class<?> getServiceInterface(List<BlockingServiceAndInterface> services, String serviceName) {
        BlockingServiceAndInterface bsasi = RpcServer.getServiceAndInterface(services, serviceName);
        return bsasi == null ? null : bsasi.getServiceInterface();
    }

    static BlockingService getService(List<BlockingServiceAndInterface> services, String serviceName) {
        BlockingServiceAndInterface bsasi = RpcServer.getServiceAndInterface(services, serviceName);
        return bsasi == null ? null : bsasi.getBlockingService();
    }

    public static InetAddress getRemoteIp() {
        Call call = CurCall.get();
        if (call != null) {
            return call.connection.socket.getInetAddress();
        }
        return null;
    }

    public static String getRemoteAddress() {
        Call call = CurCall.get();
        if (call != null) {
            return call.connection.getHostAddress();
        }
        return null;
    }

    public static RpcServerInterface get() {
        return SERVER.get();
    }

    public static void bind(ServerSocket socket, InetSocketAddress address, int backlog) throws IOException {
        try {
            socket.bind(address, backlog);
        }
        catch (BindException e) {
            BindException bindException = new BindException("Problem binding to " + address + " : " + e.getMessage());
            bindException.initCause(e);
            throw bindException;
        }
        catch (SocketException e) {
            if ("Unresolved address".equals(e.getMessage())) {
                throw new UnknownHostException("Invalid hostname for server: " + address.getHostName());
            }
            throw e;
        }
    }

    public static class BlockingServiceAndInterface {
        private final BlockingService service;
        private final Class<?> serviceInterface;

        public BlockingServiceAndInterface(BlockingService service, Class<?> serviceInterface) {
            this.service = service;
            this.serviceInterface = serviceInterface;
        }

        public Class<?> getServiceInterface() {
            return this.serviceInterface;
        }

        public BlockingService getBlockingService() {
            return this.service;
        }
    }

    private class Handler
    extends Thread {
        private final BlockingQueue<Call> myCallQueue;
        private MonitoredRPCHandler status;

        public Handler(BlockingQueue<Call> cq, int instanceNumber) {
            this.myCallQueue = cq;
            this.setDaemon(true);
            String threadName = "RpcServer.handler=" + instanceNumber + ",port=" + RpcServer.this.port;
            if (cq == RpcServer.this.priorityCallQueue) {
                threadName = "Priority." + threadName;
            } else if (cq == RpcServer.this.replicationQueue) {
                threadName = "Replication." + threadName;
            }
            this.setName(threadName);
            this.status = TaskMonitor.get().createRPCStatus(threadName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)(this.getName() + ": starting"));
            this.status.setStatus("starting");
            SERVER.set(RpcServer.this);
            while (RpcServer.this.running) {
                try {
                    this.status.pause("Waiting for a call");
                    Call call = this.myCallQueue.take();
                    this.status.setStatus("Setting up call");
                    this.status.setConnection(call.connection.getHostAddress(), call.connection.getRemotePort());
                    if (LOG.isDebugEnabled()) {
                        UserGroupInformation remoteUser = call.connection.user;
                        LOG.debug((Object)(call.toShortString() + " executing as " + (remoteUser == null ? "NULL principal" : remoteUser.getUserName())));
                    }
                    Throwable errorThrowable = null;
                    String error = null;
                    Pair<Message, CellScanner> resultPair = null;
                    CurCall.set(call);
                    TraceScope traceScope = null;
                    try {
                        if (!RpcServer.this.started) {
                            throw new ServerNotRunningYetException("Server is not running yet");
                        }
                        if (call.tinfo != null) {
                            traceScope = Trace.startSpan((String)call.toTraceString(), (TraceInfo)call.tinfo);
                        }
                        RequestContext.set(RpcServer.this.userProvider.create(call.connection.user), RpcServer.getRemoteIp(), call.connection.service);
                        resultPair = RpcServer.this.call(call.service, call.md, call.param, call.cellScanner, call.timestamp, this.status);
                    }
                    catch (Throwable e) {
                        LOG.debug((Object)(this.getName() + ": " + call.toShortString()), e);
                        errorThrowable = e;
                        error = StringUtils.stringifyException((Throwable)e);
                    }
                    finally {
                        if (traceScope != null) {
                            traceScope.close();
                        }
                        RequestContext.clear();
                    }
                    CurCall.set(null);
                    RpcServer.this.callQueueSize.add(call.getSize() * -1L);
                    if (!call.isDelayed() || !call.isReturnValueDelayed()) {
                        Message param = resultPair != null ? (Message)resultPair.getFirst() : null;
                        CellScanner cells = resultPair != null ? (CellScanner)resultPair.getSecond() : null;
                        call.setResponse(param, cells, errorThrowable, error);
                    }
                    call.sendResponseIfReady();
                    this.status.markComplete("Sent response");
                }
                catch (InterruptedException e) {
                    if (!RpcServer.this.running) continue;
                    LOG.info((Object)(this.getName() + ": caught: " + StringUtils.stringifyException((Throwable)e)));
                }
                catch (OutOfMemoryError e) {
                    if (RpcServer.this.errorHandler != null) {
                        if (!RpcServer.this.errorHandler.checkOOME(e)) continue;
                        LOG.info((Object)(this.getName() + ": exiting on OutOfMemoryError"));
                        return;
                    }
                    throw e;
                }
                catch (ClosedChannelException cce) {
                    LOG.warn((Object)(this.getName() + ": caught a ClosedChannelException, " + "this means that the server was processing a " + "request but the client went away. The error message was: " + cce.getMessage()));
                }
                catch (Exception e) {
                    LOG.warn((Object)(this.getName() + ": caught: " + StringUtils.stringifyException((Throwable)e)));
                }
            }
            LOG.info((Object)(this.getName() + ": exiting"));
        }
    }

    @SuppressWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="False positive according to http://sourceforge.net/p/findbugs/bugs/1032/")
    public class Connection {
        private boolean connectionPreambleRead = false;
        private boolean connectionHeaderRead = false;
        protected SocketChannel channel;
        private ByteBuffer data;
        private ByteBuffer dataLengthBuffer;
        protected final LinkedList<Call> responseQueue;
        private volatile int rpcCount = 0;
        private long lastContact;
        private InetAddress addr;
        protected Socket socket;
        protected String hostAddress;
        protected int remotePort;
        RPCProtos.ConnectionHeader connectionHeader;
        private Codec codec;
        private CompressionCodec compressionCodec;
        BlockingService service;
        protected UserGroupInformation user = null;
        private AuthMethod authMethod;
        private boolean saslContextEstablished;
        private boolean skipInitialSaslHandshake;
        private ByteBuffer unwrappedData;
        private ByteBuffer unwrappedDataLengthBuffer = ByteBuffer.allocate(4);
        boolean useSasl;
        SaslServer saslServer;
        private boolean useWrap = false;
        private static final int AUTHROIZATION_FAILED_CALLID = -1;
        private final Call authFailedCall = new Call(-1, this.service, null, null, null, this, null, 0L, null);
        private ByteArrayOutputStream authFailedResponse = new ByteArrayOutputStream();
        private static final int SASL_CALLID = -33;
        private final Call saslCall = new Call(-33, this.service, null, null, null, this, null, 0L, null);
        public UserGroupInformation attemptingUser = null;

        public Connection(SocketChannel channel, long lastContact) {
            this.channel = channel;
            this.lastContact = lastContact;
            this.data = null;
            this.dataLengthBuffer = ByteBuffer.allocate(4);
            this.socket = channel.socket();
            this.addr = this.socket.getInetAddress();
            this.hostAddress = this.addr == null ? "*Unknown*" : this.addr.getHostAddress();
            this.remotePort = this.socket.getPort();
            this.responseQueue = new LinkedList();
            if (RpcServer.this.socketSendBufferSize != 0) {
                try {
                    this.socket.setSendBufferSize(RpcServer.this.socketSendBufferSize);
                }
                catch (IOException e) {
                    LOG.warn((Object)("Connection: unable to set socket send buffer size to " + RpcServer.this.socketSendBufferSize));
                }
            }
        }

        public String toString() {
            return this.getHostAddress() + ":" + this.remotePort;
        }

        public String getHostAddress() {
            return this.hostAddress;
        }

        public InetAddress getHostInetAddress() {
            return this.addr;
        }

        public int getRemotePort() {
            return this.remotePort;
        }

        public void setLastContact(long lastContact) {
            this.lastContact = lastContact;
        }

        public long getLastContact() {
            return this.lastContact;
        }

        private boolean isIdle() {
            return this.rpcCount == 0;
        }

        protected void decRpcCount() {
            --this.rpcCount;
        }

        protected void incRpcCount() {
            ++this.rpcCount;
        }

        protected boolean timedOut(long currentTime) {
            return this.isIdle() && currentTime - this.lastContact > (long)RpcServer.this.maxIdleTime;
        }

        private UserGroupInformation getAuthorizedUgi(String authorizedId) throws IOException {
            if (this.authMethod == AuthMethod.DIGEST) {
                TokenIdentifier tokenId = HBaseSaslRpcServer.getIdentifier(authorizedId, RpcServer.this.secretManager);
                UserGroupInformation ugi = tokenId.getUser();
                if (ugi == null) {
                    throw new AccessControlException("Can't retrieve username from tokenIdentifier.");
                }
                ugi.addTokenIdentifier(tokenId);
                return ugi;
            }
            return UserGroupInformation.createRemoteUser((String)authorizedId);
        }

        private void saslReadAndProcess(byte[] saslToken) throws IOException, InterruptedException {
            if (this.saslContextEstablished) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Have read input token of size " + saslToken.length + " for processing by saslServer.unwrap()"));
                }
                if (!this.useWrap) {
                    this.processOneRpc(saslToken);
                } else {
                    byte[] plaintextData = this.saslServer.unwrap(saslToken, 0, saslToken.length);
                    this.processUnwrappedData(plaintextData);
                }
            } else {
                byte[] replyToken = null;
                try {
                    if (this.saslServer == null) {
                        switch (this.authMethod) {
                            case DIGEST: {
                                if (RpcServer.this.secretManager == null) {
                                    throw new AccessControlException("Server is not configured to do DIGEST authentication.");
                                }
                                this.saslServer = Sasl.createSaslServer(AuthMethod.DIGEST.getMechanismName(), null, "default", SaslUtil.SASL_PROPS, new HBaseSaslRpcServer.SaslDigestCallbackHandler(RpcServer.this.secretManager, this));
                                break;
                            }
                            default: {
                                String[] names;
                                UserGroupInformation current = UserGroupInformation.getCurrentUser();
                                String fullName = current.getUserName();
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Kerberos principal name is " + fullName));
                                }
                                if ((names = SaslUtil.splitKerberosName((String)fullName)).length != 3) {
                                    throw new AccessControlException("Kerberos principal name does NOT have the expected hostname part: " + fullName);
                                }
                                current.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                                    @Override
                                    public Object run() throws SaslException {
                                        Connection.this.saslServer = Sasl.createSaslServer(AuthMethod.KERBEROS.getMechanismName(), names[0], names[1], SaslUtil.SASL_PROPS, new HBaseSaslRpcServer.SaslGssCallbackHandler());
                                        return null;
                                    }
                                });
                            }
                        }
                        if (this.saslServer == null) {
                            throw new AccessControlException("Unable to find SASL server implementation for " + this.authMethod.getMechanismName());
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Created SASL server with mechanism = " + this.authMethod.getMechanismName()));
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Have read input token of size " + saslToken.length + " for processing by saslServer.evaluateResponse()"));
                    }
                    replyToken = this.saslServer.evaluateResponse(saslToken);
                }
                catch (IOException e) {
                    IOException sendToClient = e;
                    for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                        if (!(cause instanceof SecretManager.InvalidToken)) continue;
                        sendToClient = (SecretManager.InvalidToken)cause;
                        break;
                    }
                    this.doRawSaslReply(SaslStatus.ERROR, null, sendToClient.getClass().getName(), sendToClient.getLocalizedMessage());
                    RpcServer.this.metrics.authenticationFailure();
                    String clientIP = this.toString();
                    AUDITLOG.warn((Object)(RpcServer.AUTH_FAILED_FOR + clientIP + ":" + this.attemptingUser));
                    throw e;
                }
                if (replyToken != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Will send token of size " + replyToken.length + " from saslServer."));
                    }
                    this.doRawSaslReply(SaslStatus.SUCCESS, (Writable)new BytesWritable(replyToken), null, null);
                }
                if (this.saslServer.isComplete()) {
                    String qop = (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
                    this.useWrap = qop != null && !"auth".equalsIgnoreCase(qop);
                    this.user = this.getAuthorizedUgi(this.saslServer.getAuthorizationID());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("SASL server context established. Authenticated client: " + this.user + ". Negotiated QoP is " + this.saslServer.getNegotiatedProperty("javax.security.sasl.qop")));
                    }
                    RpcServer.this.metrics.authenticationSuccess();
                    AUDITLOG.info((Object)(RpcServer.AUTH_SUCCESSFUL_FOR + this.user));
                    this.saslContextEstablished = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRawSaslReply(SaslStatus status, Writable rv, String errorClass, String error) throws IOException {
            ByteBufferOutputStream saslResponse = null;
            FilterOutputStream out = null;
            try {
                saslResponse = new ByteBufferOutputStream(256);
                out = new DataOutputStream((OutputStream)saslResponse);
                ((DataOutputStream)out).writeInt(status.state);
                if (status == SaslStatus.SUCCESS) {
                    rv.write((DataOutput)((Object)out));
                } else {
                    WritableUtils.writeString((DataOutput)((Object)out), (String)errorClass);
                    WritableUtils.writeString((DataOutput)((Object)out), (String)error);
                }
                this.saslCall.setSaslTokenResponse(saslResponse.getByteBuffer());
                this.saslCall.responder = RpcServer.this.responder;
                this.saslCall.sendResponseIfReady();
            }
            finally {
                if (saslResponse != null) {
                    saslResponse.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }

        private void disposeSasl() {
            if (this.saslServer != null) {
                try {
                    this.saslServer.dispose();
                    this.saslServer = null;
                }
                catch (SaslException saslException) {
                    // empty catch block
                }
            }
        }

        public int readAndProcess() throws IOException, InterruptedException {
            int count;
            while (true) {
                if (this.dataLengthBuffer.remaining() > 0 && ((count = RpcServer.this.channelRead(this.channel, this.dataLengthBuffer)) < 0 || this.dataLengthBuffer.remaining() > 0)) {
                    return count;
                }
                if (!this.connectionPreambleRead) {
                    this.dataLengthBuffer.flip();
                    if (!HConstants.RPC_HEADER.equals(this.dataLengthBuffer)) {
                        return this.doBadPreambleHandling("Expected HEADER=" + Bytes.toStringBinary((byte[])HConstants.RPC_HEADER.array()) + " but received HEADER=" + Bytes.toStringBinary((byte[])this.dataLengthBuffer.array()) + " from " + this.toString());
                    }
                    ByteBuffer versionAndAuthBytes = ByteBuffer.allocate(2);
                    count = RpcServer.this.channelRead(this.channel, versionAndAuthBytes);
                    if (count < 0 || versionAndAuthBytes.remaining() > 0) {
                        return count;
                    }
                    byte version = versionAndAuthBytes.get(0);
                    byte authbyte = versionAndAuthBytes.get(1);
                    this.authMethod = AuthMethod.valueOf((byte)authbyte);
                    if (version != 0) {
                        String msg = this.getFatalConnectionString(version, authbyte);
                        return this.doBadPreambleHandling(msg, (Exception)new WrongVersionException(msg));
                    }
                    if (this.authMethod == null) {
                        String msg = this.getFatalConnectionString(version, authbyte);
                        return this.doBadPreambleHandling(msg, (Exception)new BadAuthException(msg));
                    }
                    if (RpcServer.this.isSecurityEnabled && this.authMethod == AuthMethod.SIMPLE) {
                        AccessControlException ae = new AccessControlException("Authentication is required");
                        RpcServer.this.setupResponse(this.authFailedResponse, this.authFailedCall, (Throwable)ae, ae.getMessage());
                        RpcServer.this.responder.doRespond(this.authFailedCall);
                        throw ae;
                    }
                    if (!RpcServer.this.isSecurityEnabled && this.authMethod != AuthMethod.SIMPLE) {
                        this.doRawSaslReply(SaslStatus.SUCCESS, (Writable)new IntWritable(-88), null, null);
                        this.authMethod = AuthMethod.SIMPLE;
                        this.skipInitialSaslHandshake = true;
                    }
                    if (this.authMethod != AuthMethod.SIMPLE) {
                        this.useSasl = true;
                    }
                    this.connectionPreambleRead = true;
                    this.dataLengthBuffer.clear();
                    continue;
                }
                if (this.data == null) {
                    this.dataLengthBuffer.flip();
                    int dataLength = this.dataLengthBuffer.getInt();
                    if (dataLength == -1 && !this.useWrap) {
                        this.dataLengthBuffer.clear();
                        return 0;
                    }
                    if (dataLength < 0) {
                        throw new IllegalArgumentException("Unexpected data length " + dataLength + "!! from " + this.getHostAddress());
                    }
                    this.data = ByteBuffer.allocate(dataLength);
                    this.incRpcCount();
                }
                if ((count = RpcServer.this.channelRead(this.channel, this.data)) < 0) {
                    return count;
                }
                if (this.data.remaining() == 0) {
                    this.dataLengthBuffer.clear();
                    this.data.flip();
                    if (this.skipInitialSaslHandshake) {
                        this.data = null;
                        this.skipInitialSaslHandshake = false;
                        continue;
                    }
                    boolean headerRead = this.connectionHeaderRead;
                    if (this.useSasl) {
                        this.saslReadAndProcess(this.data.array());
                    } else {
                        this.processOneRpc(this.data.array());
                    }
                    this.data = null;
                    if (headerRead) break;
                    continue;
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Continue to read rest of data " + this.data.remaining()));
            }
            return count;
        }

        private String getFatalConnectionString(int version, byte authByte) {
            return "serverVersion=0, clientVersion=" + version + ", authMethod=" + authByte + ", authSupported=" + (this.authMethod != null) + " from " + this.toString();
        }

        private int doBadPreambleHandling(String msg) throws IOException {
            return this.doBadPreambleHandling(msg, (Exception)new FatalConnectionException(msg));
        }

        private int doBadPreambleHandling(String msg, Exception e) throws IOException {
            LOG.warn((Object)msg);
            Call fakeCall = new Call(-1, null, null, null, null, this, RpcServer.this.responder, -1L, null);
            RpcServer.this.setupResponse(null, fakeCall, e, msg);
            RpcServer.this.responder.doRespond(fakeCall);
            return -1;
        }

        private void processConnectionHeader(byte[] buf) throws IOException {
            this.connectionHeader = RPCProtos.ConnectionHeader.parseFrom((byte[])buf);
            String serviceName = this.connectionHeader.getServiceName();
            if (serviceName == null) {
                throw new EmptyServiceNameException();
            }
            this.service = RpcServer.getService(RpcServer.this.services, serviceName);
            if (this.service == null) {
                throw new UnknownServiceException(serviceName);
            }
            this.setupCellBlockCodecs(this.connectionHeader);
            UserGroupInformation protocolUser = this.createUser(this.connectionHeader);
            if (!this.useSasl) {
                this.user = protocolUser;
                if (this.user != null) {
                    this.user.setAuthenticationMethod(AuthMethod.SIMPLE.authenticationMethod);
                }
            } else {
                this.user.setAuthenticationMethod(this.authMethod.authenticationMethod);
                if (protocolUser != null && !protocolUser.getUserName().equals(this.user.getUserName())) {
                    if (this.authMethod == AuthMethod.DIGEST) {
                        throw new AccessControlException("Authenticated user (" + this.user + ") doesn't match what the client claims to be (" + protocolUser + ")");
                    }
                    UserGroupInformation realUser = this.user;
                    this.user = UserGroupInformation.createProxyUser((String)protocolUser.getUserName(), (UserGroupInformation)realUser);
                    this.user.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.PROXY);
                }
            }
        }

        private void setupCellBlockCodecs(RPCProtos.ConnectionHeader header) throws FatalConnectionException {
            if (!header.hasCellBlockCodecClass()) {
                return;
            }
            String className = header.getCellBlockCodecClass();
            if (className == null || className.length() == 0) {
                return;
            }
            try {
                this.codec = (Codec)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                throw new UnsupportedCellCodecException(className, (Throwable)e);
            }
            if (!header.hasCellBlockCompressorClass()) {
                return;
            }
            className = header.getCellBlockCompressorClass();
            try {
                this.compressionCodec = (CompressionCodec)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                throw new UnsupportedCompressionCodecException(className, (Throwable)e);
            }
        }

        private void processUnwrappedData(byte[] inBuf) throws IOException, InterruptedException {
            ReadableByteChannel ch = Channels.newChannel(new ByteArrayInputStream(inBuf));
            while (true) {
                int count = -1;
                if (this.unwrappedDataLengthBuffer.remaining() > 0 && ((count = RpcServer.this.channelRead(ch, this.unwrappedDataLengthBuffer)) <= 0 || this.unwrappedDataLengthBuffer.remaining() > 0)) {
                    return;
                }
                if (this.unwrappedData == null) {
                    this.unwrappedDataLengthBuffer.flip();
                    int unwrappedDataLength = this.unwrappedDataLengthBuffer.getInt();
                    if (unwrappedDataLength == -1) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Received ping message");
                        }
                        this.unwrappedDataLengthBuffer.clear();
                        continue;
                    }
                    this.unwrappedData = ByteBuffer.allocate(unwrappedDataLength);
                }
                if ((count = RpcServer.this.channelRead(ch, this.unwrappedData)) <= 0 || this.unwrappedData.remaining() > 0) {
                    return;
                }
                if (this.unwrappedData.remaining() != 0) continue;
                this.unwrappedDataLengthBuffer.clear();
                this.unwrappedData.flip();
                this.processOneRpc(this.unwrappedData.array());
                this.unwrappedData = null;
            }
        }

        private void processOneRpc(byte[] buf) throws IOException, InterruptedException {
            if (this.connectionHeaderRead) {
                this.processRequest(buf);
            } else {
                this.processConnectionHeader(buf);
                this.connectionHeaderRead = true;
                if (!this.authorizeConnection()) {
                    throw new AccessControlException("Connection from " + this + " for service " + this.connectionHeader.getServiceName() + " is unauthorized for user: " + this.user);
                }
            }
        }

        protected void processRequest(byte[] buf) throws IOException, InterruptedException {
            long totalRequestSize = buf.length;
            int offset = 0;
            CodedInputStream cis = CodedInputStream.newInstance((byte[])buf, (int)offset, (int)buf.length);
            int headerSize = cis.readRawVarint32();
            offset = cis.getTotalBytesRead();
            RPCProtos.RequestHeader header = ((RPCProtos.RequestHeader.Builder)RPCProtos.RequestHeader.newBuilder().mergeFrom(buf, offset, headerSize)).build();
            offset += headerSize;
            int id = header.getCallId();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("RequestHeader " + TextFormat.shortDebugString((MessageOrBuilder)header) + " totalRequestSize: " + totalRequestSize + " bytes"));
            }
            if (totalRequestSize + RpcServer.this.callQueueSize.get() > (long)RpcServer.this.maxQueueSize) {
                Call callTooBig = new Call(id, this.service, null, null, null, this, RpcServer.this.responder, totalRequestSize, null);
                ByteArrayOutputStream responseBuffer = new ByteArrayOutputStream();
                RpcServer.this.setupResponse(responseBuffer, callTooBig, new CallQueueTooBigException(), "Call queue is full, is ipc.server.max.callqueue.size too small?");
                RpcServer.this.responder.doRespond(callTooBig);
                return;
            }
            Descriptors.MethodDescriptor md = null;
            Message param = null;
            CellScanner cellScanner = null;
            try {
                if (header.hasRequestParam() && header.getRequestParam()) {
                    md = this.service.getDescriptorForType().findMethodByName(header.getMethodName());
                    Message.Builder builder = this.service.getRequestPrototype(md).newBuilderForType();
                    cis = CodedInputStream.newInstance((byte[])buf, (int)offset, (int)buf.length);
                    int paramSize = cis.readRawVarint32();
                    offset += cis.getTotalBytesRead();
                    if (builder != null) {
                        param = builder.mergeFrom(buf, offset, paramSize).build();
                    }
                    offset += paramSize;
                }
                if (header.hasCellBlockMeta()) {
                    cellScanner = RpcServer.this.ipcUtil.createCellScanner(this.codec, this.compressionCodec, buf, offset, buf.length);
                }
            }
            catch (Throwable t2) {
                DoNotRetryIOException t2;
                String msg = "Unable to read call parameter from client " + this.getHostAddress();
                LOG.warn((Object)msg, t2);
                if (t2 instanceof UnsupportedOperationException) {
                    t2 = new DoNotRetryIOException(t2);
                }
                Call readParamsFailedCall = new Call(id, this.service, null, null, null, this, RpcServer.this.responder, totalRequestSize, null);
                ByteArrayOutputStream responseBuffer = new ByteArrayOutputStream();
                RpcServer.this.setupResponse(responseBuffer, readParamsFailedCall, (Throwable)t2, msg + "; " + t2.getMessage());
                RpcServer.this.responder.doRespond(readParamsFailedCall);
                return;
            }
            Call call = null;
            call = header.hasTraceInfo() ? new Call(id, this.service, md, param, cellScanner, this, RpcServer.this.responder, totalRequestSize, new TraceInfo(header.getTraceInfo().getTraceId(), header.getTraceInfo().getParentId())) : new Call(id, this.service, md, param, cellScanner, this, RpcServer.this.responder, totalRequestSize, null);
            RpcServer.this.callQueueSize.add(totalRequestSize);
            Pair headerAndParam = new Pair((Object)header, param);
            int level = RpcServer.this.getQosLevel((Pair<RPCProtos.RequestHeader, Message>)headerAndParam);
            if (RpcServer.this.priorityCallQueue != null && level > RpcServer.this.highPriorityLevel) {
                RpcServer.this.priorityCallQueue.put(call);
            } else if (RpcServer.this.replicationQueue != null && level == 5) {
                RpcServer.this.replicationQueue.put(call);
            } else {
                RpcServer.this.callQueue.put(call);
            }
        }

        private boolean authorizeConnection() throws IOException {
            try {
                if (this.user != null && this.user.getRealUser() != null && this.authMethod != AuthMethod.DIGEST) {
                    ProxyUsers.authorize((UserGroupInformation)this.user, (String)this.getHostAddress(), (Configuration)RpcServer.this.conf);
                }
                RpcServer.this.authorize(this.user, this.connectionHeader, this.getHostInetAddress());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Authorized " + TextFormat.shortDebugString((MessageOrBuilder)this.connectionHeader)));
                }
                RpcServer.this.metrics.authorizationSuccess();
            }
            catch (AuthorizationException ae) {
                LOG.debug((Object)("Connection authorization failed: " + ae.getMessage()), (Throwable)ae);
                RpcServer.this.metrics.authorizationFailure();
                RpcServer.this.setupResponse(this.authFailedResponse, this.authFailedCall, ae, ae.getMessage());
                RpcServer.this.responder.doRespond(this.authFailedCall);
                return false;
            }
            return true;
        }

        protected synchronized void close() {
            this.disposeSasl();
            this.data = null;
            this.dataLengthBuffer = null;
            if (!this.channel.isOpen()) {
                return;
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (this.channel.isOpen()) {
                try {
                    this.channel.close();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private UserGroupInformation createUser(RPCProtos.ConnectionHeader head) {
            UserGroupInformation ugi = null;
            if (!head.hasUserInfo()) {
                return null;
            }
            RPCProtos.UserInformation userInfoProto = head.getUserInfo();
            String effectiveUser = null;
            if (userInfoProto.hasEffectiveUser()) {
                effectiveUser = userInfoProto.getEffectiveUser();
            }
            String realUser = null;
            if (userInfoProto.hasRealUser()) {
                realUser = userInfoProto.getRealUser();
            }
            if (effectiveUser != null) {
                if (realUser != null) {
                    UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)realUser);
                    ugi = UserGroupInformation.createProxyUser((String)effectiveUser, (UserGroupInformation)realUserUgi);
                } else {
                    ugi = UserGroupInformation.createRemoteUser((String)effectiveUser);
                }
            }
            return ugi;
        }
    }

    public static class CallQueueTooBigException
    extends IOException {
        CallQueueTooBigException() {
        }
    }

    protected class Responder
    extends Thread {
        private final Selector writeSelector;
        private int pending;

        Responder() throws IOException {
            this.setName("RpcServer.responder");
            this.setDaemon(true);
            this.writeSelector = Selector.open();
            this.pending = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)(this.getName() + ": starting"));
            SERVER.set(RpcServer.this);
            try {
                this.doRunLoop();
            }
            finally {
                LOG.info((Object)(this.getName() + ": stopping"));
                try {
                    this.writeSelector.close();
                }
                catch (IOException ioe) {
                    LOG.error((Object)(this.getName() + ": couldn't close write selector"), (Throwable)ioe);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRunLoop() {
            long lastPurgeTime = 0L;
            while (RpcServer.this.running) {
                try {
                    ArrayList<Call> calls;
                    this.waitPending();
                    this.writeSelector.select(RpcServer.this.purgeTimeout);
                    Iterator<SelectionKey> iter = this.writeSelector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        SelectionKey key = iter.next();
                        iter.remove();
                        try {
                            if (!key.isValid() || !key.isWritable()) continue;
                            this.doAsyncWrite(key);
                        }
                        catch (IOException e) {
                            LOG.info((Object)(this.getName() + ": asyncWrite"), (Throwable)e);
                        }
                    }
                    long now = System.currentTimeMillis();
                    if (now < lastPurgeTime + RpcServer.this.purgeTimeout) continue;
                    lastPurgeTime = now;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + ": checking for old call responses."));
                    }
                    Set<SelectionKey> set = this.writeSelector.keys();
                    synchronized (set) {
                        calls = new ArrayList<Call>(this.writeSelector.keys().size());
                        for (SelectionKey key : this.writeSelector.keys()) {
                            Call call = (Call)key.attachment();
                            if (call == null || key.channel() != call.connection.channel) continue;
                            calls.add(call);
                        }
                    }
                    for (Call call : calls) {
                        try {
                            this.doPurge(call, now);
                        }
                        catch (IOException e) {
                            LOG.warn((Object)(this.getName() + ": error in purging old calls " + e));
                        }
                    }
                }
                catch (OutOfMemoryError e) {
                    if (RpcServer.this.errorHandler != null) {
                        if (!RpcServer.this.errorHandler.checkOOME(e)) continue;
                        LOG.info((Object)(this.getName() + ": exiting on OutOfMemoryError"));
                        return;
                    }
                    LOG.warn((Object)(this.getName() + ": OutOfMemoryError in server select"), (Throwable)e);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception ignored) {}
                }
                catch (Exception e) {
                    LOG.warn((Object)(this.getName() + ": exception in Responder " + StringUtils.stringifyException((Throwable)e)));
                }
            }
            LOG.info((Object)(this.getName() + ": stopped"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doAsyncWrite(SelectionKey key) throws IOException {
            Call call = (Call)key.attachment();
            if (call == null) {
                return;
            }
            if (key.channel() != call.connection.channel) {
                throw new IOException("doAsyncWrite: bad channel");
            }
            LinkedList<Call> linkedList = call.connection.responseQueue;
            synchronized (linkedList) {
                if (this.processResponse(call.connection.responseQueue, false)) {
                    try {
                        key.interestOps(0);
                    }
                    catch (CancelledKeyException e) {
                        LOG.warn((Object)("Exception while changing ops : " + e));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doPurge(Call call, long now) throws IOException {
            LinkedList<Call> linkedList = call.connection.responseQueue;
            synchronized (linkedList) {
                ListIterator<Call> iter = call.connection.responseQueue.listIterator(0);
                while (iter.hasNext()) {
                    Call nextCall = (Call)iter.next();
                    if (now <= nextCall.timestamp + RpcServer.this.purgeTimeout) continue;
                    RpcServer.this.closeConnection(nextCall.connection);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private boolean processResponse(LinkedList<Call> responseQueue, boolean inHandler) throws IOException {
            int numElements;
            Call call;
            boolean done;
            boolean error;
            block16: {
                error = true;
                done = false;
                call = null;
                LinkedList<Call> linkedList = responseQueue;
                // MONITORENTER : linkedList
                numElements = responseQueue.size();
                if (numElements != 0) break block16;
                error = false;
                boolean bl = true;
                // MONITOREXIT : linkedList
                if (!error) return bl;
                if (call == null) return bl;
                LOG.warn((Object)(this.getName() + call.toShortString() + ": output error"));
                done = true;
                RpcServer.this.closeConnection(call.connection);
                return bl;
            }
            call = responseQueue.removeFirst();
            SocketChannel channel = call.connection.channel;
            long numBytes = RpcServer.this.channelWrite(channel, call.response);
            if (numBytes < 0L) {
                boolean bl = true;
                // MONITOREXIT : linkedList
                if (!error) return bl;
                if (call == null) return bl;
                LOG.warn((Object)(this.getName() + call.toShortString() + ": output error"));
                done = true;
                RpcServer.this.closeConnection(call.connection);
                return bl;
            }
            try {
                if (!call.response.hasRemaining()) {
                    call.connection.decRpcCount();
                    done = numElements == 1;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + ": callId: " + call.id + " wrote " + numBytes + " bytes."));
                    }
                } else {
                    call.connection.responseQueue.addFirst(call);
                    if (inHandler) {
                        call.timestamp = System.currentTimeMillis();
                        if (this.enqueueInSelector(call)) {
                            done = true;
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + call.toShortString() + " partially sent, wrote " + numBytes + " bytes."));
                    }
                }
                error = false;
                // MONITOREXIT : linkedList
                return done;
            }
            finally {
                if (error && call != null) {
                    LOG.warn((Object)(this.getName() + call.toShortString() + ": output error"));
                    done = true;
                    RpcServer.this.closeConnection(call.connection);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean enqueueInSelector(Call call) throws IOException {
            boolean done = false;
            this.incPending();
            try {
                SocketChannel channel = call.connection.channel;
                this.writeSelector.wakeup();
                channel.register(this.writeSelector, 4, call);
            }
            catch (ClosedChannelException e) {
                done = true;
            }
            finally {
                this.decPending();
            }
            return done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doRespond(Call call) throws IOException {
            call.timestamp = System.currentTimeMillis();
            boolean doRegister = false;
            LinkedList<Call> linkedList = call.connection.responseQueue;
            synchronized (linkedList) {
                call.connection.responseQueue.addLast(call);
                if (call.connection.responseQueue.size() == 1) {
                    doRegister = !this.processResponse(call.connection.responseQueue, false);
                }
            }
            if (doRegister) {
                this.enqueueInSelector(call);
            }
        }

        private synchronized void incPending() {
            ++this.pending;
        }

        private synchronized void decPending() {
            --this.pending;
            this.notify();
        }

        private synchronized void waitPending() throws InterruptedException {
            while (this.pending > 0) {
                this.wait();
            }
        }
    }

    private class Listener
    extends Thread {
        private ServerSocketChannel acceptChannel;
        private Selector selector;
        private Reader[] readers;
        private int currentReader;
        private Random rand;
        private long lastCleanupRunTime;
        private long cleanupInterval;
        private int backlogLength;
        private ExecutorService readPool;

        public Listener(String name) throws IOException {
            super(name);
            this.acceptChannel = null;
            this.selector = null;
            this.readers = null;
            this.currentReader = 0;
            this.rand = new Random();
            this.lastCleanupRunTime = 0L;
            this.cleanupInterval = 10000L;
            this.backlogLength = RpcServer.this.conf.getInt("ipc.server.listen.queue.size", 128);
            this.acceptChannel = ServerSocketChannel.open();
            this.acceptChannel.configureBlocking(false);
            RpcServer.bind(this.acceptChannel.socket(), RpcServer.this.isa, this.backlogLength);
            RpcServer.this.port = this.acceptChannel.socket().getLocalPort();
            this.selector = Selector.open();
            this.readers = new Reader[RpcServer.this.readThreads];
            this.readPool = Executors.newFixedThreadPool(RpcServer.this.readThreads, new ThreadFactoryBuilder().setNameFormat("RpcServer.reader=%d,port=" + RpcServer.this.port).setDaemon(true).build());
            for (int i = 0; i < RpcServer.this.readThreads; ++i) {
                Reader reader;
                this.readers[i] = reader = new Reader();
                this.readPool.execute(reader);
            }
            LOG.info((Object)(this.getName() + ": started " + RpcServer.this.readThreads + " reader(s)."));
            this.acceptChannel.register(this.selector, 16);
            this.setName("RpcServer.listener,port=" + RpcServer.this.port);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanupConnections(boolean force) {
            if (force || RpcServer.this.numConnections > RpcServer.this.thresholdIdleConnections) {
                long currentTime = System.currentTimeMillis();
                if (!force && currentTime - this.lastCleanupRunTime < this.cleanupInterval) {
                    return;
                }
                int start = 0;
                int end = RpcServer.this.numConnections - 1;
                if (!force) {
                    start = this.rand.nextInt() % RpcServer.this.numConnections;
                    end = this.rand.nextInt() % RpcServer.this.numConnections;
                    if (end < start) {
                        int temp = start;
                        start = end;
                        end = temp;
                    }
                }
                int i = start;
                int numNuked = 0;
                while (i <= end) {
                    Connection c;
                    List<Connection> list = RpcServer.this.connectionList;
                    synchronized (list) {
                        try {
                            c = RpcServer.this.connectionList.get(i);
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                    if (c.timedOut(currentTime)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(this.getName() + ": disconnecting client " + c.getHostAddress()));
                        }
                        RpcServer.this.closeConnection(c);
                        --end;
                        c = null;
                        if (force || ++numNuked != RpcServer.this.maxConnectionsToNuke) continue;
                        break;
                    }
                    ++i;
                }
                this.lastCleanupRunTime = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)(this.getName() + ": starting"));
            SERVER.set(RpcServer.this);
            while (RpcServer.this.running) {
                SelectionKey key = null;
                try {
                    this.selector.select();
                    Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        key = iter.next();
                        iter.remove();
                        try {
                            if (key.isValid() && key.isAcceptable()) {
                                this.doAccept(key);
                            }
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                        key = null;
                    }
                }
                catch (OutOfMemoryError e) {
                    if (RpcServer.this.errorHandler != null) {
                        if (RpcServer.this.errorHandler.checkOOME(e)) {
                            LOG.info((Object)(this.getName() + ": exiting on OutOfMemoryError"));
                            this.closeCurrentConnection(key, e);
                            this.cleanupConnections(true);
                            return;
                        }
                    } else {
                        LOG.warn((Object)(this.getName() + ": OutOfMemoryError in server select"), (Throwable)e);
                        this.closeCurrentConnection(key, e);
                        this.cleanupConnections(true);
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception e) {
                    this.closeCurrentConnection(key, e);
                }
                this.cleanupConnections(false);
            }
            LOG.info((Object)(this.getName() + ": stopping"));
            Listener listener = this;
            synchronized (listener) {
                try {
                    this.acceptChannel.close();
                    this.selector.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.selector = null;
                this.acceptChannel = null;
                while (!RpcServer.this.connectionList.isEmpty()) {
                    RpcServer.this.closeConnection(RpcServer.this.connectionList.remove(0));
                }
            }
        }

        private void closeCurrentConnection(SelectionKey key, Throwable e) {
            Connection c;
            if (key != null && (c = (Connection)key.attachment()) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": disconnecting client " + c.getHostAddress() + (e != null ? " on error " + e.getMessage() : "")));
                }
                RpcServer.this.closeConnection(c);
                key.attach(null);
            }
        }

        InetSocketAddress getAddress() {
            return (InetSocketAddress)this.acceptChannel.socket().getLocalSocketAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doAccept(SelectionKey key) throws IOException, OutOfMemoryError {
            SocketChannel channel;
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            while ((channel = server.accept()) != null) {
                try {
                    channel.configureBlocking(false);
                    channel.socket().setTcpNoDelay(RpcServer.this.tcpNoDelay);
                    channel.socket().setKeepAlive(RpcServer.this.tcpKeepAlive);
                }
                catch (IOException ioe) {
                    channel.close();
                    throw ioe;
                }
                Reader reader = this.getReader();
                try {
                    reader.startAdd();
                    SelectionKey readKey = reader.registerChannel(channel);
                    Connection c = RpcServer.this.getConnection(channel, System.currentTimeMillis());
                    readKey.attach(c);
                    List<Connection> list = RpcServer.this.connectionList;
                    synchronized (list) {
                        RpcServer.this.connectionList.add(RpcServer.this.numConnections, c);
                        ++RpcServer.this.numConnections;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)(this.getName() + ": connection from " + c.toString() + "; # active connections: " + RpcServer.this.numConnections + "; # queued calls: " + RpcServer.this.callQueue.size()));
                }
                finally {
                    reader.finishAdd();
                }
            }
        }

        void doRead(SelectionKey key) throws InterruptedException {
            int count = 0;
            Connection c = (Connection)key.attachment();
            if (c == null) {
                return;
            }
            c.setLastContact(System.currentTimeMillis());
            try {
                count = c.readAndProcess();
            }
            catch (InterruptedException ieo) {
                throw ieo;
            }
            catch (Exception e) {
                LOG.warn((Object)(this.getName() + ": count of bytes read: " + count), (Throwable)e);
                count = -1;
            }
            if (count < 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": DISCONNECTING client " + c.toString() + " because read count=" + count + ". Number of active connections: " + RpcServer.this.numConnections));
                }
                RpcServer.this.closeConnection(c);
            } else {
                c.setLastContact(System.currentTimeMillis());
            }
        }

        synchronized void doStop() {
            if (this.selector != null) {
                this.selector.wakeup();
                Thread.yield();
            }
            if (this.acceptChannel != null) {
                try {
                    this.acceptChannel.socket().close();
                }
                catch (IOException e) {
                    LOG.info((Object)(this.getName() + ": exception in closing listener socket. " + e));
                }
            }
            this.readPool.shutdownNow();
        }

        Reader getReader() {
            this.currentReader = (this.currentReader + 1) % this.readers.length;
            return this.readers[this.currentReader];
        }

        private class Reader
        implements Runnable {
            private volatile boolean adding = false;
            private final Selector readSelector = Selector.open();

            Reader() throws IOException {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.doRunLoop();
                }
                finally {
                    try {
                        this.readSelector.close();
                    }
                    catch (IOException ioe) {
                        LOG.error((Object)(Listener.this.getName() + ": error closing read selector in " + Listener.this.getName()), (Throwable)ioe);
                    }
                }
            }

            private synchronized void doRunLoop() {
                while (RpcServer.this.running) {
                    SelectionKey key = null;
                    try {
                        this.readSelector.select();
                        while (this.adding) {
                            this.wait(1000L);
                        }
                        Iterator<SelectionKey> iter = this.readSelector.selectedKeys().iterator();
                        while (iter.hasNext()) {
                            key = iter.next();
                            iter.remove();
                            if (key.isValid() && key.isReadable()) {
                                Listener.this.doRead(key);
                            }
                            key = null;
                        }
                    }
                    catch (InterruptedException e) {
                        if (!RpcServer.this.running) continue;
                        LOG.info((Object)(Listener.this.getName() + ": unexpectedly interrupted: " + StringUtils.stringifyException((Throwable)e)));
                    }
                    catch (IOException ex) {
                        LOG.error((Object)(Listener.this.getName() + ": error in Reader"), (Throwable)ex);
                    }
                }
            }

            public void startAdd() {
                this.adding = true;
                this.readSelector.wakeup();
            }

            public synchronized SelectionKey registerChannel(SocketChannel channel) throws IOException {
                return channel.register(this.readSelector, 1);
            }

            public synchronized void finishAdd() {
                this.adding = false;
                this.notify();
            }
        }
    }

    class Call
    implements RpcCallContext {
        protected int id;
        protected BlockingService service;
        protected Descriptors.MethodDescriptor md;
        protected Message param;
        protected CellScanner cellScanner;
        protected Connection connection;
        protected long timestamp;
        protected BufferChain response;
        protected boolean delayResponse;
        protected Responder responder;
        protected boolean delayReturnValue;
        protected long size;
        protected boolean isError;
        protected TraceInfo tinfo;

        Call(int id, BlockingService service, Descriptors.MethodDescriptor md, Message param, CellScanner cellScanner, Connection connection, Responder responder, long size, TraceInfo tinfo) {
            this.id = id;
            this.service = service;
            this.md = md;
            this.param = param;
            this.cellScanner = cellScanner;
            this.connection = connection;
            this.timestamp = System.currentTimeMillis();
            this.response = null;
            this.delayResponse = false;
            this.responder = responder;
            this.isError = false;
            this.size = size;
            this.tinfo = tinfo;
        }

        public String toString() {
            return this.toShortString() + " param: " + (this.param != null ? ProtobufUtil.getShortTextFormat((Message)this.param) : "") + " connection: " + this.connection.toString();
        }

        String toShortString() {
            String serviceName = this.connection.service != null ? this.connection.service.getDescriptorForType().getName() : "null";
            StringBuilder sb = new StringBuilder();
            sb.append("callId: ");
            sb.append(this.id);
            sb.append(" service: ");
            sb.append(serviceName);
            sb.append(" methodName: ");
            sb.append(this.md != null ? this.md.getName() : "");
            sb.append(" size: ");
            sb.append(StringUtils.humanReadableInt((long)this.size));
            sb.append(" connection: ");
            sb.append(this.connection.toString());
            return sb.toString();
        }

        String toTraceString() {
            String serviceName = this.connection.service != null ? this.connection.service.getDescriptorForType().getName() : "";
            String methodName = this.md != null ? this.md.getName() : "";
            String result = serviceName + "." + methodName;
            return result;
        }

        protected synchronized void setSaslTokenResponse(ByteBuffer response) {
            this.response = new BufferChain(response);
        }

        protected synchronized void setResponse(Object m, CellScanner cells, Throwable t, String errorMsg) {
            if (this.isError) {
                return;
            }
            if (t != null) {
                this.isError = true;
            }
            BufferChain bc = null;
            try {
                ByteBuffer cellBlock;
                RPCProtos.ResponseHeader.Builder headerBuilder = RPCProtos.ResponseHeader.newBuilder();
                Message result = (Message)m;
                headerBuilder.setCallId(this.id);
                if (t != null) {
                    RPCProtos.ExceptionResponse.Builder exceptionBuilder = RPCProtos.ExceptionResponse.newBuilder();
                    exceptionBuilder.setExceptionClassName(t.getClass().getName());
                    exceptionBuilder.setStackTrace(errorMsg);
                    exceptionBuilder.setDoNotRetry(t instanceof DoNotRetryIOException);
                    if (t instanceof RegionMovedException) {
                        RegionMovedException rme = (RegionMovedException)t;
                        exceptionBuilder.setHostname(rme.getHostname());
                        exceptionBuilder.setPort(rme.getPort());
                    }
                    headerBuilder.setException(exceptionBuilder.build());
                }
                if ((cellBlock = RpcServer.this.ipcUtil.buildCellBlock(this.connection.codec, this.connection.compressionCodec, cells)) != null) {
                    RPCProtos.CellBlockMeta.Builder cellBlockBuilder = RPCProtos.CellBlockMeta.newBuilder();
                    cellBlockBuilder.setLength(cellBlock.limit());
                    headerBuilder.setCellBlockMeta(cellBlockBuilder.build());
                }
                RPCProtos.ResponseHeader header = headerBuilder.build();
                ByteBuffer bbHeader = IPCUtil.getDelimitedMessageAsByteBuffer((Message)header);
                ByteBuffer bbResult = IPCUtil.getDelimitedMessageAsByteBuffer((Message)result);
                int totalSize = bbHeader.capacity() + (bbResult == null ? 0 : bbResult.limit()) + (cellBlock == null ? 0 : cellBlock.limit());
                ByteBuffer bbTotalSize = ByteBuffer.wrap(Bytes.toBytes((int)totalSize));
                bc = new BufferChain(bbTotalSize, bbHeader, bbResult, cellBlock);
                if (this.connection.useWrap) {
                    bc = this.wrapWithSasl(bc);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Exception while creating response " + e));
            }
            this.response = bc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BufferChain wrapWithSasl(BufferChain bc) throws IOException {
            byte[] token;
            if (bc == null) {
                return bc;
            }
            if (!this.connection.useSasl) {
                return bc;
            }
            byte[] responseBytes = bc.getBytes();
            SaslServer saslServer = this.connection.saslServer;
            synchronized (saslServer) {
                token = this.connection.saslServer.wrap(responseBytes, 0, responseBytes.length);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding saslServer wrapped token of size " + token.length + " as call response."));
            }
            ByteBuffer bbTokenLength = ByteBuffer.wrap(Bytes.toBytes((int)token.length));
            ByteBuffer bbTokenBytes = ByteBuffer.wrap(token);
            return new BufferChain(bbTokenLength, bbTokenBytes);
        }

        @Override
        public synchronized void endDelay(Object result) throws IOException {
            assert (this.delayResponse);
            assert (this.delayReturnValue || result == null);
            this.delayResponse = false;
            RpcServer.this.delayedCalls.decrementAndGet();
            if (this.delayReturnValue) {
                this.setResponse(result, null, null, null);
            }
            this.responder.doRespond(this);
        }

        @Override
        public synchronized void endDelay() throws IOException {
            this.endDelay(null);
        }

        @Override
        public synchronized void startDelay(boolean delayReturnValue) {
            assert (!this.delayResponse);
            this.delayResponse = true;
            this.delayReturnValue = delayReturnValue;
            int numDelayed = RpcServer.this.delayedCalls.incrementAndGet();
            if (numDelayed > RpcServer.this.warnDelayedCalls) {
                LOG.warn((Object)("Too many delayed calls: limit " + RpcServer.this.warnDelayedCalls + " current " + numDelayed));
            }
        }

        @Override
        public synchronized void endDelayThrowing(Throwable t) throws IOException {
            this.setResponse(null, null, t, StringUtils.stringifyException((Throwable)t));
            this.delayResponse = false;
            this.sendResponseIfReady();
        }

        @Override
        public synchronized boolean isDelayed() {
            return this.delayResponse;
        }

        @Override
        public synchronized boolean isReturnValueDelayed() {
            return this.delayReturnValue;
        }

        @Override
        public boolean isClientCellBlockSupport() {
            return this.connection != null && this.connection.codec != null;
        }

        @Override
        public long disconnectSince() {
            if (!this.connection.channel.isOpen()) {
                return System.currentTimeMillis() - this.timestamp;
            }
            return -1L;
        }

        public long getSize() {
            return this.size;
        }

        public synchronized void sendResponseIfReady() throws IOException {
            if (!this.delayResponse) {
                this.responder.doRespond(this);
            }
        }
    }
}

