/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class NamespaceJanitor
extends Chore {
    private static final Log LOG = LogFactory.getLog((String)NamespaceJanitor.class.getName());
    private final MasterServices services;
    private AtomicBoolean enabled = new AtomicBoolean(true);

    public NamespaceJanitor(MasterServices services) {
        super("NamespaceJanitor-" + services.getServerName().toShortString(), services.getConfiguration().getInt("hbase.namespacejanitor.interval", 300000), (Stoppable)services);
        this.services = services;
    }

    protected boolean initialChore() {
        try {
            if (this.enabled.get()) {
                this.removeOrphans();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed NamespaceJanitor chore", (Throwable)e);
            return false;
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Failed NamespaceJanitor chore", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean setEnabled(boolean enabled) {
        return this.enabled.getAndSet(enabled);
    }

    boolean getEnabled() {
        return this.enabled.get();
    }

    protected void chore() {
        try {
            if (this.enabled.get()) {
                this.removeOrphans();
            } else {
                LOG.warn((Object)"NamepsaceJanitor disabled! Not running scan.");
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed NamespaceJanitor chore", (Throwable)e);
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Failed NamespaceJanitor chore", (Throwable)e);
        }
    }

    private void removeOrphans() throws IOException, KeeperException {
        FileSystem fs = this.services.getMasterFileSystem().getFileSystem();
        HashSet descs = Sets.newHashSet();
        for (NamespaceDescriptor ns : this.services.listNamespaceDescriptors()) {
            descs.add(ns.getName());
        }
        for (FileStatus nsStatus : FSUtils.listStatus(fs, new Path(FSUtils.getRootDir(this.services.getConfiguration()), "data"))) {
            if (descs.contains(nsStatus.getPath().getName()) || NamespaceDescriptor.RESERVED_NAMESPACES.contains(nsStatus.getPath().getName())) continue;
            boolean isEmpty = true;
            for (FileStatus status : fs.listStatus(nsStatus.getPath())) {
                if (HConstants.HBASE_NON_TABLE_DIRS.contains(status.getPath().getName())) continue;
                isEmpty = false;
                break;
            }
            if (isEmpty) {
                try {
                    if (!fs.delete(nsStatus.getPath(), true)) {
                        LOG.error((Object)("Failed to remove namespace directory: " + nsStatus.getPath()));
                    }
                }
                catch (IOException ex) {
                    LOG.error((Object)("Failed to remove namespace directory: " + nsStatus.getPath()), (Throwable)ex);
                }
                LOG.debug((Object)("Removed namespace directory: " + nsStatus.getPath()));
                continue;
            }
            LOG.debug((Object)("Skipping non-empty namespace directory: " + nsStatus.getPath()));
        }
        String baseZnode = ZooKeeperWatcher.namespaceZNode;
        for (String child : ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)this.services.getZooKeeper(), (String)baseZnode)) {
            if (descs.contains(child) || NamespaceDescriptor.RESERVED_NAMESPACES.contains(child)) continue;
            String znode = ZKUtil.joinZNode((String)baseZnode, (String)child);
            try {
                ZKUtil.deleteNode((ZooKeeperWatcher)this.services.getZooKeeper(), (String)znode);
                LOG.debug((Object)("Removed namespace znode: " + znode));
            }
            catch (KeeperException ex) {
                LOG.debug((Object)("Failed to remove namespace znode: " + znode), (Throwable)ex);
            }
        }
    }
}

