/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.NonLazyKeyValueScanner;

@InterfaceAudience.Private
public class KeyValueHeap
extends NonLazyKeyValueScanner
implements KeyValueScanner,
InternalScanner {
    private PriorityQueue<KeyValueScanner> heap = null;
    private KeyValueScanner current = null;
    private KVScannerComparator comparator;

    public KeyValueHeap(List<? extends KeyValueScanner> scanners, KeyValue.KVComparator comparator) throws IOException {
        this.comparator = new KVScannerComparator(comparator);
        if (!scanners.isEmpty()) {
            this.heap = new PriorityQueue<KeyValueScanner>(scanners.size(), this.comparator);
            for (KeyValueScanner keyValueScanner : scanners) {
                if (keyValueScanner.peek() != null) {
                    this.heap.add(keyValueScanner);
                    continue;
                }
                keyValueScanner.close();
            }
            this.current = this.pollRealKV();
        }
    }

    @Override
    public KeyValue peek() {
        if (this.current == null) {
            return null;
        }
        return this.current.peek();
    }

    @Override
    public KeyValue next() throws IOException {
        if (this.current == null) {
            return null;
        }
        KeyValue kvReturn = this.current.next();
        KeyValue kvNext = this.current.peek();
        if (kvNext == null) {
            this.current.close();
            this.current = this.pollRealKV();
        } else {
            KeyValueScanner topScanner = this.heap.peek();
            if (topScanner == null || this.comparator.compare(kvNext, topScanner.peek()) >= 0) {
                this.heap.add(this.current);
                this.current = this.pollRealKV();
            }
        }
        return kvReturn;
    }

    @Override
    public boolean next(List<Cell> result, int limit) throws IOException {
        if (this.current == null) {
            return false;
        }
        InternalScanner currentAsInternal = (InternalScanner)((Object)this.current);
        boolean mayContainMoreRows = currentAsInternal.next(result, limit);
        KeyValue pee = this.current.peek();
        if (pee == null || !mayContainMoreRows) {
            this.current.close();
        } else {
            this.heap.add(this.current);
        }
        this.current = this.pollRealKV();
        return this.current != null;
    }

    @Override
    public boolean next(List<Cell> result) throws IOException {
        return this.next(result, -1);
    }

    @Override
    public void close() {
        if (this.current != null) {
            this.current.close();
        }
        if (this.heap != null) {
            KeyValueScanner scanner;
            while ((scanner = this.heap.poll()) != null) {
                scanner.close();
            }
        }
    }

    @Override
    public boolean seek(KeyValue seekKey) throws IOException {
        return this.generalizedSeek(false, seekKey, false, false);
    }

    @Override
    public boolean reseek(KeyValue seekKey) throws IOException {
        return this.generalizedSeek(false, seekKey, true, false);
    }

    @Override
    public boolean requestSeek(KeyValue key, boolean forward, boolean useBloom) throws IOException {
        return this.generalizedSeek(true, key, forward, useBloom);
    }

    private boolean generalizedSeek(boolean isLazy, KeyValue seekKey, boolean forward, boolean useBloom) throws IOException {
        KeyValueScanner scanner;
        if (!isLazy && useBloom) {
            throw new IllegalArgumentException("Multi-column Bloom filter optimization requires a lazy seek");
        }
        if (this.current == null) {
            return false;
        }
        this.heap.add(this.current);
        this.current = null;
        while ((scanner = this.heap.poll()) != null) {
            KeyValue topKey = scanner.peek();
            if (this.comparator.getComparator().compare((Cell)seekKey, (Cell)topKey) <= 0) {
                this.heap.add(scanner);
                this.current = this.pollRealKV();
                return this.current != null;
            }
            boolean seekResult = isLazy && this.heap.size() > 0 ? scanner.requestSeek(seekKey, forward, useBloom) : NonLazyKeyValueScanner.doRealSeek(scanner, seekKey, forward);
            if (!seekResult) {
                scanner.close();
                continue;
            }
            this.heap.add(scanner);
        }
        return false;
    }

    private KeyValueScanner pollRealKV() throws IOException {
        KeyValueScanner kvScanner = this.heap.poll();
        if (kvScanner == null) {
            return null;
        }
        while (kvScanner != null && !kvScanner.realSeekDone()) {
            if (kvScanner.peek() != null) {
                kvScanner.enforceSeek();
                KeyValue curKV = kvScanner.peek();
                if (curKV != null) {
                    KeyValueScanner nextEarliestScanner = this.heap.peek();
                    if (nextEarliestScanner == null) {
                        return kvScanner;
                    }
                    KeyValue nextKV = nextEarliestScanner.peek();
                    if (nextKV == null || this.comparator.compare(curKV, nextKV) < 0) {
                        return kvScanner;
                    }
                    this.heap.add(kvScanner);
                } else {
                    kvScanner.close();
                }
            } else {
                kvScanner.close();
            }
            kvScanner = this.heap.poll();
        }
        return kvScanner;
    }

    public PriorityQueue<KeyValueScanner> getHeap() {
        return this.heap;
    }

    @Override
    public long getSequenceID() {
        return 0L;
    }

    KeyValueScanner getCurrentForTesting() {
        return this.current;
    }

    private static class KVScannerComparator
    implements Comparator<KeyValueScanner> {
        private KeyValue.KVComparator kvComparator;

        public KVScannerComparator(KeyValue.KVComparator kvComparator) {
            this.kvComparator = kvComparator;
        }

        @Override
        public int compare(KeyValueScanner left, KeyValueScanner right) {
            long rightSequenceID;
            int comparison = this.compare(left.peek(), right.peek());
            if (comparison != 0) {
                return comparison;
            }
            long leftSequenceID = left.getSequenceID();
            if (leftSequenceID > (rightSequenceID = right.getSequenceID())) {
                return -1;
            }
            if (leftSequenceID < rightSequenceID) {
                return 1;
            }
            return 0;
        }

        @Override
        public int compare(KeyValue left, KeyValue right) {
            return this.kvComparator.compare((Cell)left, (Cell)right);
        }

        public KeyValue.KVComparator getComparator() {
            return this.kvComparator;
        }
    }
}

