/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.metrics2.MetricsExecutor;

public class MetricsRegionWrapperImpl
implements MetricsRegionWrapper,
Closeable {
    public static final int PERIOD = 45;
    public static final String UNKNOWN = "unknown";
    private final HRegion region;
    private ScheduledExecutorService executor;
    private Runnable runnable;
    private long numStoreFiles;
    private long memstoreSize;
    private long storeFileSize;
    private ScheduledFuture<?> regionMetricsUpdateTask;

    public MetricsRegionWrapperImpl(HRegion region) {
        this.region = region;
        this.executor = ((MetricsExecutor)CompatibilitySingletonFactory.getInstance(MetricsExecutor.class)).getExecutor();
        this.runnable = new HRegionMetricsWrapperRunnable();
        this.regionMetricsUpdateTask = this.executor.scheduleWithFixedDelay(this.runnable, 45L, 45L, TimeUnit.SECONDS);
    }

    public String getTableName() {
        HTableDescriptor tableDesc = this.region.getTableDesc();
        if (tableDesc == null) {
            return UNKNOWN;
        }
        return tableDesc.getTableName().getQualifierAsString();
    }

    public String getNamespace() {
        HTableDescriptor tableDesc = this.region.getTableDesc();
        if (tableDesc == null) {
            return UNKNOWN;
        }
        return tableDesc.getTableName().getNamespaceAsString();
    }

    public String getRegionName() {
        HRegionInfo regionInfo = this.region.getRegionInfo();
        if (regionInfo == null) {
            return UNKNOWN;
        }
        return regionInfo.getEncodedName();
    }

    public long getNumStores() {
        Map<byte[], Store> stores = this.region.stores;
        if (stores == null) {
            return 0L;
        }
        return stores.size();
    }

    public long getNumStoreFiles() {
        return this.numStoreFiles;
    }

    public long getMemstoreSize() {
        return this.memstoreSize;
    }

    public long getStoreFileSize() {
        return this.storeFileSize;
    }

    public long getReadRequestCount() {
        return this.region.getReadRequestsCount();
    }

    public long getWriteRequestCount() {
        return this.region.getWriteRequestsCount();
    }

    public long getNumFilesCompacted() {
        return this.region.compactionNumFilesCompacted.get();
    }

    public long getNumBytesCompacted() {
        return this.region.compactionNumBytesCompacted.get();
    }

    public long getNumCompactionsCompleted() {
        return this.region.compactionsFinished.get();
    }

    @Override
    public void close() throws IOException {
        this.regionMetricsUpdateTask.cancel(true);
    }

    public class HRegionMetricsWrapperRunnable
    implements Runnable {
        @Override
        public void run() {
            long tempNumStoreFiles = 0L;
            long tempMemstoreSize = 0L;
            long tempStoreFileSize = 0L;
            if (((MetricsRegionWrapperImpl)MetricsRegionWrapperImpl.this).region.stores != null) {
                for (Store store : ((MetricsRegionWrapperImpl)MetricsRegionWrapperImpl.this).region.stores.values()) {
                    tempNumStoreFiles += (long)store.getStorefilesCount();
                    tempMemstoreSize += store.getMemStoreSize();
                    tempStoreFileSize += store.getStorefilesSize();
                }
            }
            MetricsRegionWrapperImpl.this.numStoreFiles = tempNumStoreFiles;
            MetricsRegionWrapperImpl.this.memstoreSize = tempMemstoreSize;
            MetricsRegionWrapperImpl.this.storeFileSize = tempStoreFileSize;
        }
    }
}

