/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.monitoring.LogMonitoring;
import org.apache.hadoop.hbase.monitoring.StateDumpServlet;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
public class RSDumpServlet
extends StateDumpServlet {
    private static final long serialVersionUID = 1L;
    private static final String LINE = "===========================================================";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HRegionServer hrs = (HRegionServer)this.getServletContext().getAttribute("regionserver");
        assert (hrs != null) : "No RS in context!";
        Configuration hrsconf = (Configuration)this.getServletContext().getAttribute("regionserver_conf");
        assert (hrsconf != null) : "No RS conf in context";
        response.setContentType("text/plain");
        ServletOutputStream os = response.getOutputStream();
        PrintWriter out = new PrintWriter((OutputStream)os);
        out.println("Master status for " + hrs.getServerName() + " as of " + new Date());
        out.println("\n\nVersion Info:");
        out.println(LINE);
        this.dumpVersionInfo(out);
        out.println("\n\nTasks:");
        out.println(LINE);
        TaskMonitor.get().dumpAsText(out);
        out.println("\n\nExecutors:");
        out.println(LINE);
        this.dumpExecutors(hrs.getExecutorService(), out);
        out.println("\n\nStacks:");
        out.println(LINE);
        ReflectionUtils.printThreadInfo((PrintWriter)out, (String)"");
        out.println("\n\nRS Configuration:");
        out.println(LINE);
        Configuration conf = hrs.getConfiguration();
        out.flush();
        conf.writeXml((OutputStream)os);
        os.flush();
        out.println("\n\nLogs");
        out.println(LINE);
        long tailKb = this.getTailKbParam(request);
        LogMonitoring.dumpTailOfLogs(out, tailKb);
        out.println("\n\nRS Queue:");
        out.println(LINE);
        if (this.isShowQueueDump(hrsconf)) {
            this.dumpQueue(hrs, out);
        }
        out.flush();
    }

    private boolean isShowQueueDump(Configuration conf) {
        return conf.getBoolean("hbase.regionserver.servlet.show.queuedump", true);
    }

    private void dumpQueue(HRegionServer hrs, PrintWriter out) throws IOException {
        out.println("Compaction/Split Queue summary: " + hrs.compactSplitThread.toString());
        out.println(hrs.compactSplitThread.dumpQueue());
        out.println("\nFlush Queue summary: " + hrs.cacheFlusher.toString());
        out.println(hrs.cacheFlusher.dumpQueue());
    }
}

