/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.ReaderBase;
import org.apache.hadoop.hbase.regionserver.wal.SequenceFileLogReader;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

public class HLogFactory {
    private static final Log LOG = LogFactory.getLog(HLogFactory.class);
    private static Class<? extends HLog.Reader> logReaderClass;
    private static Class<? extends HLog.Writer> logWriterClass;

    public static HLog createHLog(FileSystem fs, Path root, String logName, Configuration conf) throws IOException {
        return new FSHLog(fs, root, logName, conf);
    }

    public static HLog createHLog(FileSystem fs, Path root, String logName, String oldLogName, Configuration conf) throws IOException {
        return new FSHLog(fs, root, logName, oldLogName, conf);
    }

    public static HLog createHLog(FileSystem fs, Path root, String logName, Configuration conf, List<WALActionsListener> listeners, String prefix) throws IOException {
        return new FSHLog(fs, root, logName, conf, listeners, prefix);
    }

    public static HLog createMetaHLog(FileSystem fs, Path root, String logName, Configuration conf, List<WALActionsListener> listeners, String prefix) throws IOException {
        return new FSHLog(fs, root, logName, "oldWALs", conf, listeners, false, prefix, true);
    }

    static void resetLogReaderClass() {
        logReaderClass = null;
    }

    public static HLog.Reader createReader(FileSystem fs, Path path, Configuration conf) throws IOException {
        return HLogFactory.createReader(fs, path, conf, null);
    }

    public static HLog.Reader createReader(FileSystem fs, Path path, Configuration conf, CancelableProgressable reporter) throws IOException {
        return HLogFactory.createReader(fs, path, conf, reporter, true);
    }

    public static HLog.Reader createReader(FileSystem fs, Path path, Configuration conf, CancelableProgressable reporter, boolean allowCustom) throws IOException {
        if (allowCustom && logReaderClass == null) {
            logReaderClass = conf.getClass("hbase.regionserver.hlog.reader.impl", ProtobufLogReader.class, HLog.Reader.class);
        }
        Class<? extends HLog.Reader> lrClass = allowCustom ? logReaderClass : ProtobufLogReader.class;
        try {
            long startWaiting = EnvironmentEdgeManager.currentTimeMillis();
            long openTimeout = (long)conf.getInt("hbase.hlog.open.timeout", 300000) + startWaiting;
            int nbAttempt = 0;
            while (true) {
                try {
                    byte[] magic;
                    if (lrClass != ProtobufLogReader.class) {
                        HLog.Reader reader = lrClass.newInstance();
                        reader.init(fs, path, conf, null);
                        return reader;
                    }
                    FSDataInputStream stream = fs.open(path);
                    boolean isPbWal = stream.read(magic = new byte[ProtobufLogReader.PB_WAL_MAGIC.length]) == magic.length && Arrays.equals(magic, ProtobufLogReader.PB_WAL_MAGIC);
                    ReaderBase reader = isPbWal ? new ProtobufLogReader() : new SequenceFileLogReader();
                    reader.init(fs, path, conf, stream);
                    return reader;
                }
                catch (IOException e) {
                    String msg = e.getMessage();
                    if (msg != null && (msg.contains("Cannot obtain block length") || msg.contains("Could not obtain the last block") || msg.matches("Blocklist for [^ ]* has changed.*"))) {
                        if (++nbAttempt == 1) {
                            LOG.warn((Object)"Lease should have recovered. This is not expected. Will retry", (Throwable)e);
                        }
                        if (reporter != null && !reporter.progress()) {
                            throw new InterruptedIOException("Operation is cancelled");
                        }
                        if (nbAttempt > 2 && openTimeout < EnvironmentEdgeManager.currentTimeMillis()) {
                            LOG.error((Object)("Can't open after " + nbAttempt + " attempts and " + (EnvironmentEdgeManager.currentTimeMillis() - startWaiting) + "ms " + " for " + path));
                        } else {
                            try {
                                Thread.sleep(nbAttempt < 3 ? 500L : 1000L);
                            }
                            catch (InterruptedException ie) {
                                InterruptedIOException iioe = new InterruptedIOException();
                                iioe.initCause(ie);
                                throw iioe;
                            }
                            continue;
                        }
                    }
                    throw e;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new IOException("Cannot get log reader", e);
        }
    }

    public static HLog.Writer createWALWriter(FileSystem fs, Path path, Configuration conf) throws IOException {
        return HLogFactory.createWriter(fs, path, conf, false);
    }

    public static HLog.Writer createRecoveredEditsWriter(FileSystem fs, Path path, Configuration conf) throws IOException {
        return HLogFactory.createWriter(fs, path, conf, true);
    }

    private static HLog.Writer createWriter(FileSystem fs, Path path, Configuration conf, boolean overwritable) throws IOException {
        try {
            if (logWriterClass == null) {
                logWriterClass = conf.getClass("hbase.regionserver.hlog.writer.impl", ProtobufLogWriter.class, HLog.Writer.class);
            }
            HLog.Writer writer = logWriterClass.newInstance();
            writer.init(fs, path, conf, overwritable);
            return writer;
        }
        catch (Exception e) {
            throw new IOException("cannot get log writer", e);
        }
    }
}

