/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import javax.ws.rs.Encoded;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.rest.ExistsResource;
import org.apache.hadoop.hbase.rest.MultiRowResource;
import org.apache.hadoop.hbase.rest.RegionsResource;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.RowResource;
import org.apache.hadoop.hbase.rest.ScannerResource;
import org.apache.hadoop.hbase.rest.SchemaResource;

@InterfaceAudience.Private
public class TableResource
extends ResourceBase {
    String table;

    public TableResource(String table) throws IOException {
        this.table = table;
    }

    String getName() {
        return this.table;
    }

    boolean exists() throws IOException {
        return this.servlet.getAdmin().tableExists(this.table);
    }

    @Path(value="exists")
    public ExistsResource getExistsResource() throws IOException {
        return new ExistsResource(this);
    }

    @Path(value="regions")
    public RegionsResource getRegionsResource() throws IOException {
        return new RegionsResource(this);
    }

    @Path(value="scanner")
    public ScannerResource getScannerResource() throws IOException {
        return new ScannerResource(this);
    }

    @Path(value="schema")
    public SchemaResource getSchemaResource() throws IOException {
        return new SchemaResource(this);
    }

    @Path(value="multiget")
    public MultiRowResource getMultipleRowResource(@QueryParam(value="v") String versions) throws IOException {
        return new MultiRowResource(this, versions);
    }

    @Path(value="{rowspec: .+}")
    public RowResource getRowResource(@PathParam(value="rowspec") @Encoded String rowspec, @QueryParam(value="v") String versions, @QueryParam(value="check") String check) throws IOException {
        return new RowResource(this, rowspec, versions, check);
    }
}

