/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnectable;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
class HMerge {
    static final Log LOG = LogFactory.getLog(HMerge.class);
    static final Random rand = new Random();

    private HMerge() {
    }

    public static void merge(Configuration conf, FileSystem fs, TableName tableName) throws IOException {
        HMerge.merge(conf, fs, tableName, true);
    }

    public static void merge(Configuration conf, FileSystem fs, TableName tableName, boolean testMasterRunning) throws IOException {
        boolean masterIsRunning = false;
        if (testMasterRunning) {
            masterIsRunning = (Boolean)HConnectionManager.execute((HConnectable)new HConnectable<Boolean>(conf){

                public Boolean connect(HConnection connection) throws IOException {
                    return connection.isMasterRunning();
                }
            });
        }
        if (tableName.equals((Object)TableName.META_TABLE_NAME)) {
            if (masterIsRunning) {
                throw new IllegalStateException("Can not compact hbase:meta table if instance is on-line");
            }
        } else {
            if (!masterIsRunning) {
                throw new IllegalStateException("HBase instance must be running to merge a normal table");
            }
            HBaseAdmin admin = new HBaseAdmin(conf);
            if (!admin.isTableDisabled(tableName)) {
                throw new TableNotDisabledException(tableName);
            }
            new OnlineMerger(conf, fs, tableName).process();
        }
    }

    private static class OnlineMerger
    extends Merger {
        private final TableName tableName;
        private final HTable table;
        private final ResultScanner metaScanner;
        private HRegionInfo latestRegion;

        OnlineMerger(Configuration conf, FileSystem fs, TableName tableName) throws IOException {
            super(conf, fs, tableName);
            this.tableName = tableName;
            this.table = new HTable(conf, TableName.META_TABLE_NAME);
            this.metaScanner = this.table.getScanner(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
            this.latestRegion = null;
        }

        private HRegionInfo nextRegion() throws IOException {
            try {
                Result results = this.getMetaRow();
                if (results == null) {
                    return null;
                }
                HRegionInfo region = HRegionInfo.getHRegionInfo((Result)results);
                if (region == null) {
                    throw new NoSuchElementException("meta region entry missing " + Bytes.toString((byte[])HConstants.CATALOG_FAMILY) + ":" + Bytes.toString((byte[])HConstants.REGIONINFO_QUALIFIER));
                }
                if (!region.getTable().equals((Object)this.tableName)) {
                    return null;
                }
                return region;
            }
            catch (IOException e) {
                e = RemoteExceptionHandler.checkIOException((IOException)e);
                LOG.error((Object)"meta scanner error", (Throwable)e);
                this.metaScanner.close();
                throw e;
            }
        }

        private Result getMetaRow() throws IOException {
            Result currentRow = this.metaScanner.next();
            boolean foundResult = false;
            while (currentRow != null) {
                LOG.info((Object)("Row: <" + Bytes.toStringBinary((byte[])currentRow.getRow()) + ">"));
                byte[] regionInfoValue = currentRow.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                if (regionInfoValue == null || regionInfoValue.length == 0) {
                    currentRow = this.metaScanner.next();
                    continue;
                }
                HRegionInfo region = HRegionInfo.getHRegionInfo((Result)currentRow);
                if (!region.getTable().equals((Object)this.tableName)) {
                    currentRow = this.metaScanner.next();
                    continue;
                }
                foundResult = true;
                break;
            }
            return foundResult ? currentRow : null;
        }

        @Override
        protected HRegionInfo[] next() throws IOException {
            ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>();
            if (this.latestRegion == null) {
                this.latestRegion = this.nextRegion();
            }
            if (this.latestRegion != null) {
                regions.add(this.latestRegion);
            }
            this.latestRegion = this.nextRegion();
            if (this.latestRegion != null) {
                regions.add(this.latestRegion);
            }
            return regions.toArray(new HRegionInfo[regions.size()]);
        }

        @Override
        protected void updateMeta(byte[] oldRegion1, byte[] oldRegion2, HRegion newRegion) throws IOException {
            byte[][] regionsToDelete = new byte[][]{oldRegion1, oldRegion2};
            for (int r = 0; r < regionsToDelete.length; ++r) {
                if (Bytes.equals((byte[])regionsToDelete[r], (byte[])this.latestRegion.getRegionName())) {
                    this.latestRegion = null;
                }
                Delete delete = new Delete(regionsToDelete[r]);
                this.table.delete(delete);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("updated columns in row: " + Bytes.toStringBinary((byte[])regionsToDelete[r])));
            }
            newRegion.getRegionInfo().setOffline(true);
            MetaEditor.addRegionToMeta(this.table, newRegion.getRegionInfo());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("updated columns in row: " + Bytes.toStringBinary((byte[])newRegion.getRegionName())));
            }
        }
    }

    private static abstract class Merger {
        protected final Configuration conf;
        protected final FileSystem fs;
        protected final Path rootDir;
        protected final HTableDescriptor htd;
        protected final HLog hlog;
        private final long maxFilesize;

        protected Merger(Configuration conf, FileSystem fs, TableName tableName) throws IOException {
            this.conf = conf;
            this.fs = fs;
            this.maxFilesize = conf.getLong("hbase.hregion.max.filesize", 0x280000000L);
            this.rootDir = FSUtils.getRootDir(conf);
            Path tabledir = FSUtils.getTableDir(this.rootDir, tableName);
            this.htd = FSTableDescriptors.getTableDescriptorFromFs(this.fs, tabledir);
            String logname = "merge_" + System.currentTimeMillis() + "WALs";
            this.hlog = HLogFactory.createHLog(fs, tabledir, logname, conf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void process() throws IOException {
            try {
                HRegionInfo[] regionsToMerge = this.next();
                while (regionsToMerge != null) {
                    if (!this.merge(regionsToMerge)) {
                        return;
                    }
                    regionsToMerge = this.next();
                }
            }
            finally {
                try {
                    this.hlog.closeAndDelete();
                }
                catch (IOException e) {
                    LOG.error((Object)e);
                }
            }
        }

        protected boolean merge(HRegionInfo[] info) throws IOException {
            if (info.length < 2) {
                LOG.info((Object)"only one region - nothing to merge");
                return false;
            }
            HRegion currentRegion = null;
            long currentSize = 0L;
            HRegion nextRegion = null;
            long nextSize = 0L;
            for (int i = 0; i < info.length - 1; ++i) {
                if (currentRegion == null) {
                    currentRegion = HRegion.openHRegion(this.conf, this.fs, this.rootDir, info[i], this.htd, this.hlog);
                    currentSize = currentRegion.getLargestHStoreSize();
                }
                if (currentSize + (nextSize = (nextRegion = HRegion.openHRegion(this.conf, this.fs, this.rootDir, info[i + 1], this.htd, this.hlog)).getLargestHStoreSize()) <= this.maxFilesize / 2L) {
                    LOG.info((Object)("Merging regions " + currentRegion.getRegionNameAsString() + " and " + nextRegion.getRegionNameAsString()));
                    HRegion mergedRegion = HRegion.mergeAdjacent(currentRegion, nextRegion);
                    this.updateMeta(currentRegion.getRegionName(), nextRegion.getRegionName(), mergedRegion);
                    break;
                }
                LOG.info((Object)("not merging regions " + Bytes.toStringBinary((byte[])currentRegion.getRegionName()) + " and " + Bytes.toStringBinary((byte[])nextRegion.getRegionName())));
                currentRegion.close();
                currentRegion = nextRegion;
                currentSize = nextSize;
            }
            if (currentRegion != null) {
                currentRegion.close();
            }
            return true;
        }

        protected abstract HRegionInfo[] next() throws IOException;

        protected abstract void updateMeta(byte[] var1, byte[] var2, HRegion var3) throws IOException;
    }
}

