/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import jsr166y.LinkedTransferQueue;

public class BoundedLinkedTransferQueue<E>
extends LinkedTransferQueue<E> {
    private static final long serialVersionUID = -1875525368357897907L;
    private AtomicInteger size = new AtomicInteger();
    private final int maxQueueSize;
    private final ReentrantLock lock = new ReentrantLock();

    public BoundedLinkedTransferQueue(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public int remainingCapacity() {
        return this.maxQueueSize - this.size.get();
    }

    @Override
    public E poll() {
        Object result = super.poll();
        if (result != null) {
            this.size.decrementAndGet();
        }
        return result;
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        Object result = super.poll(timeout, unit);
        if (result != null) {
            this.size.decrementAndGet();
        }
        return result;
    }

    @Override
    public boolean tryTransfer(E e) {
        boolean result = super.tryTransfer(e);
        if (result) {
            this.size.incrementAndGet();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        boolean result = false;
        this.lock.lock();
        try {
            if (this.size.get() < this.maxQueueSize) {
                super.put(e);
                this.size.incrementAndGet();
                result = true;
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    @Override
    public void put(E e) {
        throw new UnsupportedOperationException();
    }
}

