/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.MessageLite;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.util.Threads;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.DatagramChannel;
import org.jboss.netty.channel.socket.oio.OioDatagramChannelFactory;
import org.jboss.netty.handler.codec.protobuf.ProtobufDecoder;

@InterfaceAudience.Private
class ClusterStatusListener
implements Closeable {
    private static final Log LOG = LogFactory.getLog(ClusterStatusListener.class);
    private final List<ServerName> deadServers = new ArrayList<ServerName>();
    protected final DeadServerHandler deadServerHandler;
    private final Listener listener;
    public static final String STATUS_LISTENER_CLASS = "hbase.status.listener.class";
    public static final Class<? extends Listener> DEFAULT_STATUS_LISTENER_CLASS = MulticastListener.class;

    public ClusterStatusListener(DeadServerHandler dsh, Configuration conf, Class<? extends Listener> listenerClass) throws IOException {
        this.deadServerHandler = dsh;
        try {
            Constructor<? extends Listener> ctor = listenerClass.getConstructor(ClusterStatusListener.class);
            this.listener = ctor.newInstance(this);
        }
        catch (InstantiationException e) {
            throw new IOException("Can't create listener " + listenerClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Can't create listener " + listenerClass.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException();
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException();
        }
        this.listener.connect(conf);
    }

    public void receive(ClusterStatus ncs) {
        if (ncs.getDeadServerNames() != null) {
            for (ServerName sn : ncs.getDeadServerNames()) {
                if (this.isDeadServer(sn)) continue;
                LOG.info((Object)("There is a new dead server: " + sn));
                this.deadServers.add(sn);
                if (this.deadServerHandler == null) continue;
                this.deadServerHandler.newDead(sn);
            }
        }
    }

    @Override
    public void close() {
        this.listener.close();
    }

    public boolean isDeadServer(ServerName sn) {
        if (sn.getStartcode() <= 0L) {
            return false;
        }
        for (ServerName dead : this.deadServers) {
            if (dead.getStartcode() < sn.getStartcode() || dead.getPort() != sn.getPort() || !dead.getHostname().equals(sn.getHostname())) continue;
            return true;
        }
        return false;
    }

    class MulticastListener
    implements Listener {
        private DatagramChannel channel;
        private final ExecutorService service = Executors.newSingleThreadExecutor(Threads.newDaemonThreadFactory((String)"hbase-client-clusterStatus-multiCastListener"));

        @Override
        public void connect(Configuration conf) throws IOException {
            InetAddress ina;
            OioDatagramChannelFactory f = new OioDatagramChannelFactory((Executor)this.service);
            ConnectionlessBootstrap b = new ConnectionlessBootstrap((ChannelFactory)f);
            b.setPipeline(Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new ProtobufDecoder((MessageLite)ClusterStatusProtos.ClusterStatus.getDefaultInstance()), new ClusterStatusHandler()}));
            String mcAddress = conf.get("hbase.status.multicast.address.ip", "226.1.1.3");
            String bindAddress = conf.get("hbase.status.multicast.bind.address.ip", "0.0.0.0");
            int port = conf.getInt("hbase.status.multicast.port", 60100);
            this.channel = (DatagramChannel)b.bind((SocketAddress)new InetSocketAddress(bindAddress, port));
            this.channel.getConfig().setReuseAddress(true);
            try {
                ina = InetAddress.getByName(mcAddress);
            }
            catch (UnknownHostException e) {
                throw new IOException("Can't connect to " + mcAddress, e);
            }
            this.channel.joinGroup(ina);
        }

        @Override
        public void close() {
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
            this.service.shutdown();
        }

        private class ClusterStatusHandler
        extends SimpleChannelUpstreamHandler {
            private ClusterStatusHandler() {
            }

            public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
                ClusterStatusProtos.ClusterStatus csp = (ClusterStatusProtos.ClusterStatus)e.getMessage();
                ClusterStatus ncs = ClusterStatus.convert(csp);
                ClusterStatusListener.this.receive(ncs);
            }

            public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
                LOG.error((Object)"Unexpected exception, continuing.", e.getCause());
            }
        }
    }

    static interface Listener
    extends Closeable {
        @Override
        public void close();

        public void connect(Configuration var1) throws IOException;
    }

    public static interface DeadServerHandler {
        public void newDead(ServerName var1);
    }
}

