/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.crunch.Source;
import org.apache.crunch.SourceTarget;
import org.apache.hadoop.conf.Configuration;

public class ParallelDoOptions {
    private final Set<SourceTarget<?>> sourceTargets;
    private final Map<String, String> extraConf;

    private ParallelDoOptions(Set<SourceTarget<?>> sourceTargets, Map<String, String> extraConf) {
        this.sourceTargets = sourceTargets;
        this.extraConf = extraConf;
    }

    public Set<SourceTarget<?>> getSourceTargets() {
        return this.sourceTargets;
    }

    public void configure(Configuration conf) {
        for (Map.Entry<String, String> e : this.extraConf.entrySet()) {
            conf.set(e.getKey(), e.getValue());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Set<SourceTarget<?>> sourceTargets = Sets.newHashSet();
        private Map<String, String> extraConf = Maps.newHashMap();

        public Builder sources(Source<?> ... sources) {
            return this.sources(Arrays.asList(sources));
        }

        public Builder sources(Collection<Source<?>> sources) {
            for (Source<?> src : sources) {
                if (!(src instanceof SourceTarget)) continue;
                this.sourceTargets.add((SourceTarget)src);
            }
            return this;
        }

        public Builder sourceTargets(SourceTarget<?> ... sourceTargets) {
            Collections.addAll(this.sourceTargets, sourceTargets);
            return this;
        }

        public Builder sourceTargets(Collection<SourceTarget<?>> sourceTargets) {
            this.sourceTargets.addAll(sourceTargets);
            return this;
        }

        public Builder conf(String confKey, String confValue) {
            this.extraConf.put(confKey, confValue);
            return this;
        }

        public ParallelDoOptions build() {
            return new ParallelDoOptions(this.sourceTargets, this.extraConf);
        }
    }
}

