/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch;

import java.util.Collection;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.crunch.MapFn;
import org.apache.crunch.Tuple;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.PTypeFamily;

public class Tuple4<V1, V2, V3, V4>
implements Tuple {
    private final V1 first;
    private final V2 second;
    private final V3 third;
    private final V4 fourth;

    public static <A, B, C, D> Tuple4<A, B, C, D> of(A a, B b, C c, D d) {
        return new Tuple4<A, B, C, D>(a, b, c, d);
    }

    public Tuple4(V1 first, V2 second, V3 third, V4 fourth) {
        this.first = first;
        this.second = second;
        this.third = third;
        this.fourth = fourth;
    }

    public V1 first() {
        return this.first;
    }

    public V2 second() {
        return this.second;
    }

    public V3 third() {
        return this.third;
    }

    public V4 fourth() {
        return this.fourth;
    }

    @Override
    public Object get(int index) {
        switch (index) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
            case 2: {
                return this.third;
            }
            case 3: {
                return this.fourth;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int size() {
        return 4;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        return hcb.append(this.first).append(this.second).append(this.third).append(this.fourth).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple4 other = (Tuple4)obj;
        return (this.first == other.first || this.first != null && this.first.equals(other.first)) && (this.second == other.second || this.second != null && this.second.equals(other.second)) && (this.third == other.third || this.third != null && this.third.equals(other.third)) && (this.fourth == other.fourth || this.fourth != null && this.fourth.equals(other.fourth));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Tuple4[");
        sb.append(this.first).append(",").append(this.second).append(",").append(this.third);
        return sb.append(",").append(this.fourth).append("]").toString();
    }

    public static class Collect<V1, V2, V3, V4>
    extends Tuple4<Collection<V1>, Collection<V2>, Collection<V3>, Collection<V4>> {
        public static <V1, V2, V3, V4> PType<Collect<V1, V2, V3, V4>> derived(PType<V1> first, PType<V2> second, PType<V3> third, PType<V4> fourth) {
            PTypeFamily tf = first.getFamily();
            PType<Tuple4<Collection<V1>, Collection<V2>, Collection<V3>, Collection<V4>>> pt = tf.quads(tf.collections(first), tf.collections(second), tf.collections(third), tf.collections(fourth));
            Class<Collect> clazz = Collect.class;
            return tf.derived(clazz, new MapFn<Tuple4<Collection<V1>, Collection<V2>, Collection<V3>, Collection<V4>>, Collect<V1, V2, V3, V4>>(){

                @Override
                public Collect<V1, V2, V3, V4> map(Tuple4<Collection<V1>, Collection<V2>, Collection<V3>, Collection<V4>> in) {
                    return new Collect(in.first(), in.second(), in.third(), in.fourth());
                }
            }, new MapFn<Collect<V1, V2, V3, V4>, Tuple4<Collection<V1>, Collection<V2>, Collection<V3>, Collection<V4>>>(){

                @Override
                public Tuple4<Collection<V1>, Collection<V2>, Collection<V3>, Collection<V4>> map(Collect<V1, V2, V3, V4> input) {
                    return input;
                }
            }, pt);
        }

        public Collect(Collection<V1> first, Collection<V2> second, Collection<V3> third, Collection<V4> fourth) {
            super(first, second, third, fourth);
        }
    }
}

