/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.fn;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.crunch.Aggregator;
import org.apache.crunch.CombineFn;
import org.apache.crunch.Emitter;
import org.apache.crunch.Pair;
import org.apache.crunch.Tuple;
import org.apache.crunch.Tuple3;
import org.apache.crunch.Tuple4;
import org.apache.crunch.TupleN;
import org.apache.crunch.util.Tuples;
import org.apache.hadoop.conf.Configuration;

public final class Aggregators {
    private Aggregators() {
    }

    public static Aggregator<Long> SUM_LONGS() {
        return new SumLongs();
    }

    public static Aggregator<Integer> SUM_INTS() {
        return new SumInts();
    }

    public static Aggregator<Float> SUM_FLOATS() {
        return new SumFloats();
    }

    public static Aggregator<Double> SUM_DOUBLES() {
        return new SumDoubles();
    }

    public static Aggregator<BigInteger> SUM_BIGINTS() {
        return new SumBigInts();
    }

    public static Aggregator<Long> MAX_LONGS() {
        return new MaxLongs();
    }

    public static Aggregator<Long> MAX_LONGS(int n) {
        return new MaxLongs();
    }

    public static Aggregator<Integer> MAX_INTS() {
        return new MaxInts();
    }

    public static Aggregator<Integer> MAX_INTS(int n) {
        return new MaxNAggregator<Integer>(n);
    }

    public static Aggregator<Float> MAX_FLOATS() {
        return new MaxFloats();
    }

    public static Aggregator<Float> MAX_FLOATS(int n) {
        return new MaxNAggregator<Float>(n);
    }

    public static Aggregator<Double> MAX_DOUBLES() {
        return new MaxDoubles();
    }

    public static Aggregator<Double> MAX_DOUBLES(int n) {
        return new MaxNAggregator<Double>(n);
    }

    public static Aggregator<BigInteger> MAX_BIGINTS() {
        return new MaxBigInts();
    }

    public static Aggregator<BigInteger> MAX_BIGINTS(int n) {
        return new MaxNAggregator<BigInteger>(n);
    }

    public static <V extends Comparable<V>> Aggregator<V> MAX_N(int n, Class<V> cls) {
        return new MaxNAggregator(n);
    }

    public static Aggregator<Long> MIN_LONGS() {
        return new MinLongs();
    }

    public static Aggregator<Long> MIN_LONGS(int n) {
        return new MinNAggregator<Long>(n);
    }

    public static Aggregator<Integer> MIN_INTS() {
        return new MinInts();
    }

    public static Aggregator<Integer> MIN_INTS(int n) {
        return new MinNAggregator<Integer>(n);
    }

    public static Aggregator<Float> MIN_FLOATS() {
        return new MinFloats();
    }

    public static Aggregator<Float> MIN_FLOATS(int n) {
        return new MinNAggregator<Float>(n);
    }

    public static Aggregator<Double> MIN_DOUBLES() {
        return new MinDoubles();
    }

    public static Aggregator<Double> MIN_DOUBLES(int n) {
        return new MinNAggregator<Double>(n);
    }

    public static Aggregator<BigInteger> MIN_BIGINTS() {
        return new MinBigInts();
    }

    public static Aggregator<BigInteger> MIN_BIGINTS(int n) {
        return new MinNAggregator<BigInteger>(n);
    }

    public static <V extends Comparable<V>> Aggregator<V> MIN_N(int n, Class<V> cls) {
        return new MinNAggregator(n);
    }

    public static <V> Aggregator<V> FIRST_N(int n) {
        return new FirstNAggregator(n);
    }

    public static <V> Aggregator<V> LAST_N(int n) {
        return new LastNAggregator(n);
    }

    public static Aggregator<String> STRING_CONCAT(String separator, boolean skipNull) {
        return new StringConcatAggregator(separator, skipNull);
    }

    public static Aggregator<String> STRING_CONCAT(String separator, boolean skipNull, long maxOutputLength, long maxInputLength) {
        return new StringConcatAggregator(separator, skipNull, maxOutputLength, maxInputLength);
    }

    public static <V> Aggregator<V> UNIQUE_ELEMENTS() {
        return new SetAggregator();
    }

    public static <V> Aggregator<V> SAMPLE_UNIQUE_ELEMENTS(int maximumSampleSize) {
        return new SetAggregator(maximumSampleSize);
    }

    public static <V1, V2> Aggregator<Pair<V1, V2>> pairAggregator(Aggregator<V1> a1, Aggregator<V2> a2) {
        return new PairAggregator<V1, V2>(a1, a2);
    }

    public static <V1, V2, V3> Aggregator<Tuple3<V1, V2, V3>> tripAggregator(Aggregator<V1> a1, Aggregator<V2> a2, Aggregator<V3> a3) {
        return new TripAggregator<V1, V2, V3>(a1, a2, a3);
    }

    public static <V1, V2, V3, V4> Aggregator<Tuple4<V1, V2, V3, V4>> quadAggregator(Aggregator<V1> a1, Aggregator<V2> a2, Aggregator<V3> a3, Aggregator<V4> a4) {
        return new QuadAggregator<V1, V2, V3, V4>(a1, a2, a3, a4);
    }

    public static Aggregator<TupleN> tupleAggregator(Aggregator<?> ... aggregators) {
        return new TupleNAggregator(aggregators);
    }

    public static final <K, V> CombineFn<K, V> toCombineFn(Aggregator<V> aggregator) {
        return new AggregatorCombineFn(aggregator);
    }

    private static class SetAggregator<V>
    extends SimpleAggregator<V> {
        private final Set<V> elements = Sets.newHashSet();
        private final int sizeLimit;

        public SetAggregator() {
            this(-1);
        }

        public SetAggregator(int sizeLimit) {
            this.sizeLimit = sizeLimit;
        }

        @Override
        public void reset() {
            this.elements.clear();
        }

        @Override
        public void update(V value) {
            if (this.sizeLimit == -1 || this.elements.size() < this.sizeLimit) {
                this.elements.add(value);
            }
        }

        @Override
        public Iterable<V> results() {
            return ImmutableList.copyOf(this.elements);
        }
    }

    private static class TupleNAggregator
    extends TupleAggregator<TupleN> {
        private final int size;

        public TupleNAggregator(Aggregator<?> ... aggregators) {
            super(aggregators);
            this.size = aggregators.length;
        }

        @Override
        public void update(TupleN value) {
            this.updateTuple(value);
        }

        @Override
        public Iterable<TupleN> results() {
            Iterable[] iterables = new Iterable[this.size];
            for (int i = 0; i < this.size; ++i) {
                iterables[i] = this.results(i);
            }
            return new Tuples.TupleNIterable(iterables);
        }
    }

    private static class QuadAggregator<A, B, C, D>
    extends TupleAggregator<Tuple4<A, B, C, D>> {
        public QuadAggregator(Aggregator<A> a1, Aggregator<B> a2, Aggregator<C> a3, Aggregator<D> a4) {
            super(a1, a2, a3, a4);
        }

        @Override
        public void update(Tuple4<A, B, C, D> value) {
            this.updateTuple(value);
        }

        @Override
        public Iterable<Tuple4<A, B, C, D>> results() {
            return new Tuples.QuadIterable<Object, Object, Object, Object>(this.results(0), this.results(1), this.results(2), this.results(3));
        }
    }

    private static class TripAggregator<A, B, C>
    extends TupleAggregator<Tuple3<A, B, C>> {
        public TripAggregator(Aggregator<A> a1, Aggregator<B> a2, Aggregator<C> a3) {
            super(a1, a2, a3);
        }

        @Override
        public void update(Tuple3<A, B, C> value) {
            this.updateTuple(value);
        }

        @Override
        public Iterable<Tuple3<A, B, C>> results() {
            return new Tuples.TripIterable<Object, Object, Object>(this.results(0), this.results(1), this.results(2));
        }
    }

    private static class PairAggregator<V1, V2>
    extends TupleAggregator<Pair<V1, V2>> {
        public PairAggregator(Aggregator<V1> a1, Aggregator<V2> a2) {
            super(a1, a2);
        }

        @Override
        public void update(Pair<V1, V2> value) {
            this.updateTuple(value);
        }

        @Override
        public Iterable<Pair<V1, V2>> results() {
            return new Tuples.PairIterable<Object, Object>(this.results(0), this.results(1));
        }
    }

    private static abstract class TupleAggregator<T>
    implements Aggregator<T> {
        private final List<Aggregator<Object>> aggregators = Lists.newArrayList();

        public TupleAggregator(Aggregator<?> ... aggregators) {
            for (Aggregator<?> a : aggregators) {
                this.aggregators.add(a);
            }
        }

        @Override
        public void initialize(Configuration configuration) {
            for (Aggregator<Object> a : this.aggregators) {
                a.initialize(configuration);
            }
        }

        @Override
        public void reset() {
            for (Aggregator<Object> a : this.aggregators) {
                a.reset();
            }
        }

        protected void updateTuple(Tuple t) {
            for (int i = 0; i < this.aggregators.size(); ++i) {
                this.aggregators.get(i).update(t.get(i));
            }
        }

        protected Iterable<Object> results(int index) {
            return this.aggregators.get(index).results();
        }
    }

    private static class StringConcatAggregator
    extends SimpleAggregator<String> {
        private final String separator;
        private final boolean skipNulls;
        private final long maxOutputLength;
        private final long maxInputLength;
        private long currentLength;
        private final LinkedList<String> list = new LinkedList();
        private transient Joiner joiner;

        public StringConcatAggregator(String separator, boolean skipNulls) {
            this.separator = separator;
            this.skipNulls = skipNulls;
            this.maxInputLength = 0L;
            this.maxOutputLength = 0L;
        }

        public StringConcatAggregator(String separator, boolean skipNull, long maxOutputLength, long maxInputLength) {
            this.separator = separator;
            this.skipNulls = skipNull;
            this.maxOutputLength = maxOutputLength;
            this.maxInputLength = maxInputLength;
            this.currentLength = -separator.length();
        }

        @Override
        public void reset() {
            if (this.joiner == null) {
                this.joiner = this.skipNulls ? Joiner.on((String)this.separator).skipNulls() : Joiner.on((String)this.separator);
            }
            this.currentLength = -this.separator.length();
            this.list.clear();
        }

        @Override
        public void update(String next) {
            long length;
            long l = length = next == null ? 0L : (long)(next.length() + this.separator.length());
            if (this.maxOutputLength > 0L && this.currentLength + length > this.maxOutputLength || this.maxInputLength > 0L && (long)next.length() > this.maxInputLength) {
                return;
            }
            if (this.maxOutputLength > 0L) {
                this.currentLength += length;
            }
            this.list.add(next);
        }

        @Override
        public Iterable<String> results() {
            return ImmutableList.of((Object)this.joiner.join(this.list));
        }
    }

    private static class LastNAggregator<V>
    extends SimpleAggregator<V> {
        private final int arity;
        private final LinkedList<V> elements;

        public LastNAggregator(int arity) {
            this.arity = arity;
            this.elements = Lists.newLinkedList();
        }

        @Override
        public void reset() {
            this.elements.clear();
        }

        @Override
        public void update(V value) {
            this.elements.add(value);
            if (this.elements.size() == this.arity + 1) {
                this.elements.removeFirst();
            }
        }

        @Override
        public Iterable<V> results() {
            return ImmutableList.copyOf(this.elements);
        }
    }

    private static class FirstNAggregator<V>
    extends SimpleAggregator<V> {
        private final int arity;
        private final List<V> elements;

        public FirstNAggregator(int arity) {
            this.arity = arity;
            this.elements = Lists.newArrayList();
        }

        @Override
        public void reset() {
            this.elements.clear();
        }

        @Override
        public void update(V value) {
            if (this.elements.size() < this.arity) {
                this.elements.add(value);
            }
        }

        @Override
        public Iterable<V> results() {
            return ImmutableList.copyOf(this.elements);
        }
    }

    private static class MinNAggregator<V extends Comparable<V>>
    extends SimpleAggregator<V> {
        private final int arity;
        private transient SortedSet<V> elements;

        public MinNAggregator(int arity) {
            this.arity = arity;
        }

        @Override
        public void reset() {
            if (this.elements == null) {
                this.elements = Sets.newTreeSet();
            } else {
                this.elements.clear();
            }
        }

        @Override
        public void update(V value) {
            if (this.elements.size() < this.arity) {
                this.elements.add(value);
            } else if (value.compareTo(this.elements.last()) < 0) {
                this.elements.remove(this.elements.last());
                this.elements.add(value);
            }
        }

        @Override
        public Iterable<V> results() {
            return ImmutableList.copyOf(this.elements);
        }
    }

    private static class MaxNAggregator<V extends Comparable<V>>
    extends SimpleAggregator<V> {
        private final int arity;
        private transient SortedSet<V> elements;

        public MaxNAggregator(int arity) {
            this.arity = arity;
        }

        @Override
        public void reset() {
            if (this.elements == null) {
                this.elements = Sets.newTreeSet();
            } else {
                this.elements.clear();
            }
        }

        @Override
        public void update(V value) {
            if (this.elements.size() < this.arity) {
                this.elements.add(value);
            } else if (value.compareTo(this.elements.first()) > 0) {
                this.elements.remove(this.elements.first());
                this.elements.add(value);
            }
        }

        @Override
        public Iterable<V> results() {
            return ImmutableList.copyOf(this.elements);
        }
    }

    private static class MinBigInts
    extends SimpleAggregator<BigInteger> {
        private BigInteger min = null;

        private MinBigInts() {
        }

        @Override
        public void reset() {
            this.min = null;
        }

        @Override
        public void update(BigInteger next) {
            if (this.min == null || this.min.compareTo(next) > 0) {
                this.min = next;
            }
        }

        @Override
        public Iterable<BigInteger> results() {
            return ImmutableList.of((Object)this.min);
        }
    }

    private static class MinDoubles
    extends SimpleAggregator<Double> {
        private Double min = null;

        private MinDoubles() {
        }

        @Override
        public void reset() {
            this.min = null;
        }

        @Override
        public void update(Double next) {
            if (this.min == null || this.min > next) {
                this.min = next;
            }
        }

        @Override
        public Iterable<Double> results() {
            return ImmutableList.of((Object)this.min);
        }
    }

    private static class MinFloats
    extends SimpleAggregator<Float> {
        private Float min = null;

        private MinFloats() {
        }

        @Override
        public void reset() {
            this.min = null;
        }

        @Override
        public void update(Float next) {
            if (this.min == null || this.min.floatValue() > next.floatValue()) {
                this.min = next;
            }
        }

        @Override
        public Iterable<Float> results() {
            return ImmutableList.of((Object)this.min);
        }
    }

    private static class MinInts
    extends SimpleAggregator<Integer> {
        private Integer min = null;

        private MinInts() {
        }

        @Override
        public void reset() {
            this.min = null;
        }

        @Override
        public void update(Integer next) {
            if (this.min == null || this.min > next) {
                this.min = next;
            }
        }

        @Override
        public Iterable<Integer> results() {
            return ImmutableList.of((Object)this.min);
        }
    }

    private static class MinLongs
    extends SimpleAggregator<Long> {
        private Long min = null;

        private MinLongs() {
        }

        @Override
        public void reset() {
            this.min = null;
        }

        @Override
        public void update(Long next) {
            if (this.min == null || this.min > next) {
                this.min = next;
            }
        }

        @Override
        public Iterable<Long> results() {
            return ImmutableList.of((Object)this.min);
        }
    }

    private static class MaxBigInts
    extends SimpleAggregator<BigInteger> {
        private BigInteger max = null;

        private MaxBigInts() {
        }

        @Override
        public void reset() {
            this.max = null;
        }

        @Override
        public void update(BigInteger next) {
            if (this.max == null || this.max.compareTo(next) < 0) {
                this.max = next;
            }
        }

        @Override
        public Iterable<BigInteger> results() {
            return ImmutableList.of((Object)this.max);
        }
    }

    private static class MaxDoubles
    extends SimpleAggregator<Double> {
        private Double max = null;

        private MaxDoubles() {
        }

        @Override
        public void reset() {
            this.max = null;
        }

        @Override
        public void update(Double next) {
            if (this.max == null || this.max < next) {
                this.max = next;
            }
        }

        @Override
        public Iterable<Double> results() {
            return ImmutableList.of((Object)this.max);
        }
    }

    private static class MaxFloats
    extends SimpleAggregator<Float> {
        private Float max = null;

        private MaxFloats() {
        }

        @Override
        public void reset() {
            this.max = null;
        }

        @Override
        public void update(Float next) {
            if (this.max == null || this.max.floatValue() < next.floatValue()) {
                this.max = next;
            }
        }

        @Override
        public Iterable<Float> results() {
            return ImmutableList.of((Object)this.max);
        }
    }

    private static class MaxInts
    extends SimpleAggregator<Integer> {
        private Integer max = null;

        private MaxInts() {
        }

        @Override
        public void reset() {
            this.max = null;
        }

        @Override
        public void update(Integer next) {
            if (this.max == null || this.max < next) {
                this.max = next;
            }
        }

        @Override
        public Iterable<Integer> results() {
            return ImmutableList.of((Object)this.max);
        }
    }

    private static class MaxLongs
    extends SimpleAggregator<Long> {
        private Long max = null;

        private MaxLongs() {
        }

        @Override
        public void reset() {
            this.max = null;
        }

        @Override
        public void update(Long next) {
            if (this.max == null || this.max < next) {
                this.max = next;
            }
        }

        @Override
        public Iterable<Long> results() {
            return ImmutableList.of((Object)this.max);
        }
    }

    private static class SumBigInts
    extends SimpleAggregator<BigInteger> {
        private BigInteger sum = BigInteger.ZERO;

        private SumBigInts() {
        }

        @Override
        public void reset() {
            this.sum = BigInteger.ZERO;
        }

        @Override
        public void update(BigInteger next) {
            this.sum = this.sum.add(next);
        }

        @Override
        public Iterable<BigInteger> results() {
            return ImmutableList.of((Object)this.sum);
        }
    }

    private static class SumDoubles
    extends SimpleAggregator<Double> {
        private double sum = 0.0;

        private SumDoubles() {
        }

        @Override
        public void reset() {
            this.sum = 0.0;
        }

        @Override
        public void update(Double next) {
            this.sum += next.doubleValue();
        }

        @Override
        public Iterable<Double> results() {
            return ImmutableList.of((Object)this.sum);
        }
    }

    private static class SumFloats
    extends SimpleAggregator<Float> {
        private float sum = 0.0f;

        private SumFloats() {
        }

        @Override
        public void reset() {
            this.sum = 0.0f;
        }

        @Override
        public void update(Float next) {
            this.sum += next.floatValue();
        }

        @Override
        public Iterable<Float> results() {
            return ImmutableList.of((Object)Float.valueOf(this.sum));
        }
    }

    private static class SumInts
    extends SimpleAggregator<Integer> {
        private int sum = 0;

        private SumInts() {
        }

        @Override
        public void reset() {
            this.sum = 0;
        }

        @Override
        public void update(Integer next) {
            this.sum += next.intValue();
        }

        @Override
        public Iterable<Integer> results() {
            return ImmutableList.of((Object)this.sum);
        }
    }

    private static class SumLongs
    extends SimpleAggregator<Long> {
        private long sum = 0L;

        private SumLongs() {
        }

        @Override
        public void reset() {
            this.sum = 0L;
        }

        @Override
        public void update(Long next) {
            this.sum += next.longValue();
        }

        @Override
        public Iterable<Long> results() {
            return ImmutableList.of((Object)this.sum);
        }
    }

    private static class AggregatorCombineFn<K, V>
    extends CombineFn<K, V> {
        private final Aggregator<V> aggregator;

        public AggregatorCombineFn(Aggregator<V> aggregator) {
            this.aggregator = aggregator;
        }

        @Override
        public void initialize() {
            this.aggregator.initialize(this.getConfiguration());
        }

        @Override
        public void process(Pair<K, Iterable<V>> input, Emitter<Pair<K, V>> emitter) {
            this.aggregator.reset();
            for (V v : input.second()) {
                this.aggregator.update(v);
            }
            for (V v : this.aggregator.results()) {
                emitter.emit(Pair.of(input.first(), v));
            }
        }
    }

    public static abstract class SimpleAggregator<T>
    implements Aggregator<T> {
        @Override
        public void initialize(Configuration conf) {
        }
    }
}

