/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.hadoop.mapreduce;

import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;

public class TaskAttemptContextFactory {
    private static final Log LOG = LogFactory.getLog(TaskAttemptContextFactory.class);
    private static final TaskAttemptContextFactory INSTANCE = new TaskAttemptContextFactory();
    private Constructor<TaskAttemptContext> taskAttemptConstructor;

    public static TaskAttemptContext create(Configuration conf, TaskAttemptID taskAttemptId) {
        return INSTANCE.createInternal(conf, taskAttemptId);
    }

    private TaskAttemptContextFactory() {
        Class implClass = TaskAttemptContext.class;
        if (implClass.isInterface()) {
            try {
                implClass = Class.forName("org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl");
            }
            catch (ClassNotFoundException e) {
                LOG.fatal((Object)"Could not find TaskAttemptContextImpl class, exiting", (Throwable)e);
            }
        }
        try {
            this.taskAttemptConstructor = implClass.getConstructor(Configuration.class, TaskAttemptID.class);
        }
        catch (Exception e) {
            LOG.fatal((Object)"Could not access TaskAttemptContext constructor, exiting", (Throwable)e);
        }
    }

    private TaskAttemptContext createInternal(Configuration conf, TaskAttemptID taskAttemptId) {
        try {
            return this.taskAttemptConstructor.newInstance(conf, taskAttemptId);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not construct a TaskAttemptContext instance", (Throwable)e);
            return null;
        }
    }
}

