/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.hadoop.mapreduce.lib.jobcontrol;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.hadoop.mapreduce.lib.jobcontrol.CrunchControlledJob;
import org.apache.crunch.impl.mr.MRJob;
import org.apache.hadoop.conf.Configuration;

public class CrunchJobControl {
    private Map<Integer, CrunchControlledJob> waitingJobs;
    private Map<Integer, CrunchControlledJob> readyJobs;
    private Map<Integer, CrunchControlledJob> runningJobs;
    private Map<Integer, CrunchControlledJob> successfulJobs;
    private Map<Integer, CrunchControlledJob> failedJobs;
    private Log log = LogFactory.getLog(CrunchJobControl.class);
    private final String groupName;
    private final int maxRunningJobs;
    private int jobSequence = 1;

    public CrunchJobControl(Configuration conf, String groupName) {
        this.waitingJobs = new Hashtable<Integer, CrunchControlledJob>();
        this.readyJobs = new Hashtable<Integer, CrunchControlledJob>();
        this.runningJobs = new Hashtable<Integer, CrunchControlledJob>();
        this.successfulJobs = new Hashtable<Integer, CrunchControlledJob>();
        this.failedJobs = new Hashtable<Integer, CrunchControlledJob>();
        this.groupName = groupName;
        this.maxRunningJobs = conf.getInt("crunch.max.running.jobs", 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<CrunchControlledJob> toList(Map<Integer, CrunchControlledJob> jobs) {
        ArrayList<CrunchControlledJob> retv = new ArrayList<CrunchControlledJob>();
        Map<Integer, CrunchControlledJob> map = jobs;
        synchronized (map) {
            for (CrunchControlledJob job : jobs.values()) {
                retv.add(job);
            }
        }
        return retv;
    }

    public List<CrunchControlledJob> getWaitingJobList() {
        return CrunchJobControl.toList(this.waitingJobs);
    }

    public List<CrunchControlledJob> getRunningJobList() {
        return CrunchJobControl.toList(this.runningJobs);
    }

    public List<CrunchControlledJob> getReadyJobsList() {
        return CrunchJobControl.toList(this.readyJobs);
    }

    public List<CrunchControlledJob> getSuccessfulJobList() {
        return CrunchJobControl.toList(this.successfulJobs);
    }

    public List<CrunchControlledJob> getFailedJobList() {
        return CrunchJobControl.toList(this.failedJobs);
    }

    public synchronized List<CrunchControlledJob> getAllJobs() {
        return ImmutableList.builder().addAll(this.waitingJobs.values()).addAll(this.readyJobs.values()).addAll(this.runningJobs.values()).addAll(this.successfulJobs.values()).addAll(this.failedJobs.values()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToQueue(CrunchControlledJob aJob, Map<Integer, CrunchControlledJob> queue) {
        Map<Integer, CrunchControlledJob> map = queue;
        synchronized (map) {
            queue.put(aJob.getJobID(), aJob);
        }
    }

    private void addToQueue(CrunchControlledJob aJob) {
        Map<Integer, CrunchControlledJob> queue = this.getQueue(aJob.getJobState());
        CrunchJobControl.addToQueue(aJob, queue);
    }

    private Map<Integer, CrunchControlledJob> getQueue(MRJob.State state) {
        Map<Integer, CrunchControlledJob> retv = null;
        if (state == MRJob.State.WAITING) {
            retv = this.waitingJobs;
        } else if (state == MRJob.State.READY) {
            retv = this.readyJobs;
        } else if (state == MRJob.State.RUNNING) {
            retv = this.runningJobs;
        } else if (state == MRJob.State.SUCCESS) {
            retv = this.successfulJobs;
        } else if (state == MRJob.State.FAILED || state == MRJob.State.DEPENDENT_FAILED) {
            retv = this.failedJobs;
        }
        return retv;
    }

    public synchronized void addJob(CrunchControlledJob aJob) {
        aJob.setJobState(MRJob.State.WAITING);
        this.addToQueue(aJob);
    }

    private synchronized void checkRunningJobs() throws IOException, InterruptedException {
        Map<Integer, CrunchControlledJob> oldJobs = null;
        oldJobs = this.runningJobs;
        this.runningJobs = new Hashtable<Integer, CrunchControlledJob>();
        for (CrunchControlledJob nextJob : oldJobs.values()) {
            nextJob.checkState();
            this.addToQueue(nextJob);
        }
    }

    private synchronized void checkWaitingJobs() throws IOException, InterruptedException {
        Map<Integer, CrunchControlledJob> oldJobs = null;
        oldJobs = this.waitingJobs;
        this.waitingJobs = new Hashtable<Integer, CrunchControlledJob>();
        for (CrunchControlledJob nextJob : oldJobs.values()) {
            nextJob.checkState();
            this.addToQueue(nextJob);
        }
    }

    private synchronized void startReadyJobs() {
        Map<Integer, CrunchControlledJob> oldJobs = null;
        oldJobs = this.readyJobs;
        this.readyJobs = new Hashtable<Integer, CrunchControlledJob>();
        for (CrunchControlledJob nextJob : oldJobs.values()) {
            if (this.runningJobs.size() < this.maxRunningJobs) {
                nextJob.setJobSequence(this.jobSequence);
                ++this.jobSequence;
                nextJob.submit();
            }
            this.addToQueue(nextJob);
        }
    }

    public synchronized void killAllRunningJobs() {
        for (CrunchControlledJob job : this.runningJobs.values()) {
            if (job.isCompleted()) continue;
            try {
                job.killJob();
            }
            catch (Exception e) {
                this.log.error((Object)("Exception killing job: " + job.getJobName()), (Throwable)e);
            }
        }
    }

    public synchronized boolean allFinished() {
        return this.waitingJobs.size() == 0 && this.readyJobs.size() == 0 && this.runningJobs.size() == 0;
    }

    public synchronized boolean anyFailures() {
        return this.failedJobs.size() > 0;
    }

    public void pollJobStatusAndStartNewOnes() throws IOException, InterruptedException {
        this.checkRunningJobs();
        this.checkWaitingJobs();
        this.startReadyJobs();
    }
}

