/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.dist.collect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.crunch.Aggregator;
import org.apache.crunch.CombineFn;
import org.apache.crunch.DoFn;
import org.apache.crunch.Emitter;
import org.apache.crunch.GroupingOptions;
import org.apache.crunch.MapFn;
import org.apache.crunch.PGroupedTable;
import org.apache.crunch.PTable;
import org.apache.crunch.Pair;
import org.apache.crunch.ReadableData;
import org.apache.crunch.SourceTarget;
import org.apache.crunch.fn.Aggregators;
import org.apache.crunch.impl.dist.collect.PCollectionImpl;
import org.apache.crunch.impl.dist.collect.PTableBase;
import org.apache.crunch.lib.PTables;
import org.apache.crunch.types.PGroupedTableType;
import org.apache.crunch.types.PType;

public class BaseGroupedTable<K, V>
extends PCollectionImpl<Pair<K, Iterable<V>>>
implements PGroupedTable<K, V> {
    protected final PTableBase<K, V> parent;
    protected final GroupingOptions groupingOptions;
    protected final PGroupedTableType<K, V> ptype;

    protected BaseGroupedTable(PTableBase<K, V> parent) {
        this(parent, null);
    }

    protected BaseGroupedTable(PTableBase<K, V> parent, GroupingOptions groupingOptions) {
        super("GBK", parent.getPipeline());
        this.parent = parent;
        this.groupingOptions = groupingOptions;
        this.ptype = parent.getPTableType().getGroupedTableType();
    }

    @Override
    protected ReadableData<Pair<K, Iterable<V>>> getReadableDataInternal() {
        throw new UnsupportedOperationException("PGroupedTable does not currently support readability");
    }

    @Override
    protected long getSizeInternal() {
        return this.parent.getSizeInternal();
    }

    @Override
    public PType<Pair<K, Iterable<V>>> getPType() {
        return this.ptype;
    }

    @Override
    public PTable<K, V> combineValues(CombineFn<K, V> combineFn, CombineFn<K, V> reduceFn) {
        return this.pipeline.getFactory().createDoTable("combine", this.getChainingCollection(), combineFn, reduceFn, this.parent.getPTableType());
    }

    @Override
    public PTable<K, V> combineValues(CombineFn<K, V> combineFn) {
        return this.combineValues(combineFn, combineFn);
    }

    @Override
    public PTable<K, V> combineValues(Aggregator<V> agg) {
        return this.combineValues(Aggregators.toCombineFn(agg));
    }

    @Override
    public PTable<K, V> combineValues(Aggregator<V> combineAgg, Aggregator<V> reduceAgg) {
        return this.combineValues(Aggregators.toCombineFn(combineAgg), Aggregators.toCombineFn(reduceAgg));
    }

    @Override
    public PTable<K, V> ungroup() {
        return this.parallelDo("ungroup", new Ungroup(), this.parent.getPTableType());
    }

    @Override
    public <U> PTable<K, U> mapValues(MapFn<Iterable<V>, U> mapFn, PType<U> ptype) {
        return PTables.mapValues(this, mapFn, ptype);
    }

    @Override
    public <U> PTable<K, U> mapValues(String name, MapFn<Iterable<V>, U> mapFn, PType<U> ptype) {
        return PTables.mapValues(name, this, mapFn, ptype);
    }

    @Override
    public PGroupedTableType<K, V> getGroupedTableType() {
        return this.ptype;
    }

    @Override
    public Set<SourceTarget<?>> getTargetDependencies() {
        HashSet td = Sets.newHashSet(super.getTargetDependencies());
        if (this.groupingOptions != null) {
            td.addAll(this.groupingOptions.getSourceTargets());
        }
        return ImmutableSet.copyOf((Collection)td);
    }

    @Override
    public List<PCollectionImpl<?>> getParents() {
        return ImmutableList.of(this.parent);
    }

    @Override
    public long getLastModifiedAt() {
        return this.parent.getLastModifiedAt();
    }

    @Override
    protected void acceptInternal(PCollectionImpl.Visitor visitor) {
        visitor.visitGroupedTable(this);
    }

    @Override
    protected PCollectionImpl<Pair<K, Iterable<V>>> getChainingCollection() {
        return this.pipeline.getFactory().createGroupedTable(this.parent, this.groupingOptions);
    }

    private static class Ungroup<K, V>
    extends DoFn<Pair<K, Iterable<V>>, Pair<K, V>> {
        private Ungroup() {
        }

        @Override
        public void process(Pair<K, Iterable<V>> input, Emitter<Pair<K, V>> emitter) {
            for (V v : input.second()) {
                emitter.emit(Pair.of(input.first(), v));
            }
        }
    }
}

