/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mem;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AbstractFuture;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.CachingOptions;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.PCollection;
import org.apache.crunch.PTable;
import org.apache.crunch.Pair;
import org.apache.crunch.Pipeline;
import org.apache.crunch.PipelineExecution;
import org.apache.crunch.PipelineResult;
import org.apache.crunch.Source;
import org.apache.crunch.TableSource;
import org.apache.crunch.Target;
import org.apache.crunch.impl.mem.CountersWrapper;
import org.apache.crunch.impl.mem.collect.MemCollection;
import org.apache.crunch.impl.mem.collect.MemTable;
import org.apache.crunch.io.At;
import org.apache.crunch.io.PathTarget;
import org.apache.crunch.io.ReadableSource;
import org.apache.crunch.io.avro.AvroFileTarget;
import org.apache.crunch.io.seq.SeqFileTarget;
import org.apache.crunch.types.Converter;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.avro.AvroType;
import org.apache.crunch.types.avro.Avros;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapreduce.Counters;

public class MemPipeline
implements Pipeline {
    private static final Log LOG = LogFactory.getLog(MemPipeline.class);
    private static Counters COUNTERS = new CountersWrapper();
    private static final MemPipeline INSTANCE = new MemPipeline();
    private int outputIndex = 0;
    private Configuration conf = new Configuration();
    private Set<Target> activeTargets = Sets.newHashSet();

    public static Counters getCounters() {
        return COUNTERS;
    }

    public static void clearCounters() {
        COUNTERS = new CountersWrapper();
    }

    public static Pipeline getInstance() {
        return INSTANCE;
    }

    public static <T> PCollection<T> collectionOf(T ... ts) {
        return new MemCollection(ImmutableList.copyOf((Object[])ts));
    }

    public static <T> PCollection<T> collectionOf(Iterable<T> collect) {
        return new MemCollection<T>(collect);
    }

    public static <T> PCollection<T> typedCollectionOf(PType<T> ptype, T ... ts) {
        return new MemCollection<T>(ImmutableList.copyOf((Object[])ts), ptype, null);
    }

    public static <T> PCollection<T> typedCollectionOf(PType<T> ptype, Iterable<T> collect) {
        return new MemCollection<T>(collect, ptype, null);
    }

    public static <S, T> PTable<S, T> tableOf(S s, T t, Object ... more) {
        ArrayList pairs = Lists.newArrayList();
        pairs.add(Pair.of(s, t));
        for (int i = 0; i < more.length; i += 2) {
            pairs.add(Pair.of(more[i], more[i + 1]));
        }
        return new MemTable(pairs);
    }

    public static <S, T> PTable<S, T> typedTableOf(PTableType<S, T> ptype, S s, T t, Object ... more) {
        ArrayList pairs = Lists.newArrayList();
        pairs.add(Pair.of(s, t));
        for (int i = 0; i < more.length; i += 2) {
            pairs.add(Pair.of(more[i], more[i + 1]));
        }
        return new MemTable<S, T>(pairs, ptype, null);
    }

    public static <S, T> PTable<S, T> tableOf(Iterable<Pair<S, T>> pairs) {
        return new MemTable(pairs);
    }

    public static <S, T> PTable<S, T> typedTableOf(PTableType<S, T> ptype, Iterable<Pair<S, T>> pairs) {
        return new MemTable(pairs, ptype, null);
    }

    private MemPipeline() {
    }

    @Override
    public void setConfiguration(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public <T> PCollection<T> read(Source<T> source) {
        if (source instanceof ReadableSource) {
            try {
                Iterable iterable = ((ReadableSource)source).read(this.conf);
                return new MemCollection(iterable, source.getType(), source.toString());
            }
            catch (IOException e) {
                LOG.error((Object)("Exception reading source: " + source.toString()), (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
        LOG.error((Object)("Source " + source + " is not readable"));
        throw new IllegalStateException("Source " + source + " is not readable");
    }

    @Override
    public <K, V> PTable<K, V> read(TableSource<K, V> source) {
        if (source instanceof ReadableSource) {
            try {
                Iterable iterable = ((ReadableSource)((Object)source)).read(this.conf);
                return new MemTable(iterable, source.getTableType(), source.toString());
            }
            catch (IOException e) {
                LOG.error((Object)("Exception reading source: " + source.toString()), (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
        LOG.error((Object)("Source " + source + " is not readable"));
        throw new IllegalStateException("Source " + source + " is not readable");
    }

    @Override
    public void write(PCollection<?> collection, Target target) {
        this.write(collection, target, Target.WriteMode.DEFAULT);
    }

    @Override
    public void write(PCollection<?> collection, Target target, Target.WriteMode writeMode) {
        block14: {
            target.handleExisting(writeMode, -1L, this.getConfiguration());
            if (writeMode != Target.WriteMode.APPEND && this.activeTargets.contains(target)) {
                throw new CrunchRuntimeException("Target " + target + " is already written in the current run." + " Use WriteMode.APPEND in order to write additional data to it.");
            }
            this.activeTargets.add(target);
            if (target instanceof PathTarget) {
                if (collection.getPType() != null) {
                    collection.getPType().initialize(this.getConfiguration());
                }
                Path path = ((PathTarget)target).getPath();
                try {
                    FileSystem fs = path.getFileSystem(this.conf);
                    ++this.outputIndex;
                    if (target instanceof SeqFileTarget) {
                        Path outputPath = new Path(path, "out" + this.outputIndex + ".seq");
                        if (collection instanceof PTable) {
                            this.writeSequenceFileFromPTable(fs, outputPath, (PTable)collection);
                        } else {
                            this.writeSequenceFileFromPCollection(fs, outputPath, collection);
                        }
                        break block14;
                    }
                    if (target instanceof AvroFileTarget && !(collection instanceof PTable)) {
                        Path outputPath = new Path(path, "out" + this.outputIndex + ".avro");
                        FSDataOutputStream os = fs.create(outputPath);
                        this.writeAvroFile(os, collection);
                        os.close();
                        break block14;
                    }
                    LOG.warn((Object)"Defaulting to write to a text file from MemPipeline");
                    Path outputPath = new Path(path, "out" + this.outputIndex + ".txt");
                    FSDataOutputStream os = fs.create(outputPath);
                    byte[] newLine = "\r\n".getBytes(Charsets.UTF_8);
                    if (collection instanceof PTable) {
                        byte[] tab = "\t".getBytes(Charsets.UTF_8);
                        for (Object o : collection.materialize()) {
                            Pair p = (Pair)o;
                            os.write(p.first().toString().getBytes(Charsets.UTF_8));
                            os.write(tab);
                            os.write(p.second().toString().getBytes(Charsets.UTF_8));
                            os.write(newLine);
                        }
                    } else {
                        for (Object o : collection.materialize()) {
                            os.write(o.toString().getBytes(Charsets.UTF_8));
                            os.write(newLine);
                        }
                    }
                    os.close();
                }
                catch (IOException e) {
                    LOG.error((Object)("Exception writing target: " + target), (Throwable)e);
                }
            } else {
                LOG.error((Object)("Target " + target + " is not a PathTarget instance"));
            }
        }
    }

    private void writeAvroFile(FSDataOutputStream outputStream, PCollection recordCollection) throws IOException {
        AvroType avroType = (AvroType)recordCollection.getPType();
        if (avroType == null) {
            throw new IllegalStateException("Can't write a non-typed Avro collection");
        }
        DatumWriter datumWriter = Avros.newWriter((AvroType)recordCollection.getPType());
        DataFileWriter dataFileWriter = new DataFileWriter(datumWriter);
        dataFileWriter.create(avroType.getSchema(), (OutputStream)outputStream);
        for (Object record : recordCollection.materialize()) {
            dataFileWriter.append(avroType.getOutputMapFn().map(record));
        }
        dataFileWriter.close();
        outputStream.close();
    }

    private void writeSequenceFileFromPTable(FileSystem fs, Path path, PTable table) throws IOException {
        PTableType pType = table.getPTableType();
        Class keyClass = pType.getConverter().getKeyClass();
        Class valueClass = pType.getConverter().getValueClass();
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, fs.getConf(), path, keyClass, valueClass);
        for (Object o : table.materialize()) {
            Pair p = (Pair)o;
            Object key = pType.getKeyType().getOutputMapFn().map(p.first());
            Object value = pType.getValueType().getOutputMapFn().map(p.second());
            writer.append(key, value);
        }
        writer.close();
    }

    private void writeSequenceFileFromPCollection(FileSystem fs, Path path, PCollection collection) throws IOException {
        PType pType = collection.getPType();
        Converter converter = pType.getConverter();
        Class valueClass = converter.getValueClass();
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, fs.getConf(), path, NullWritable.class, valueClass);
        for (Object o : collection.materialize()) {
            Object value = pType.getOutputMapFn().map(o);
            writer.append((Object)NullWritable.get(), value);
        }
        writer.close();
    }

    @Override
    public PCollection<String> readTextFile(String pathName) {
        return this.read(At.textFile(pathName));
    }

    @Override
    public <T> void writeTextFile(PCollection<T> collection, String pathName) {
        this.write(collection, At.textFile(pathName));
    }

    @Override
    public <T> Iterable<T> materialize(PCollection<T> pcollection) {
        return pcollection.materialize();
    }

    @Override
    public <T> void cache(PCollection<T> pcollection, CachingOptions options) {
    }

    @Override
    public <T> PCollection<T> emptyPCollection(PType<T> ptype) {
        return MemPipeline.typedCollectionOf(ptype, ImmutableList.of());
    }

    @Override
    public <K, V> PTable<K, V> emptyPTable(PTableType<K, V> ptype) {
        return MemPipeline.typedTableOf(ptype, ImmutableList.of());
    }

    @Override
    public PipelineExecution runAsync() {
        this.activeTargets.clear();
        return new MemExecution();
    }

    @Override
    public PipelineResult run() {
        try {
            return (PipelineResult)this.runAsync().get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void cleanup(boolean force) {
    }

    @Override
    public PipelineResult done() {
        return this.run();
    }

    @Override
    public void enableDebug() {
        LOG.info((Object)"Note: in-memory pipelines do not have debug logging");
    }

    @Override
    public String getName() {
        return "Memory Pipeline";
    }

    static /* synthetic */ Counters access$000() {
        return COUNTERS;
    }

    private static class MemExecution
    extends AbstractFuture<PipelineResult>
    implements PipelineExecution {
        private PipelineResult res = new PipelineResult((List<PipelineResult.StageResult>)ImmutableList.of((Object)new PipelineResult.StageResult("MemPipelineStage", MemPipeline.access$000())), PipelineExecution.Status.SUCCEEDED);

        @Override
        public String getPlanDotFile() {
            return "";
        }

        @Override
        public void waitFor(long timeout, TimeUnit timeUnit) throws InterruptedException {
            this.set(this.res);
        }

        @Override
        public void waitUntilDone() throws InterruptedException {
            this.set(this.res);
        }

        public PipelineResult get() throws ExecutionException, InterruptedException {
            this.set(this.res);
            return (PipelineResult)super.get();
        }

        public PipelineResult get(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            this.set(this.res);
            return (PipelineResult)super.get(timeout, timeUnit);
        }

        @Override
        public PipelineExecution.Status getStatus() {
            return this.isDone() ? PipelineExecution.Status.SUCCEEDED : PipelineExecution.Status.READY;
        }

        @Override
        public PipelineResult getResult() {
            return this.isDone() ? this.res : null;
        }

        @Override
        public void kill() {
        }
    }
}

