/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mem.collect;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.crunch.CachingOptions;
import org.apache.crunch.FilterFn;
import org.apache.crunch.GroupingOptions;
import org.apache.crunch.MapFn;
import org.apache.crunch.PCollection;
import org.apache.crunch.PGroupedTable;
import org.apache.crunch.PObject;
import org.apache.crunch.PTable;
import org.apache.crunch.Pair;
import org.apache.crunch.Target;
import org.apache.crunch.impl.mem.collect.MemCollection;
import org.apache.crunch.impl.mem.collect.MemGroupedTable;
import org.apache.crunch.lib.Aggregate;
import org.apache.crunch.lib.Cogroup;
import org.apache.crunch.lib.Join;
import org.apache.crunch.lib.PTables;
import org.apache.crunch.materialize.MaterializableMap;
import org.apache.crunch.materialize.pobject.MapPObject;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;

public class MemTable<K, V>
extends MemCollection<Pair<K, V>>
implements PTable<K, V> {
    private PTableType<K, V> ptype;

    public MemTable(Iterable<Pair<K, V>> collect) {
        this(collect, (PTableType<K, V>)null, (String)null);
    }

    public MemTable(Iterable<Pair<K, V>> collect, PTableType<K, V> ptype, String name) {
        super(collect, ptype, name);
        this.ptype = ptype;
    }

    @Override
    public PTable<K, V> union(PTable<K, V> other) {
        return this.union(new PTable[]{other});
    }

    @Override
    public PTable<K, V> union(PTable<K, V> ... others) {
        ArrayList values = Lists.newArrayList();
        values.addAll(this.getCollection());
        for (PTable<K, V> ptable : others) {
            for (Pair p : ptable.materialize()) {
                values.add(p);
            }
        }
        return new MemTable<K, V>(values, others[0].getPTableType(), null);
    }

    @Override
    public PGroupedTable<K, V> groupByKey() {
        return this.groupByKey(null);
    }

    @Override
    public PGroupedTable<K, V> groupByKey(int numPartitions) {
        return this.groupByKey(null);
    }

    @Override
    public PGroupedTable<K, V> groupByKey(GroupingOptions options) {
        return new MemGroupedTable(this, options);
    }

    @Override
    public PTable<K, V> write(Target target) {
        super.write(target);
        return this;
    }

    @Override
    public PTable<K, V> write(Target target, Target.WriteMode writeMode) {
        this.getPipeline().write(this, target, writeMode);
        return this;
    }

    @Override
    public PTable<K, V> cache() {
        return this;
    }

    @Override
    public PTable<K, V> cache(CachingOptions options) {
        return this;
    }

    @Override
    public PTableType<K, V> getPTableType() {
        return this.ptype;
    }

    @Override
    public PType<K> getKeyType() {
        if (this.ptype != null) {
            return this.ptype.getKeyType();
        }
        return null;
    }

    @Override
    public PType<V> getValueType() {
        if (this.ptype != null) {
            return this.ptype.getValueType();
        }
        return null;
    }

    @Override
    public PTable<K, V> filter(FilterFn<Pair<K, V>> filterFn) {
        return this.parallelDo(filterFn, this.getPTableType());
    }

    @Override
    public PTable<K, V> filter(String name, FilterFn<Pair<K, V>> filterFn) {
        return this.parallelDo(name, filterFn, this.getPTableType());
    }

    @Override
    public <U> PTable<K, U> mapValues(MapFn<V, U> mapFn, PType<U> ptype) {
        return PTables.mapValues(this, mapFn, ptype);
    }

    @Override
    public <U> PTable<K, U> mapValues(String name, MapFn<V, U> mapFn, PType<U> ptype) {
        return PTables.mapValues(name, this, mapFn, ptype);
    }

    @Override
    public <K2> PTable<K2, V> mapKeys(MapFn<K, K2> mapFn, PType<K2> ptype) {
        return PTables.mapKeys(this, mapFn, ptype);
    }

    @Override
    public <K2> PTable<K2, V> mapKeys(String name, MapFn<K, K2> mapFn, PType<K2> ptype) {
        return PTables.mapKeys(name, this, mapFn, ptype);
    }

    @Override
    public PTable<K, V> top(int count) {
        return Aggregate.top(this, count, true);
    }

    @Override
    public PTable<K, V> bottom(int count) {
        return Aggregate.top(this, count, false);
    }

    @Override
    public PTable<K, Collection<V>> collectValues() {
        return Aggregate.collectValues(this);
    }

    @Override
    public <U> PTable<K, Pair<V, U>> join(PTable<K, U> other) {
        return Join.join(this, other);
    }

    @Override
    public <U> PTable<K, Pair<Collection<V>, Collection<U>>> cogroup(PTable<K, U> other) {
        return Cogroup.cogroup(this, other);
    }

    @Override
    public PCollection<K> keys() {
        return PTables.keys(this);
    }

    @Override
    public PCollection<V> values() {
        return PTables.values(this);
    }

    @Override
    public Map<K, V> materializeToMap() {
        return new MaterializableMap(this.materialize());
    }

    @Override
    public PObject<Map<K, V>> asMap() {
        return new MapPObject(this);
    }
}

